package kuzumeji.action.list.erp.mng;
import kuzumeji.action.list.BaseEntityQuery;
import kuzumeji.entity.erp.mng.Activity;
import org.jboss.seam.annotations.Name;
@Name("activityList")
public class ActivityList extends BaseEntityQuery<Activity> {
    private static final String EJBQL = "select activity from Activity activity";
    private static final String[] RESTRICTIONS = { "(activity.cat) = #{activityList.activity.cat}",
            "(activity.code) like (concat(#{activityList.activity.code},'%'))",
            "(activity.text) like (concat(#{activityList.activity.text},'%'))",
            "(activity.fullName) like (concat(#{activityList.activity.fullName},'%'))",
            "(activity.note) like (concat(#{activityList.activity.note},'%'))",
            "(activity.shortName) like (concat(#{activityList.activity.shortName},'%'))",
            "(activity.sts) = #{activityList.activity.sts}", };
    private Activity activity = new Activity();
    public ActivityList() {
        super(EJBQL, RESTRICTIONS);
    }
    public Activity getActivity() {
        return activity;
    }
}
