// //////////////////////////////////////////////////////////
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 2, June 1991 ____
// _________ http://www.gnu.org/licenses/gpl.html __________
// File: $Id: Contact.java 1669 2009-11-08 11:43:31Z kuzumeji $
// //////////////////////////////////////////////////////////
package kuzumeji.entity;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.hibernate.validator.Email;
import org.hibernate.validator.Length;
/**
 * Contact
 * @author nilcy
 */
@Embeddable
public class Contact implements Serializable, Cloneable {
    /** S/N */
    private static final long serialVersionUID = -4852304813876570230L;
    /** Zip */
    private String zip;
    /** Addr1 */
    private String addr1;
    /** Addr2 */
    private String addr2;
    /** Tel */
    private String tel;
    /** Mail */
    private String mail;
    /** Web */
    private String web;
    /** Constructor */
    public Contact() {
        // NOP
    }
    /**
     * getter for Zip
     * @return Zip
     */
    @Column(name = "zip", nullable = true)
    @Length(min = 3, max = 8)
    public String getZip() {
        return this.zip;
    }
    /**
     * setter for Zip
     * @param aZip Zip
     */
    public void setZip(String aZip) {
        this.zip = aZip;
    }
    /**
     * getter for Addr1
     * @return Addr1
     */
    @Column(name = "addr1", nullable = true)
    @Length(max = 100)
    public String getAddr1() {
        return this.addr1;
    }
    /**
     * setter for Addr1
     * @param aAddr Addr1
     */
    public void setAddr1(String aAddr) {
        this.addr1 = aAddr;
    }
    /**
     * getter for Addr2
     * @return Addr2
     */
    @Column(name = "addr2", nullable = true)
    @Length(max = 100)
    public String getAddr2() {
        return this.addr2;
    }
    /**
     * setter for Addr2
     * @param aAddr2 Addr2
     */
    public void setAddr2(String aAddr2) {
        this.addr2 = aAddr2;
    }
    /**
     * getter for Tel
     * @return Tel
     */
    @Column(name = "tel", nullable = true)
    @Length(min = 4, max = 20)
    public String getTel() {
        return this.tel;
    }
    /**
     * setter for Tel
     * @param aTel Tel
     */
    public void setTel(String aTel) {
        this.tel = aTel;
    }
    /**
     * getter for Mail
     * @return Mail
     */
    @Column(name = "mail", nullable = true)
    @Length(max = 60)
    @Email
    public String getMail() {
        return this.mail;
    }
    /**
     * setter for Mail
     * @param aMail Mail
     */
    public void setMail(String aMail) {
        this.mail = aMail;
    }
    /**
     * getter for Web
     * @return Web
     */
    @Column(name = "web", nullable = true)
    @Length(max = 80)
    public String getWeb() {
        return this.web;
    }
    /**
     * setter for Web
     * @param aWeb Web
     */
    public void setWeb(String aWeb) {
        this.web = aWeb;
    }
    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
    @Override
    public Object clone() {
        try {
            return super.clone();
        } catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }
}
