// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: TrackEntity.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.entity;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import kuzumeji.entity.idm.User;
/**
 * TrackEntity
 * @author nilcy
 */
@MappedSuperclass
public class TrackEntity extends BaseEntity {
    /** S/N */
    private static final long serialVersionUID = -770727667883181990L;
    /** Create User */
    private String createUser;
    /** Create Time stamp */
    private Date createTime;
    /** Update User */
    private String updateUser;
    /** Update Time stamp */
    private Date updateTime;
    /** Constructor */
    public TrackEntity() {
        // NOP
    }
    /**
     * @return Create User
     */
    @Column(name = "create_user", nullable = true)
    public String getCreateUser() {
        return this.createUser;
    }
    /**
     * @param aCreateUser Create User
     */
    public void setCreateUser(String aCreateUser) {
        this.createUser = aCreateUser;
    }
    /**
     * @return Create Time stamp
     */
    @Column(name = "create_time", nullable = true)
    @Basic
    @Temporal(TemporalType.TIMESTAMP)
    public Date getCreateTime() {
        return this.createTime;
    }
    /**
     * @param aCreateTime Create Time stamp
     */
    public void setCreateTime(Date aCreateTime) {
        this.createTime = aCreateTime;
    }
    /**
     * @return Update User
     */
    @Column(name = "update_user", nullable = true)
    public String getUpdateUser() {
        return this.updateUser;
    }
    /**
     * @param aUpdateUser Update User
     */
    public void setUpdateUser(String aUpdateUser) {
        this.updateUser = aUpdateUser;
    }
    /**
     * @return Update Time stamp
     */
    @Column(name = "update_time", nullable = true)
    @Basic
    @Temporal(TemporalType.TIMESTAMP)
    public Date getUpdateTime() {
        return this.updateTime;
    }
    /**
     * @param aUpdateTime Update Time stamp
     */
    public void setUpdateTime(Date aUpdateTime) {
        this.updateTime = aUpdateTime;
    }
    /**
     * Set on Persist
     * @param aUser Create User
     */
    @Transient
    public void setOnPersist(User aUser) {
        this.createUser = getUsername(aUser);
        this.createTime = new Date();
        setOnUpdate(aUser);
    }
    /**
     * Set on Update
     * @param aUser Update User
     */
    @Transient
    public void setOnUpdate(User aUser) {
        this.updateUser = getUsername(aUser);
        this.updateTime = new Date();
    }
     /**
     * @param aUser User
     * @return User Name
     */
    @Transient
    private String getUsername(User aUser) {
        if (aUser == null) return "nobody";
        return aUser.getAccount();
    }
}
