// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $Id$
// ============================================================
package kuzumeji.entity.crm;
import kuzumeji.entity.TrackEntity;
import kuzumeji.entity.erp.Customer;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.validator.Length;
/**
 * Contactlog
 * @author nilcy
 */
@Entity
@Table(name = "contactlog")
public class Contactlog extends TrackEntity {
    /** S/N */
    private static final long serialVersionUID = -1934117330709440390L;
    /** Customer */
    private Customer customer;
    /** TimeStamp */
    private Date time = new Date();
    /** UserName */
    private String user;
    /** Title */
    private String title;
    /** Text */
    private String text;
    /** Constructor */
    public Contactlog() {
        // NOP
    }
    /**
     * getter for Customer
     * @return Customer
     */
    @ManyToOne(cascade = CascadeType.REFRESH, fetch = FetchType.LAZY)
    @JoinColumn(name = "customer_id", referencedColumnName = "id", nullable = true, insertable = true, updatable = true)
    public Customer getCustomer() {
        return this.customer;
    }
    /**
     * setter for Customer
     * @param aCustomer Customer
     */
    public void setCustomer(Customer aCustomer) {
        this.customer = aCustomer;
    }
    /**
     * getter for TimeStamp
     * @return TimeStamp
     */
    @Column(name = "time", nullable = false)
    @Basic
    @Temporal(TemporalType.TIMESTAMP)
    public Date getTime() {
        return this.time;
    }
    /**
     * setter for TimeStamp
     * @param aTime TimeStamp
     */
    public void setTime(Date aTime) {
        this.time = aTime;
    }
    /**
     * getter for UserName
     * @return UserName
     */
    @Column(name = "user", nullable = false)
    public String getUser() {
        return this.user;
    }
    /**
     * setter for UserName
     * @param aUser UserName
     */
    public void setUser(String aUser) {
        this.user = aUser;
    }
    /**
     * getter for Title
     * @return Title
     */
    @Column(name = "title", nullable = false)
    @Length(max = 100)
    public String getTitle() {
        return this.title;
    }
    /**
     * setter for Title
     * @param aTitle Title
     */
    public void setTitle(String aTitle) {
        this.title = aTitle;
    }
    /**
     * getter for Text
     * @return Text
     */
    @Column(name = "text", nullable = false)
    @Length(max = 100)
    public String getText() {
        return this.text;
    }
    /**
     * setter for Text
     * @param aText Text
     */
    public void setText(String aText) {
        this.text = aText;
    }
}
