// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $Id$
// ============================================================
package kuzumeji.entity.crm;
import kuzumeji.entity.TrackEntity;
import kuzumeji.entity.erp.Customer;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
/**
 * recency, frequency, monetary analysis
 * @author nilcy
 */
@Entity
@Table(name = "rfm")
public class RFM extends TrackEntity {
    /** S/N */
    private static final long serialVersionUID = 5253567851568436797L;
    /** Customer */
    private Customer customer;
    /** Last purchase date */
    private Date recency;
    /** Total purchase count */
    private Long frequency;
    /** Total purchase price */
    private Long monetary;
    /** Constructor */
    public RFM() {
        // NOP
    }
    /**
     * @return Customer
     */
    @OneToOne(optional = false)
    @PrimaryKeyJoinColumn(name = "id", referencedColumnName = "id")
    public Customer getCustomer() {
        return this.customer;
    }
    /**
     * @param aCustomer Customer
     */
    public void setCustomer(Customer aCustomer) {
        this.customer = aCustomer;
    }
    /**
     * getter for Last purchase date
     * @return Last purchase date
     */
    @Column(name = "recency", nullable = true, insertable = true, updatable = true)
    @Basic
    @Temporal(TemporalType.DATE)
    public Date getRecency() {
        return this.recency;
    }
    /**
     * setter for Last purchase date
     * @param aRecency Last purchase date
     */
    public void setRecency(Date aRecency) {
        this.recency = aRecency;
    }
    /**
     * getter for Total purchase count
     * @return Total purchase count
     */
    @Column(name = "frequency", nullable = true, insertable = true, updatable = true)
    public Long getFrequency() {
        return this.frequency;
    }
    /**
     * setter for Total purchase count
     * @param aFrequency Total purchase count
     */
    public void setFrequency(Long aFrequency) {
        this.frequency = aFrequency;
    }
    /**
     * getter for Total purchase price
     * @return Total purchase price
     */
    @Column(name = "monetary", nullable = true, insertable = true, updatable = true)
    public Long getMonetary() {
        return this.monetary;
    }
    /**
     * setter for Total purchase price
     * @param aMonetary Total purchase price
     */
    public void setMonetary(Long aMonetary) {
        this.monetary = aMonetary;
    }
}
