// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: Partner.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.entity.erp;
import kuzumeji.entity.Party;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
/**
 * Partner
 * @author nilcy
 */
@Entity
@Table(name = "partner")
@Inheritance(strategy = InheritanceType.JOINED)
public class Partner extends Party {
    /** S/N */
    private static final long serialVersionUID = 3436134928297544914L;
    /** Helper List */
    private List<Helper> helpers = new ArrayList<Helper>(0);
    /**
     * Constructor
     */
    public Partner() {
        // NOP
    }
    /**
     * @return Helper List
     */
    @OneToMany(fetch = FetchType.LAZY, mappedBy = "partner")
    public List<Helper> getHelpers() {
        return this.helpers;
    }
    /**
     * @param aHelpers Helper List
     */
    public void setHelpers(List<Helper> aHelpers) {
        this.helpers = aHelpers;
    }
}
