// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: Worker.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.entity.erp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import kuzumeji.entity.Person;
import kuzumeji.entity.erp.mng.ActualExpense;
import kuzumeji.entity.erp.mng.ActualPeriod;
import kuzumeji.entity.erp.mng.PlanWork;
import kuzumeji.entity.idm.User;
/**
 * Worker
 * @author nilcy
 */
@Entity
@Table(name = "worker")
@Inheritance(strategy = InheritanceType.JOINED)
public class Worker extends Person {
    /** S/N */
    private static final long serialVersionUID = 6611944805648846121L;
    /** Team */
    private Team team;
    /** Login User */
    private User user;
    /** PlanWork List */
    private List<PlanWork> planWorks = new ArrayList<PlanWork>(0);
    /** ActualPeriod List */
    private List<ActualPeriod> actualPeriods = new ArrayList<ActualPeriod>(0);
    /** Partner ActualExpense List */
    private List<ActualExpense> partnerActualExpenses = new ArrayList<ActualExpense>(0);
    /**
     * Constructor
     */
    public Worker() {
        // NOP
    }
    /**
     * @return Team
     */
    @ManyToOne(cascade = CascadeType.REFRESH, fetch = FetchType.LAZY)
    @JoinColumn(name = "team_id", referencedColumnName = "id", nullable = false, insertable = true, updatable = true)
    public Team getTeam() {
        return this.team;
    }
    /**
     * @param aTeam Team
     */
    public void setTeam(Team aTeam) {
        this.team = aTeam;
    }
    /**
     * @return Login User
     */
    @OneToOne(cascade = CascadeType.REFRESH, fetch = FetchType.LAZY)
    @JoinColumn(name = "user_id", referencedColumnName = "id", nullable = true, insertable = true, updatable = true)
    public User getUser() {
        return this.user;
    }
    /**
     * @param aUser Login User
     */
    public void setUser(User aUser) {
        this.user = aUser;
    }
    /**
     * @return PlanWork List
     */
    @OneToMany(fetch = FetchType.LAZY, mappedBy = "worker")
    public List<PlanWork> getPlanWorks() {
        return this.planWorks;
    }
    /**
     * @param aPlanWorks PlanWork List
     */
    public void setPlanWorks(List<PlanWork> aPlanWorks) {
        this.planWorks = aPlanWorks;
    }
    /**
     * @return ActualPeriod List
     */
    @OneToMany(fetch = FetchType.LAZY, mappedBy = "worker")
    public List<ActualPeriod> getActualPeriods() {
        return this.actualPeriods;
    }
    /**
     * @param aActualPeriods ActualPeriod List
     */
    public void setActualPeriods(List<ActualPeriod> aActualPeriods) {
        this.actualPeriods = aActualPeriods;
    }
    /**
     * @return Partner Partner ActualExpense List
     */
    @OneToMany(fetch = FetchType.LAZY, mappedBy = "partner")
    public List<ActualExpense> getPartnerActualExpenses() {
        return this.partnerActualExpenses;
    }
    /**
     * @param aPartnerActualExpenses Partner Partner ActualExpense List
     */
    public void setPartnerActualExpenses(List<ActualExpense> aPartnerActualExpenses) {
        this.partnerActualExpenses = aPartnerActualExpenses;
    }
}
