// //////////////////////////////////////////////////////////
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 2, June 1991 ____
// _________ http://www.gnu.org/licenses/gpl.html __________
// File: $Id: Contact.java 1669 2009-11-08 11:43:31Z kuzumeji $
// //////////////////////////////////////////////////////////
package kuzumeji.entity.erp.fin.bs.asset;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.Transient;
/**
 * Current Assets
 * @author nilcy
 */
@Embeddable
public class CurrentAssets implements Serializable, Cloneable {
    /** S/N */
    private static final long serialVersionUID = -2283478328510412778L;
    /** Petty Cash */
    private Long pettyCash;
    /** Ordinary-Account */
    private Long ordinaryAccount;
    /** Checking-Account */
    private CheckingAccount checkingAccount;
    /** Securities */
    private Securities securities;
    /**
     * getter for Petty Cash
     * @return Petty Cash
     */
    @Column(name = "petty_cash", nullable = true, insertable = true, updatable = true)
    public Long getPettyCash() {
        return this.pettyCash;
    }
    /**
     * setter for Petty Cash
     * @param aPettyCash Petty Cash
     */
    public void setPettyCash(Long aPettyCash) {
        this.pettyCash = aPettyCash;
    }
    /**
     * getter for Ordinary-Account
     * @return Ordinary-Account
     */
    @Column(name = "ordinary_account", nullable = true, insertable = true, updatable = true)
    public Long getOrdinaryAccount() {
        return this.ordinaryAccount;
    }
    /**
     * setter for Ordinary-Account
     * @param aOrdinaryAccount Ordinary-Account
     */
    public void setOrdinaryAccount(Long aOrdinaryAccount) {
        this.ordinaryAccount = aOrdinaryAccount;
    }
    /**
     * getter for Checking-Account
     * @return Checking-Account
     */
    @Embedded
    public CheckingAccount getCheckingAccount() {
        return this.checkingAccount;
    }
    /**
     * setter for Checking-Account
     * @param aCheckingAccount Checking-Account
     */
    public void setCheckingAccount(CheckingAccount aCheckingAccount) {
        this.checkingAccount = aCheckingAccount;
    }
    /**
     * getter for Securities
     * @return Securities
     */
    @Embedded
    public Securities getSecurities() {
        return this.securities;
    }
    /**
     * setter for Securities
     * @param aSecurities Securities
     */
    public void setSecurities(Securities aSecurities) {
        this.securities = aSecurities;
    }
    // ================================================================
    /**
     * calc sum()
     * @return sum()
     */
    @Transient
    public long sum() {
        return nvl(this.pettyCash) + nvl(this.ordinaryAccount)
                + ((this.checkingAccount == null) ? 0L : this.checkingAccount.sum())
                + ((this.securities == null) ? 0L : this.securities.sum());
    }
    /**
     * nvl
     * @param aNum number
     * @return nvl(aNum)
     */
    @Transient
    private long nvl(Long aNum) {
        return (aNum == null) ? 0L : aNum;
    }
}
