// //////////////////////////////////////////////////////////
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 2, June 1991 ____
// _________ http://www.gnu.org/licenses/gpl.html __________
// File: $Id: Contact.java 1669 2009-11-08 11:43:31Z kuzumeji $
// //////////////////////////////////////////////////////////
package kuzumeji.entity.erp.fin.bs.asset;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
/**
 * Intangible Assets
 * @author nilcy
 */
@Embeddable
public class IntangibleAssets implements Serializable, Cloneable {
    /** S/N */
    private static final long serialVersionUID = 1738054892412344410L;
    /** Goodwill */
    private Long goodwill;
    /** Patents */
    private Long patents;
    /** Model utility rights */
    private Long modelUtilityRights;
    /** Design rights */
    private Long designRights;
    /** Copyrights */
    private Long copyrights;
    /** Trade marks */
    private Long tradeMarks;
    /** Fisheries rights */
    private Long fisheriesRights;
    /** Lease of land */
    private Long leaseOfLand;
    /** Mining rights */
    private Long miningRights;
    /** Software */
    private Long software;
    /**
     * getter for Goodwill
     * @return Goodwill
     */
    @Column(name = "goodwill", nullable = true, insertable = true, updatable = true)
    public Long getGoodwill() {
        return this.goodwill;
    }
    /**
     * setter for Goodwill
     * @param aGoodwill Goodwill
     */
    public void setGoodwill(Long aGoodwill) {
        this.goodwill = aGoodwill;
    }
    /**
     * getter for Patents
     * @return Patents
     */
    @Column(name = "patents", nullable = true, insertable = true, updatable = true)
    public Long getPatents() {
        return this.patents;
    }
    /**
     * setter for Patents
     * @param aPatents Patents
     */
    public void setPatents(Long aPatents) {
        this.patents = aPatents;
    }
    /**
     * getter for Model utility rights
     * @return Model utility rights
     */
    @Column(name = "model_utility_rights", nullable = true, insertable = true, updatable = true)
    public Long getModelUtilityRights() {
        return this.modelUtilityRights;
    }
    /**
     * setter for Model utility rights
     * @param aModelUtilityRights Model utility rights
     */
    public void setModelUtilityRights(Long aModelUtilityRights) {
        this.modelUtilityRights = aModelUtilityRights;
    }
    /**
     * getter for Design rights
     * @return Design rights
     */
    @Column(name = "design_rights", nullable = true, insertable = true, updatable = true)
    public Long getDesignRights() {
        return this.designRights;
    }
    /**
     * setter for Design rights
     * @param aDesignRights Design rights
     */
    public void setDesignRights(Long aDesignRights) {
        this.designRights = aDesignRights;
    }
    /**
     * getter for Copyrights
     * @return Copyrights
     */
    @Column(name = "copyrights", nullable = true, insertable = true, updatable = true)
    public Long getCopyrights() {
        return this.copyrights;
    }
    /**
     * setter for Copyrights
     * @param aCopyrights Copyrights
     */
    public void setCopyrights(Long aCopyrights) {
        this.copyrights = aCopyrights;
    }
    /**
     * getter for Trade marks
     * @return Trade marks
     */
    @Column(name = "trade_marks", nullable = true, insertable = true, updatable = true)
    public Long getTradeMarks() {
        return this.tradeMarks;
    }
    /**
     * setter for Trade marks
     * @param aTradeMarks Trade marks
     */
    public void setTradeMarks(Long aTradeMarks) {
        this.tradeMarks = aTradeMarks;
    }
    /**
     * getter for Fisheries rights
     * @return Fisheries rights
     */
    @Column(name = "fisheries_rights", nullable = true, insertable = true, updatable = true)
    public Long getFisheriesRights() {
        return this.fisheriesRights;
    }
    /**
     * setter for Fisheries rights
     * @param aFisheriesRights Fisheries rights
     */
    public void setFisheriesRights(Long aFisheriesRights) {
        this.fisheriesRights = aFisheriesRights;
    }
    /**
     * getter for Lease of land
     * @return Lease of land
     */
    @Column(name = "lease_of_land", nullable = true, insertable = true, updatable = true)
    public Long getLeaseOfLand() {
        return this.leaseOfLand;
    }
    /**
     * setter for Lease of land
     * @param aLeaseOfLand Lease of land
     */
    public void setLeaseOfLand(Long aLeaseOfLand) {
        this.leaseOfLand = aLeaseOfLand;
    }
    /**
     * getter for Mining rights
     * @return Mining rights
     */
    @Column(name = "mining_rights", nullable = true, insertable = true, updatable = true)
    public Long getMiningRights() {
        return this.miningRights;
    }
    /**
     * setter for Mining rights
     * @param aMiningRights Mining rights
     */
    public void setMiningRights(Long aMiningRights) {
        this.miningRights = aMiningRights;
    }
    /**
     * getter for Software
     * @return Software
     */
    @Column(name = "software", nullable = true, insertable = true, updatable = true)
    public Long getSoftware() {
        return this.software;
    }
    /**
     * setter for Software
     * @param aSoftware Software
     */
    public void setSoftware(Long aSoftware) {
        this.software = aSoftware;
    }
    // ================================================================
    /**
     * calc sum()
     * @return sum()
     */
    @Transient
    public long sum() {
        return nvl(this.goodwill) + nvl(this.patents) + nvl(this.modelUtilityRights) + nvl(this.designRights)
                + nvl(this.copyrights) + nvl(this.tradeMarks) + nvl(this.fisheriesRights) + nvl(this.leaseOfLand)
                + nvl(this.miningRights) + nvl(this.software);
    }
    /**
     * nvl
     * @param aNum number
     * @return nvl(aNum)
     */
    @Transient
    private long nvl(Long aNum) {
        return (aNum == null) ? 0L : aNum;
    }
}
