// //////////////////////////////////////////////////////////
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 2, June 1991 ____
// _________ http://www.gnu.org/licenses/gpl.html __________
// File: $Id: Contact.java 1669 2009-11-08 11:43:31Z kuzumeji $
// //////////////////////////////////////////////////////////
package kuzumeji.entity.erp.fin.bs.asset;
import java.io.Serializable;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.Transient;
/**
 * Securities
 * @author nilcy
 */
@Embeddable
public class Securities implements Serializable, Cloneable {
    /** S/N */
    private static final long serialVersionUID = -6280864804031258824L;
    /** Inventories */
    private Inventories inventories;
    /** Non-Receivables */
    private NonReceivables nonReceivables;
    /**
     * getter for Inventories
     * @return Inventories
     */
    @Embedded
    public Inventories getInventories() {
        return this.inventories;
    }
    /**
     * setter for Inventories
     * @param aInventories Inventories
     */
    public void setInventories(Inventories aInventories) {
        this.inventories = aInventories;
    }
    /**
     * getter for Non-Receivables
     * @return Non-Receivables
     */
    @Embedded
    public NonReceivables getNonReceivables() {
        return this.nonReceivables;
    }
    /**
     * setter for Non-Receivables
     * @param aNonReceivables Non-Receivables
     */
    public void setNonReceivables(NonReceivables aNonReceivables) {
        this.nonReceivables = aNonReceivables;
    }
    // ================================================================
    /**
     * calc sum()
     * @return sum()
     */
    @Transient
    public long sum() {
        return ((this.inventories == null) ? 0L : this.inventories.sum())
                + ((this.nonReceivables == null) ? 0L : this.nonReceivables.sum());
    }
}
