// //////////////////////////////////////////////////////////
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 2, June 1991 ____
// _________ http://www.gnu.org/licenses/gpl.html __________
// File: $Id: Contact.java 1669 2009-11-08 11:43:31Z kuzumeji $
// //////////////////////////////////////////////////////////
package kuzumeji.entity.erp.fin.bs.asset;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
/**
 * Tangible Assets
 * @author nilcy
 */
@Embeddable
public class TangibleAssets implements Serializable, Cloneable {
    /** S/N */
    private static final long serialVersionUID = 1295056298147721688L;
    /** Land */
    private Long land;
    /** Building */
    private Long building;
    /** Construction in progress */
    private Long construction;
    /** Equipment */
    private Long equipment;
    /** Machinery and equipment */
    private Long machinery;
    /** Automotive equipment, Delivery equipment, Vehicles */
    private Long vehicles;
    /**
     * getter for Land
     * @return Land
     */
    @Column(name = "land", nullable = true, insertable = true, updatable = true)
    public Long getLand() {
        return this.land;
    }
    /**
     * setter for Land
     * @param aLand Land
     */
    public void setLand(Long aLand) {
        this.land = aLand;
    }
    /**
     * getter for Building
     * @return Building
     */
    @Column(name = "building", nullable = true, insertable = true, updatable = true)
    public Long getBuilding() {
        return this.building;
    }
    /**
     * setter for Building
     * @param aBuilding Building
     */
    public void setBuilding(Long aBuilding) {
        this.building = aBuilding;
    }
    /**
     * getter for Construction in progress
     * @return Construction in progress
     */
    @Column(name = "construction", nullable = true, insertable = true, updatable = true)
    public Long getConstruction() {
        return this.construction;
    }
    /**
     * setter for Construction in Construction in progress
     * @param aConstruction construction
     */
    public void setConstruction(Long aConstruction) {
        this.construction = aConstruction;
    }
    /**
     * getter for Equipment
     * @return Equipment
     */
    @Column(name = "equipment", nullable = true, insertable = true, updatable = true)
    public Long getEquipment() {
        return this.equipment;
    }
    /**
     * setter for Equipment
     * @param aEquipment Equipment
     */
    public void setEquipment(Long aEquipment) {
        this.equipment = aEquipment;
    }
    /**
     * getter for Machinery and equipment
     * @return Machinery and equipment
     */
    @Column(name = "machinery", nullable = true, insertable = true, updatable = true)
    public Long getMachinery() {
        return this.machinery;
    }
    /**
     * setter for Machinery and equipment
     * @param aMachinery Machinery and equipment
     */
    public void setMachinery(Long aMachinery) {
        this.machinery = aMachinery;
    }
    /**
     * getter for Automotive equipment, Delivery equipment, Vehicles
     * @return Automotive equipment, Delivery equipment, Vehicles
     */
    @Column(name = "vehicles", nullable = true, insertable = true, updatable = true)
    public Long getVehicles() {
        return this.vehicles;
    }
    /**
     * setter for Automotive equipment, Delivery equipment, Vehicles
     * @param aVehicles Automotive equipment, Delivery equipment, Vehicles
     */
    public void setVehicles(Long aVehicles) {
        this.vehicles = aVehicles;
    }
    // ================================================================
    /**
     * calc sum()
     * @return sum()
     */
    @Transient
    public long sum() {
        return nvl(this.land) + nvl(this.building) + nvl(this.construction) + nvl(this.equipment) + nvl(this.machinery)
                + nvl(this.vehicles);
    }
    /**
     * nvl
     * @param aNum number
     * @return nvl(aNum)
     */
    @Transient
    private long nvl(Long aNum) {
        return (aNum == null) ? 0L : aNum;
    }
}
