// //////////////////////////////////////////////////////////
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 2, June 1991 ____
// _________ http://www.gnu.org/licenses/gpl.html __________
// File: $Id: Contact.java 1669 2009-11-08 11:43:31Z kuzumeji $
// //////////////////////////////////////////////////////////
package kuzumeji.entity.erp.fin.bs.liability;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
/**
 * Current Liability
 * @author nilcy
 */
@Embeddable
public class CurrentLiability implements Serializable, Cloneable {
    /** S/N */
    private static final long serialVersionUID = -2130347852916314101L;
    /** Notes payable */
    private Long notesPayable;
    /** Accounts payable-trade */
    private Long accountsPayableTrade;
    /** Short-term debt */
    private Long shortTermDebt;
    /** Long-term debt within a year */
    private Long longTermDebtWithinYear;
    /** Accounts payable-other */
    private Long accountsPayableOther;
    /** Accrued expense */
    private Long accruedExpense;
    /** Receipt in advance */
    private Long receiptInAdvance;
    /** Receipt in trust */
    private Long receiptInTrust;
    /** Income in advance */
    private Long incomeInAdvance;
    /** Allowance for bonus */
    private Long allowanceForBonus;
    /** Income taxes payable */
    private Long incomeTaxesPayable;
    /** Consumption tax payable */
    private Long consumptionTaxPayable;
    /**
     * getter for Notes payable
     * @return Notes payable
     */
    @Column(name = "notes_payable", nullable = true, insertable = true, updatable = true)
    public Long getNotesPayable() {
        return this.notesPayable;
    }
    /**
     * setter for Notes payable
     * @param aNotesPayable Notes payable
     */
    public void setNotesPayable(Long aNotesPayable) {
        this.notesPayable = aNotesPayable;
    }
    /**
     * getter for Accounts payable-trade
     * @return Accounts payable-trade
     */
    @Column(name = "accounts_payable_trade", nullable = true, insertable = true, updatable = true)
    public Long getAccountsPayableTrade() {
        return this.accountsPayableTrade;
    }
    /**
     * setter for Accounts payable-trade
     * @param aAccountsPayableTrade Accounts payable-trade
     */
    public void setAccountsPayableTrade(Long aAccountsPayableTrade) {
        this.accountsPayableTrade = aAccountsPayableTrade;
    }
    /**
     * getter for Short-term debt
     * @return Short-term debt
     */
    @Column(name = "short_term_debt", nullable = true, insertable = true, updatable = true)
    public Long getShortTermDebt() {
        return this.shortTermDebt;
    }
    /**
     * setter for Short-term debt
     * @param aShortTermDebt Short-term debt
     */
    public void setShortTermDebt(Long aShortTermDebt) {
        this.shortTermDebt = aShortTermDebt;
    }
    /**
     * getter for Long-term debt within a year
     * @return Long-term debt within a year
     */
    @Column(name = "long_term_debt_within_year", nullable = true, insertable = true, updatable = true)
    public Long getLongTermDebtWithinYear() {
        return this.longTermDebtWithinYear;
    }
    /**
     * setter for Long-term debt within a year
     * @param aLongTermDebtWithinYear Long-term debt within a year
     */
    public void setLongTermDebtWithinYear(Long aLongTermDebtWithinYear) {
        this.longTermDebtWithinYear = aLongTermDebtWithinYear;
    }
    /**
     * getter for Accounts payable-other
     * @return Accounts payable-other
     */
    @Column(name = "accounts_payable_other", nullable = true, insertable = true, updatable = true)
    public Long getAccountsPayableOther() {
        return this.accountsPayableOther;
    }
    /**
     * setter for Accounts payable-other
     * @param aAccountsPayableOther Accounts payable-other
     */
    public void setAccountsPayableOther(Long aAccountsPayableOther) {
        this.accountsPayableOther = aAccountsPayableOther;
    }
    /**
     * getter for Accrued expense
     * @return Accrued expense
     */
    @Column(name = "accrued_expense", nullable = true, insertable = true, updatable = true)
    public Long getAccruedExpense() {
        return this.accruedExpense;
    }
    /**
     * setter for Accrued expense
     * @param aAccruedExpense Accrued expense
     */
    public void setAccruedExpense(Long aAccruedExpense) {
        this.accruedExpense = aAccruedExpense;
    }
    /**
     * getter for Receipt in advance
     * @return Receipt in advance
     */
    @Column(name = "receiptIn_advance", nullable = true, insertable = true, updatable = true)
    public Long getReceiptInAdvance() {
        return this.receiptInAdvance;
    }
    /**
     * setter for Receipt in advance
     * @param aReceiptInAdvance Receipt in advance
     */
    public void setReceiptInAdvance(Long aReceiptInAdvance) {
        this.receiptInAdvance = aReceiptInAdvance;
    }
    /**
     * getter for Receipt in trust
     * @return Receipt in trust
     */
    @Column(name = "receiptIn_trust", nullable = true, insertable = true, updatable = true)
    public Long getReceiptInTrust() {
        return this.receiptInTrust;
    }
    /**
     * setter for Receipt in trust
     * @param aReceiptInTrust Receipt in trust
     */
    public void setReceiptInTrust(Long aReceiptInTrust) {
        this.receiptInTrust = aReceiptInTrust;
    }
    /**
     * getter for Income in advance
     * @return Income in advance
     */
    @Column(name = "income_in_advance", nullable = true, insertable = true, updatable = true)
    public Long getIncomeInAdvance() {
        return this.incomeInAdvance;
    }
    /**
     * setter for Income in advance
     * @param aIncomeInAdvance Income in advance
     */
    public void setIncomeInAdvance(Long aIncomeInAdvance) {
        this.incomeInAdvance = aIncomeInAdvance;
    }
    /**
     * getter for Allowance for bonus
     * @return Allowance for bonus
     */
    @Column(name = "allowance_for_bonus", nullable = true, insertable = true, updatable = true)
    public Long getAllowanceForBonus() {
        return this.allowanceForBonus;
    }
    /**
     * setter for Allowance for bonus
     * @param aAllowanceForBonus Allowance for bonus
     */
    public void setAllowanceForBonus(Long aAllowanceForBonus) {
        this.allowanceForBonus = aAllowanceForBonus;
    }
    /**
     * getter for Income taxes payable
     * @return Income taxes payable
     */
    @Column(name = "income_taxes_payable", nullable = true, insertable = true, updatable = true)
    public Long getIncomeTaxesPayable() {
        return this.incomeTaxesPayable;
    }
    /**
     * setter for Income taxes payable
     * @param aIncomeTaxesPayable Income taxes payable
     */
    public void setIncomeTaxesPayable(Long aIncomeTaxesPayable) {
        this.incomeTaxesPayable = aIncomeTaxesPayable;
    }
    /**
     * getter for Consumption tax payable
     * @return Consumption tax payable
     */
    @Column(name = "consumption_tax_payable", nullable = true, insertable = true, updatable = true)
    public Long getConsumptionTaxPayable() {
        return this.consumptionTaxPayable;
    }
    /**
     * setter for Consumption tax payable
     * @param aConsumptionTaxPayable Consumption tax payable
     */
    public void setConsumptionTaxPayable(Long aConsumptionTaxPayable) {
        this.consumptionTaxPayable = aConsumptionTaxPayable;
    }
    // ================================================================
    /**
     * calc sum()
     * @return sum()
     */
    @Transient
    public long sum() {
        return nvl(this.notesPayable) + nvl(this.accountsPayableTrade) + nvl(this.shortTermDebt)
                + nvl(this.longTermDebtWithinYear) + nvl(this.accountsPayableOther) + nvl(this.accruedExpense)
                + nvl(this.receiptInAdvance) + nvl(this.receiptInTrust) + nvl(this.incomeInAdvance)
                + nvl(this.allowanceForBonus) + nvl(this.incomeTaxesPayable) + nvl(this.consumptionTaxPayable);
    }
    /**
     * nvl
     * @param aNum number
     * @return nvl(aNum)
     */
    @Transient
    private long nvl(Long aNum) {
        return (aNum == null) ? 0L : aNum;
    }
}
