// //////////////////////////////////////////////////////////
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 2, June 1991 ____
// _________ http://www.gnu.org/licenses/gpl.html __________
// File: $Id: Contact.java 1669 2009-11-08 11:43:31Z kuzumeji $
// //////////////////////////////////////////////////////////
package kuzumeji.entity.erp.fin.bs.liability;
import kuzumeji.entity.TrackEntity;
import kuzumeji.entity.erp.fin.bs.BalanceSheet;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
/**
 * Liability
 * @author nilcy
 */
@Entity
@Table(name = "bs_liability")
public class Liability extends TrackEntity {
    /** S/N */
    private static final long serialVersionUID = -236510401928594307L;
    /** Balance Sheet */
    private BalanceSheet balanceSheet;
    /** Current Liability */
    private CurrentLiability currentLiability;
    /** Long-term Liability */
    private LongTermLiability longTermLiability;
    /**
     * getter for Balance Sheet
     * @return Balance Sheet
     */
    @OneToOne(optional = false)
    @PrimaryKeyJoinColumn(name = "id", referencedColumnName = "id")
    public BalanceSheet getBalanceSheet() {
        return this.balanceSheet;
    }
    /**
     * setter for Balance Sheet
     * @param aBalanceSheet Balance Sheet
     */
    public void setBalanceSheet(BalanceSheet aBalanceSheet) {
        this.balanceSheet = aBalanceSheet;
    }
    /**
     * getter for Current Liability
     * @return Current Liability
     */
    @Embedded
    public CurrentLiability getCurrentLiability() {
        return this.currentLiability;
    }
    /**
     * setter for Current Liability
     * @param aCurrentLiability Current Liability
     */
    public void setCurrentLiability(CurrentLiability aCurrentLiability) {
        this.currentLiability = aCurrentLiability;
    }
    /**
     * getter for Long-term Liability
     * @return Long-term Liability
     */
    @Embedded
    public LongTermLiability getLongTermLiability() {
        return this.longTermLiability;
    }
    /**
     * setter for Long-term Liability
     * @param aLongTermLiability Long-term Liability
     */
    public void setLongTermLiability(LongTermLiability aLongTermLiability) {
        this.longTermLiability = aLongTermLiability;
    }
    // ================================================================
    /**
     * calc sum()
     * @return sum()
     */
    @Transient
    public long sum() {
        return ((this.currentLiability == null) ? 0L : this.currentLiability.sum())
                + ((this.longTermLiability == null) ? 0L : this.longTermLiability.sum());
    }
}
