// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: Activity.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.entity.erp.mng;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import kuzumeji.entity.TrackEntity;
import kuzumeji.entity.erp.Customer;
import kuzumeji.entity.erp.Team;
import org.hibernate.validator.Length;
/**
 * Activity
 * @author nilcy
 */
@Entity
@Table(name = "activity", uniqueConstraints = { @UniqueConstraint(columnNames = { "code" }) })
public class Activity extends TrackEntity {
    /** S/N */
    private static final long serialVersionUID = 1036855331852876944L;
    /** Customer */
    private Customer customer;
    /** Team */
    private Team team;
    /** Start Date */
    private Date startDate;
    /** End Date */
    private Date endDate;
    /** Activity Code */
    private String code;
    /** Activity Name */
    private String name;
    /** Activity Nick */
    private String nick;
    /** Text */
    private String text;
    /** Note */
    private String note;
    /** Sales */
    private Long sales = 0L;
    /** Plan Works */
    private List<PlanWork> planWorks = new ArrayList<PlanWork>(0);
    /** Plan Expenses */
    private List<PlanExpense> planExpenses = new ArrayList<PlanExpense>(0);
    /** Actuals */
    private List<ActualPeriod> actualPeriods = new ArrayList<ActualPeriod>(0);
    /** Constructor */
    public Activity() {
        // NOP
    }
    /**
     * @return Customer
     */
    @ManyToOne(cascade = CascadeType.REFRESH, fetch = FetchType.LAZY)
    @JoinColumn(name = "customer_id", referencedColumnName = "id", nullable = true, insertable = true, updatable = true)
    public Customer getCustomer() {
        return this.customer;
    }
    /**
     * @param aCustomer Customer
     */
    public void setCustomer(Customer aCustomer) {
        this.customer = aCustomer;
    }
    /**
     * @return Team
     */
    @ManyToOne(cascade = CascadeType.REFRESH, fetch = FetchType.LAZY)
    @JoinColumn(name = "team_id", referencedColumnName = "id", nullable = true, insertable = true, updatable = true)
    public Team getTeam() {
        return this.team;
    }
    /**
     * @param aTeam Team
     */
    public void setTeam(Team aTeam) {
        this.team = aTeam;
    }
    /**
     * @return sales
     */
    @Column(name = "sales", nullable = false, insertable = true, updatable = true)
    public Long getSales() {
        return this.sales;
    }
    /**
     * @param aSales sales
     */
    public void setSales(Long aSales) {
        this.sales = aSales;
    }
    /**
     * @return Activity Code
     */
    @Column(name = "code", nullable = false, insertable = true, updatable = true)
    @Length(max = 100)
    public String getCode() {
        return this.code;
    }
    /**
     * @param aCode Activity Code
     */
    public void setCode(String aCode) {
        this.code = aCode;
    }
    /**
     * @return Activity Name
     */
    @Column(name = "name", nullable = true, insertable = true, updatable = true)
    @Length(max = 100)
    public String getName() {
        return this.name;
    }
    /**
     * @param aName Activity Name
     */
    public void setName(String aName) {
        this.name = aName;
    }
    /**
     * @return Activity Nick
     */
    @Column(name = "nick", nullable = true, insertable = true, updatable = true)
    @Length(max = 100)
    public String getNick() {
        return this.nick;
    }
    /**
     * @param aNick Activity Nick
     */
    public void setNick(String aNick) {
        this.nick = aNick;
    }
    /**
     * @return Text
     */
    @Column(name = "text", nullable = true, insertable = true, updatable = true)
    @Length(max = 100)
    public String getText() {
        return this.text;
    }
    /**
     * @param aText Text
     */
    public void setText(String aText) {
        this.text = aText;
    }
    /**
     * @return Start Date
     */
    @Column(name = "start_date", nullable = true, insertable = true, updatable = true)
    @Basic
    @Temporal(TemporalType.DATE)
    public Date getStartDate() {
        return this.startDate;
    }
    /**
     * @param aStartDate Start Date
     */
    public void setStartDate(Date aStartDate) {
        this.startDate = aStartDate;
    }
    /**
     * @return End Date
     */
    @Column(name = "end_date", nullable = true, insertable = true, updatable = true)
    @Basic
    @Temporal(TemporalType.DATE)
    public Date getEndDate() {
        return this.endDate;
    }
    /**
     * @param aEnd End Date
     */
    public void setEndDate(Date aEnd) {
        this.endDate = aEnd;
    }
    /**
     * @return Note
     */
    @Column(name = "note", nullable = true, insertable = true, updatable = true)
    @Length(max = 1000)
    public String getNote() {
        return this.note;
    }
    /**
     * @param aNote Note
     */
    public void setNote(String aNote) {
        this.note = aNote;
    }
    /**
     * @return Plan Works
     */
    @OneToMany(cascade = CascadeType.ALL, fetch = FetchType.LAZY, mappedBy = "activity")
    public List<PlanWork> getPlanWorks() {
        return this.planWorks;
    }
    /**
     * @param aPlanWorks Plan Works
     */
    public void setPlanWorks(List<PlanWork> aPlanWorks) {
        this.planWorks = aPlanWorks;
    }
    /**
     * @return Plan Expenses
     */
    @OneToMany(cascade = CascadeType.ALL, fetch = FetchType.LAZY, mappedBy = "activity")
    public List<PlanExpense> getPlanExpenses() {
        return this.planExpenses;
    }
    /**
     * @param aPlanExpenses Plan Expenses
     */
    public void setPlanExpenses(List<PlanExpense> aPlanExpenses) {
        this.planExpenses = aPlanExpenses;
    }
    /**
     * @return Actuals
     */
    @OneToMany(cascade = CascadeType.ALL, fetch = FetchType.LAZY, mappedBy = "activity")
    public List<ActualPeriod> getActualPeriods() {
        return this.actualPeriods;
    }
    /**
     * @param aActualPeriods Actuals
     */
    public void setActualPeriods(List<ActualPeriod> aActualPeriods) {
        this.actualPeriods = aActualPeriods;
    }
}
