// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: PlanExpenseDetail.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.entity.erp.mng;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import kuzumeji.entity.BaseEntity;
/**
 * Plan Expense Monthly
 * @author nilcy
 */
@Entity
@Table(name = "plan_expense_detail", uniqueConstraints = {})
public class PlanExpenseDetail extends BaseEntity {
    /** S/N */
    private static final long serialVersionUID = 4269028971084727055L;
    /** Plan Expense */
    private PlanExpense planExpense;
    /** Pay Date */
    private Date payDate;
    /** Cost */
    private Long cost = 0L;
    /**
     * Constructor
     */
    public PlanExpenseDetail() {
        // NOP
    }
    /**
     * @return Plan Expense
     */
    @ManyToOne(cascade = CascadeType.REFRESH, fetch = FetchType.LAZY)
    @JoinColumn(name = "plan_expense_id", referencedColumnName = "id", nullable = false, insertable = true, updatable = true)
    public PlanExpense getPlanExpense() {
        return this.planExpense;
    }
    /**
     * @param aPlanExpense Plan Expense
     */
    public void setPlanExpense(PlanExpense aPlanExpense) {
        this.planExpense = aPlanExpense;
    }
    /**
     * @return Pay Date
     */
    @Column(name = "pay_date", nullable = false, insertable = true, updatable = true)
    @Basic
    @Temporal(TemporalType.DATE)
    public Date getPayDate() {
        return this.payDate;
    }
    /**
     * @param aPayDate Pay Date
     */
    public void setPayDate(Date aPayDate) {
        this.payDate = aPayDate;
    }
    /**
     * @return Cost
     */
    @Column(name = "cost", nullable = false, insertable = true, updatable = true, precision = 8, scale = 0)
    public Long getCost() {
        return this.cost;
    }
    /**
     * @param aCost Cost
     */
    public void setCost(Long aCost) {
        this.cost = aCost;
    }
}
