// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: PlanWorkDetail.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.entity.erp.mng;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import kuzumeji.entity.BaseEntity;
/**
 * Plan Work Hours
 * @author nilcy
 */
@Entity
@Table(name = "plan_work_detail", uniqueConstraints = {})
public class PlanWorkDetail extends BaseEntity {
    /** S/N */
    private static final long serialVersionUID = 750589816921751066L;
    /** Plan Work */
    private PlanWork planWork;
    /** Work Date */
    private Date workDate;
    /** Work Hours */
    private Double hours;
    /**
     * Constructor
     */
    public PlanWorkDetail() {
        // NOP
    }
    /**
     * @return Plan Work
     */
    @ManyToOne(cascade = CascadeType.REFRESH, fetch = FetchType.LAZY)
    @JoinColumn(name = "plan_work_id", referencedColumnName = "id", nullable = false, insertable = true, updatable = true)
    public PlanWork getPlanWork() {
        return this.planWork;
    }
    /**
     * @param aPlanWork Plan Work
     */
    public void setPlanWork(PlanWork aPlanWork) {
        this.planWork = aPlanWork;
    }
    /**
     * @return Work Date
     */
    @Column(name = "work_date", nullable = false, insertable = true, updatable = true)
    @Basic
    @Temporal(TemporalType.DATE)
    public Date getWorkDate() {
        return this.workDate;
    }
    /**
     * @param aWorkDate Work Date
     */
    public void setWorkDate(Date aWorkDate) {
        this.workDate = aWorkDate;
    }
    /**
     * @return Work Hours
     */
    @Column(name = "hours", nullable = false, insertable = true, updatable = true, precision = 8, scale = 0)
    public Double getHours() {
        return this.hours;
    }
    /**
     * @param aHours Work Hours
     */
    public void setHours(Double aHours) {
        this.hours = aHours;
    }
}
