// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: Perm.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.entity.idm;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import kuzumeji.entity.BaseEntity;
import org.jboss.seam.annotations.security.permission.PermissionAction;
import org.jboss.seam.annotations.security.permission.PermissionDiscriminator;
import org.jboss.seam.annotations.security.permission.PermissionRole;
import org.jboss.seam.annotations.security.permission.PermissionTarget;
import org.jboss.seam.annotations.security.permission.PermissionUser;
/**
 * IDM Permission
 * @author nilcy
 */
@Entity
@Table(name = "perm")
public class Perm extends BaseEntity {
    /** S/N */
    private static final long serialVersionUID = -7156425807883966365L;
    /** Target */
    private String target;
    /** Action */
    private String action;
    /** Discriminator */
    private String discriminator;
    /** Recipient */
    private String recipient;
    /** Constructor */
    public Perm() {
        // NOP
    }
    /**
     * getter for Target
     * @return Target
     */
    @PermissionTarget
    @Column(name = "target", nullable = true)
    public String getTarget() {
        return this.target;
    }
    /**
     * setter for Target
     * @param aTarget Target
     */
    public void setTarget(String aTarget) {
        this.target = aTarget;
    }
    /**
     * getter for Action
     * @return Action
     */
    @PermissionAction
    @Column(name = "action", nullable = true)
    public String getAction() {
        return this.action;
    }
    /**
     * setter for Action
     * @param aAction Action
     */
    public void setAction(String aAction) {
        this.action = aAction;
    }
    /**
     * getter for Discriminator
     * @return Discriminator
     */
    @PermissionDiscriminator
    @Column(name = "discriminator", nullable = true)
    public String getDiscriminator() {
        return this.discriminator;
    }
    /**
     * setter for Discriminator
     * @param aDiscriminator Discriminator
     */
    public void setDiscriminator(String aDiscriminator) {
        this.discriminator = aDiscriminator;
    }
    /**
     * getter for Recipient
     * @return Recipient
     */
    @PermissionUser
    @PermissionRole
    @Column(name = "recipient", nullable = true)
    public String getRecipient() {
        return this.recipient;
    }
    /**
     * setter for Recipient
     * @param aRecipient Recipient
     */
    public void setRecipient(String aRecipient) {
        this.recipient = aRecipient;
    }
}
