// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: Token.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.entity.idm;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import kuzumeji.entity.BaseEntity;
import org.jboss.seam.annotations.security.TokenUsername;
import org.jboss.seam.annotations.security.TokenValue;
/**
 * IDM Token
 * @author nilcy
 */
@Entity
@Table(name = "token", uniqueConstraints = {})
public class Token extends BaseEntity {
    /** S/N */
    private static final long serialVersionUID = 3130686906650023546L;
    /** Token Name */
    private String name;
    /** Token Value */
    private String value;
    /** Constructor */
    public Token() {
        // NOP
    }
    /**
     * getter for Token Name
     * @return Token Name
     */
    @TokenUsername
    @Column(name = "name", nullable = false)
    public String getName() {
        return this.name;
    }
    /**
     * setter for Token Name
     * @param aName Token Name
     */
    public void setName(String aName) {
        this.name = aName;
    }
    /**
     * getter for Token Value
     * @return Token Value
     */
    @TokenValue
    @Column(name = "value", nullable = false)
    public String getValue() {
        return this.value;
    }
    /**
     * setter for Token Value
     * @param aValue Token Value
     */
    public void setValue(String aValue) {
        this.value = aValue;
    }
}
