// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: Notify.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.entity.sys;
import kuzumeji.entity.TrackEntity;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.validator.Length;
/**
 * Notify
 * @author nilcy
 */
@Entity
@Table(name = "notify")
public class Notify extends TrackEntity {
    /** S/N */
    private static final long serialVersionUID = 2240869275002898493L;
    /** TimeStamp */
    private Date time = new Date();
    /** UserName */
    private String user;
    /** Title */
    private String title;
    /** Text */
    private String text;
    /**
     * Constructor
     */
    public Notify() {
        // NOP
    }
    /**
     * getter for TimeStamp
     * @return TimeStamp
     */
    @Column(name = "time", nullable = false)
    @Basic
    @Temporal(TemporalType.TIMESTAMP)
    public Date getTime() {
        return this.time;
    }
    /**
     * setter for TimeStamp
     * @param aTime TimeStamp
     */
    public void setTime(Date aTime) {
        this.time = aTime;
    }
    /**
     * getter for UserName
     * @return UserName
     */
    @Column(name = "user", nullable = false)
    public String getUser() {
        return this.user;
    }
    /**
     * setter for UserName
     * @param aUser UserName
     */
    public void setUser(String aUser) {
        this.user = aUser;
    }
    /**
     * getter for Title
     * @return Title
     */
    @Column(name = "title", nullable = false)
    @Length(max = 100)
    public String getTitle() {
        return this.title;
    }
    /**
     * setter for Title
     * @param aTitle Title
     */
    public void setTitle(String aTitle) {
        this.title = aTitle;
    }
    /**
     * getter for Text
     * @return Text
     */
    @Column(name = "text", nullable = false)
    @Length(max = 100)
    public String getText() {
        return this.text;
    }
    /**
     * setter for Text
     * @param aText Text
     */
    public void setText(String aText) {
        this.text = aText;
    }
}
