// ============================================================
// Copyright (C) 2009 Kuzumeji Hacker. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: FinderService.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.service;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import kuzumeji.AppRuntimeException;
import kuzumeji.entity.idm.User;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
/**
 * Finder Service
 * @author nilcy
 */
@Name("finder")
public class FinderService {
    /** S/N */
    private static final long serialVersionUID = 264460825140262009L;
    /** Logger */
    @Logger
    private Log log;
    /** EntityManager*/
    @In
    EntityManager em;
    /** PERSISTENCE_EXCEPTION_MSG */
    private static final String PERSISTENCE_EXCEPTION_MSG = "PERSISTENCE_EXCEPTION_MSG";
    /**
     * Find User on Login
     * @param aUserAccount
     * @return Found User
     */
    public User findUserOnLogin(String aUserAccount) {
        return (User) findSingleResult(this.em.createQuery(
                "from User _u join fetch _u.worker.team where _u.account = :account").setParameter("account",
                aUserAccount));
    }
    /**
     * Found Object
     * @param aQuery Query
     * @return Single Result
     */
    private Object findSingleResult(Query aQuery) {
        try {
            return aQuery.getSingleResult();
        } catch (NoResultException e) {
            this.log.warn(e.getLocalizedMessage(), e);
            return null;
        } catch (PersistenceException e) {
            this.log.fatal(e.getLocalizedMessage(), e);
            throw new AppRuntimeException(PERSISTENCE_EXCEPTION_MSG, e);
        }
    }
}
