// ============================================================
// Copyright (C) 2009 Kuzumeji Hacker. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: LoginService.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.service;
import java.util.Date;
import kuzumeji.entity.idm.User;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.international.StatusMessages;
import org.jboss.seam.international.StatusMessage.Severity;
import org.jboss.seam.log.Log;
import org.jboss.seam.security.Credentials;
/**
 * Login
 * @author nilcy
 */
@Name("login")
public class LoginService {
    /** Logger */
    @Logger
    private Log log;
    /** Finder */
    @In(create = true)
    private FinderService finder;
    /** Credentials */
    @In
    Credentials credentials;
    /** Login User */
    @Out(required = true, scope = ScopeType.SESSION)
    private User loginUser;
    /** StatusMessages */
    @In
    StatusMessages statusMessages;
    /**
     * Login
     * @return true/false
     */
    public boolean login() {
        this.log.info("Login Processing. #0", this.credentials.getUsername());
        this.loginUser = this.finder.findUserOnLogin(this.credentials.getUsername());
        if (this.loginUser == null) {
            this.statusMessages.add(Severity.WARN, "NOUTFOUND User->Worker->Team");
            return false;
        }
        return true;
    }
    /**
     * After Login Trigger
     */
    @Observer("org.jboss.seam.security.loginSuccessful")
    public void afterLogin() {
        this.log.info("After Login Trigger. #0", this.credentials.getUsername());
        this.loginUser = this.finder.findUserOnLogin(this.credentials.getUsername());
        if (this.loginUser == null) {
            this.statusMessages.add(Severity.WARN, "NOUTFOUND User->Worker->Team");
            return;
        }
        this.loginUser.setLastLoginTime(new Date());
        this.loginUser.incrementLoginCount();
        this.log.info("User is updated. [#0]", this.loginUser);
    }
}
