﻿module kyojintati4d.component.ending.scene04;

private import y4d;
private import y4d_draw.transbltter;

private import kyojintati4d.gameinfo;
private import kyojintati4d.component.rhythm.keyconfigdialon;
private import kyojintati4d.component.ending.scenebase;
private import kyojintati4d.component.ending.scene02;

private import yamalib.counterfsp;
private import yamalib.log.log;

/**
 * シーン１の効果を取り扱うクラス
 */
public class Scene04 : Scene02 {
	/// コンストラクタ
	this(FixTimer timer) {
		super(timer);
		// 使用する画像をロード
		textureLoader.loadDefFile(cast(char[]) "img2/ending/s04/list.txt");
	}

	/// すべての画像をキャッシュする	
	override void cacheTexture() {
		cacheTextureAll(textureLoader);
	}

	private static const uint START_TIME = 152_700 + MUSIC_OFFSET_TIME;
	// シーンは開始しているか
	override bool isStart() {
		return START_TIME <= timer.get();
	}
	
	// 念のため時間でも終了時間もチェック
	private static const uint END_TIME = 196_700 + MUSIC_OFFSET_TIME; 
	// シーンが終了したか
	override bool isEnd() {
		return sceneEndFlg || END_TIME <= timer.get();
	}
	

	/// タイミングデータ作成
	protected override void setupTimingData() {
		long phase4_1Offset = 88_000 + MUSIC_OFFSET_TIME;
		TimingData[] t4_1 = [
			new TimingData(65_480 + phase4_1Offset, [&eventCallback1_1]),
			new TimingData(66_820 + phase4_1Offset, [&eventCallback1_2]),
			new TimingData(68_160 + phase4_1Offset, [&eventCallback1_3]),
			new TimingData(69_490 + phase4_1Offset, [&eventCallback1_4]),
			new TimingData(69_650 + phase4_1Offset, [&eventCallback1_5]),
			new TimingData(70_830 + phase4_1Offset, [&eventCallback1_6]),
			new TimingData(72_160 + phase4_1Offset, [&eventCallback1_7]),
			new TimingData(73_490 + phase4_1Offset, [&eventCallback1_8]),
			new TimingData(74_160 + phase4_1Offset, [&eventCallback1_9]),
			new TimingData(74_270 + phase4_1Offset, [&eventCallback1_10]),
			new TimingData(74_650 + phase4_1Offset, [&eventCallback1_11]),
			new TimingData(74_840 + phase4_1Offset, [&eventCallback1_12]),
			new TimingData(74_950 + phase4_1Offset, [&eventCallback1_13]),
		];
		m_timingData ~= t4_1;

		TimingData[] t4_2 = [
			new TimingData(76_150 + phase4_1Offset, [&eventCallback2_1]),
			new TimingData(77_490 + phase4_1Offset, [&eventCallback2_2]),
			new TimingData(78_820 + phase4_1Offset, [&eventCallback2_3]),
			new TimingData(80_190 + phase4_1Offset, [&eventCallback2_4]),
			new TimingData(80_330 + phase4_1Offset, [&eventCallback2_5]),
			new TimingData(81_610 + phase4_1Offset, [&eventCallback2_6]),
			new TimingData(82_820 + phase4_1Offset, [&eventCallback2_7]),
			new TimingData(83_490 + phase4_1Offset, [&eventCallback2_8]),
			new TimingData(84_150 + phase4_1Offset, [&eventCallback2_9]),
			new TimingData(84_800 + phase4_1Offset, [&eventCallback2_10]),
			new TimingData(85_550 + phase4_1Offset, [&eventCallback2_11]),
			new TimingData(85_740 + phase4_1Offset, [&eventCallback2_12]),
			new TimingData(85_830 + phase4_1Offset, [&eventCallback2_13]),
//			new TimingData(87_480 + phase4_1Offset, [&eventCallback2_12]),
//			new TimingData(87_840 + phase4_1Offset, [&eventCallback2_13]),
//			new TimingData(88_000 + phase4_1Offset, [&eventCallback2_14]),
//			new TimingData(88_300 + phase4_1Offset, [&eventCallback2_15]),
		];
		m_timingData ~= t4_2;
		
		long phase4_2Offset = MUSIC_OFFSET_TIME + 109_300;
		TimingData[] t4_3 = [
			new TimingData(65_480 + phase4_2Offset, [&eventCallback3_1]),
			new TimingData(66_820 + phase4_2Offset, [&eventCallback3_2]),
			new TimingData(68_160 + phase4_2Offset, [&eventCallback3_3]),
			new TimingData(69_490 + phase4_2Offset, [&eventCallback3_4]),
			new TimingData(69_650 + phase4_2Offset, [&eventCallback3_5]),
			new TimingData(70_830 + phase4_2Offset, [&eventCallback3_6]),
			new TimingData(72_160 + phase4_2Offset, [&eventCallback3_7]),
			new TimingData(73_490 + phase4_2Offset, [&eventCallback3_8]),
			new TimingData(74_160 + phase4_2Offset, [&eventCallback3_9]),
			new TimingData(74_270 + phase4_2Offset, [&eventCallback3_10]),
			new TimingData(74_650 + phase4_2Offset, [&eventCallback3_11]),
			new TimingData(74_840 + phase4_2Offset, [&eventCallback3_12]),
			new TimingData(74_950 + phase4_2Offset, [&eventCallback3_13]),
		];
		m_timingData ~= t4_3;

		TimingData[] t4_4 = [
			new TimingData(76_150 + phase4_2Offset, [&eventCallback4_1]),
			new TimingData(77_490 + phase4_2Offset, [&eventCallback4_2]),
			new TimingData(78_820 + phase4_2Offset, [&eventCallback4_3]),
			new TimingData(80_190 + phase4_2Offset, [&eventCallback4_4]),
			new TimingData(80_330 + phase4_2Offset, [&eventCallback4_5]),
			new TimingData(81_610 + phase4_2Offset, [&eventCallback4_6]),
			new TimingData(82_820 + phase4_2Offset, [&eventCallback4_7]),
			new TimingData(83_490 + phase4_2Offset, [&eventCallback4_8]),
			new TimingData(84_150 + phase4_2Offset, [&eventCallback4_9]),
			new TimingData(84_800 + phase4_2Offset, [&eventCallback4_10]),
			new TimingData(85_550 + phase4_2Offset, [&eventCallback4_11]),
			new TimingData(85_640 + phase4_2Offset, [&eventCallback4_12]),
			new TimingData(85_730 + phase4_2Offset, [&eventCallback4_13]),
		];
		m_timingData ~= t4_4;


		phase1_1 = new PhaseDraw(textureLoader, 0);
		phase1_1.fadeStart();
		phase1_2 = new PhaseDraw(textureLoader, 6);
		phase2_1 = new PhaseDraw(textureLoader, 15);
		phase2_2 = new PhaseDraw(textureLoader, 21);
		phase3_1 = new PhaseDraw(textureLoader, 30);
		phase3_2 = new PhaseDraw(textureLoader, 36);
		phase4_1 = new PhaseDraw(textureLoader, 45);
		phase4_2 = new PhaseDraw(textureLoader, 51);
	}
	
	/// 移動処理
	void onMove(Screen screen) {
		phase1_1.onMove(screen);
		phase1_2.onMove(screen);
		phase2_1.onMove(screen);
		phase2_2.onMove(screen);
		phase3_1.onMove(screen);
		phase3_2.onMove(screen);
		phase4_1.onMove(screen);
		phase4_2.onMove(screen);
		foreach (hitEffect; hitEffects) {
			if (hitEffect !is null) {
				hitEffect.onMove(screen);
			}
		}
		
		// 自分がフェードするタイムを監視
		if (!pahse4_2Out && timer.get() > (END_TIME - 1_000)) {
			pahse4_2Out = true;
			phase4_2.fadeEnd();
		}
	}
	
	/// 描画処理
	void onDraw(Screen screen) {
		phase1_1.onDraw(screen);
		phase1_2.onDraw(screen);
		phase2_1.onDraw(screen);
		phase2_2.onDraw(screen);
		phase3_1.onDraw(screen);
		phase3_2.onDraw(screen);
		phase4_1.onDraw(screen);
		phase4_2.onDraw(screen);
		foreach (hitEffect; hitEffects) {
			if (hitEffect !is null) {
				hitEffect.onDraw(screen);
			}
		}
	}
	

private:

	// ========================================================================================== //
	// =================================     PHASE 1 - 1     ==================================== //
	// ========================================================================================== //
	
	/// 1-1
	bool eventCallback1_1(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase1_1.next(textObj, status, 1, 15, 47, 20);
			
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}
	
	/// 1-2
	bool eventCallback1_2(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase1_1.next(textObj, status, 2, 15, 115, 20);
	
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}
	/// 1-3
	bool eventCallback1_3(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase1_1.next(textObj, status, 3, 15, 217, 20);
		
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}
	
	/// 1-4
	bool eventCallback1_4(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase1_1.next(textObj, status, 4, 15, 285, 20);
	
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}

	/// 1-5
	bool eventCallback1_5(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase1_1.next(textObj, status, 5, 15, 353, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}

	/// 1-6  鹿南
	bool eventCallback1_6(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {

		// 前のフェーズを終わらせておく
		phase1_1.fadeEnd();
			
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase1_2.fadeStart();
			phase1_2.next(textObj, status, 7, 9, 29, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}

	/// 1-7
	bool eventCallback1_7(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase1_2.next(textObj, status, 8, 9, 96, 20);
	
			hitEffects ~= createHitEffect(textObj);
		}
		
		// 後は自前でやるのででええわー
		return true;
	}

	/// 1-8
	bool eventCallback1_8(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase1_2.next(textObj, status, 9, 9, 163, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}

	/// 1-9
	bool eventCallback1_9(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase1_2.next(textObj, status, 10, 9, 197, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}

	/// 1-10
	bool eventCallback1_10(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase1_2.next(textObj, status, 11, 9, 231, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}

	/// 1-11
	bool eventCallback1_11(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase1_2.next(textObj, status, 12, 9, 298, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}

	/// 1-12
	bool eventCallback1_12(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase1_2.next(textObj, status, 13, 9, 332, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}

	/// 1-13
	bool eventCallback1_13(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase1_2.next(textObj, status, 14, 9, 366, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}


	// ========================================================================================== //
	// =================================     PHASE 2 - 2     ==================================== //
	// ========================================================================================== //
	/// 2-1 瑛迩
	bool eventCallback2_1(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {

		// 前のフェーズを終わらせておく
		phase1_2.fadeEnd();
			
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase2_1.fadeStart();
			phase2_1.next(textObj, status, 16, 11, 132, 20);
			
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}
	/// 2-2 
	bool eventCallback2_2(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase2_1.next(textObj, status, 17, 11, 199, 20);
	
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}

	/// 2-3 
	bool eventCallback2_3(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase2_1.next(textObj, status, 18, 11, 233, 20);
	
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}
	/// 2-4
	bool eventCallback2_4(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase2_1.next(textObj, status, 19, 11, 267, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}
	/// 2-5　
	bool eventCallback2_5(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase2_1.next(textObj, status, 20, 11, 301, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}
	
	
	/// 2-6  伊津佳
	bool eventCallback2_6(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {

		// 前のフェーズを終わらせておく
		phase2_1.fadeEnd();
			
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase2_2.fadeStart();
			phase2_2.next(textObj, status, 22, 6, 15, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}

	/// 2-7
	bool eventCallback2_7(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase2_2.next(textObj, status, 23, 6, 82, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}
	
	/// 2-8
	bool eventCallback2_8(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase2_2.next(textObj, status, 24, 6, 149, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}
	
	/// 2-9
	bool eventCallback2_9(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase2_2.next(textObj, status, 25, 6, 183, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}
	
	/// 2-10
	bool eventCallback2_10(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase2_2.next(textObj, status, 26, 6, 217, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}
	
	/// 2-11
	bool eventCallback2_11(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase2_2.next(textObj, status, 27, 6, 251, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}
	
	/// 2-12
	bool eventCallback2_12(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase2_2.next(textObj, status, 28, 6, 285, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}

	
	/// 2-13
	bool eventCallback2_13(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase2_2.next(textObj, status, 29, 6, 319, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}

/*	
	/// 2-14
	bool eventCallback2_14(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		phase2_2.next(textObj, status, 30, 6, 287, 20);
		// 後は自前でやるのででええわー
		return true;
	}
	
	/// 2-15
	bool eventCallback2_15(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		phase2_2.next(textObj, status, 31, 6, 321, 20);
		// 後は自前でやるのででええわー
		return true;
	}
*/

	// ========================================================================================== //
	// =================================     PHASE 3 - 1     ==================================== //
	// ========================================================================================== //
	
	/// 3-1 楓羅
	bool eventCallback3_1(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {

		// 前のフェーズを終わらせておく
		phase2_2.fadeEnd();
		
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase3_1.fadeStart();
			phase3_1.next(textObj, status, 31, 15, 47, 20);
			
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}
	
	/// 3-2
	bool eventCallback3_2(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase3_1.next(textObj, status, 32, 15, 114, 20);
	
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}
	/// 3-3
	bool eventCallback3_3(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase3_1.next(textObj, status, 33, 15, 183, 20);
		
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}
	
	/// 3-4
	bool eventCallback3_4(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase3_1.next(textObj, status, 34, 15, 250, 20);
	
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}

	/// 3-5
	bool eventCallback3_5(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase3_1.next(textObj, status, 35, 15, 317, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}

	/// 3-6 晶子
	bool eventCallback3_6(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {

		// 前のフェーズを終わらせておく
		phase3_1.fadeEnd();
			
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase3_2.fadeStart();
			phase3_2.next(textObj, status, 37, 9, 49, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}

	/// 3-7
	bool eventCallback3_7(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase3_2.next(textObj, status, 38, 9, 118, 20);
	
			hitEffects ~= createHitEffect(textObj);
		}
		
		// 後は自前でやるのででええわー
		return true;
	}

	/// 3-8
	bool eventCallback3_8(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase3_2.next(textObj, status, 39, 9, 185, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}

	/// 3-9
	bool eventCallback3_9(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase3_2.next(textObj, status, 40, 9, 219, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}

	/// 3-10
	bool eventCallback3_10(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase3_2.next(textObj, status, 41, 9, 253, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}

	/// 3-11
	bool eventCallback3_11(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase3_2.next(textObj, status, 42, 9, 287, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}

	/// 3-12
	bool eventCallback3_12(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase3_2.next(textObj, status, 43, 9, 321, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}

	/// 3-13
	bool eventCallback3_13(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase3_2.next(textObj, status, 44, 9, 355, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}


	// ========================================================================================== //
	// =================================     PHASE 2 - 2     ==================================== //
	// ========================================================================================== //
	/// 4-1 廼羅
	bool eventCallback4_1(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {

		// 前のフェーズを終わらせておく
		phase3_2.fadeEnd();
			
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase4_1.fadeStart();
			phase4_1.next(textObj, status, 46, 11, 49, 20);
			
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}
	/// 4-2 
	bool eventCallback4_2(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase4_1.next(textObj, status, 47, 11, 109, 20);
	
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}

	/// 4-3 
	bool eventCallback4_3(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase4_1.next(textObj, status, 48, 11, 169, 20);
	
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}
	/// 4-4
	bool eventCallback4_4(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase4_1.next(textObj, status, 49, 11, 229, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}
	/// 4-5　
	bool eventCallback4_5(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase4_1.next(textObj, status, 50, 11, 289, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}
	
	
	/// 4-6 章子
	bool eventCallback4_6(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {

		// 前のフェーズを終わらせておく
		phase4_1.fadeEnd();
			
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase4_2.fadeStart();
			phase4_2.next(textObj, status, 52, 6, 15, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}

	/// 4-7
	bool eventCallback4_7(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase4_2.next(textObj, status, 53, 6, 82, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}
	
	/// 4-8
	bool eventCallback4_8(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase4_2.next(textObj, status, 54, 6, 182, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}
	
	/// 4-9
	bool eventCallback4_9(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase4_2.next(textObj, status, 55, 6, 216, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}
	
	/// 4-10
	bool eventCallback4_10(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase4_2.next(textObj, status, 56, 6, 250, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}
	
	/// 4-11
	bool eventCallback4_11(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase4_2.next(textObj, status, 57, 6, 284, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}
	
	/// 4-12
	bool eventCallback4_12(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			Log.print("AYAKO t7!! START");
			phase4_2.next(textObj, status, 58, 6, 318, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}

	
	/// 4-13
	bool eventCallback4_13(Screen screen, TextObj textObj, long hitTime, 
		HitStatus status) {
		// ステータスカウント
		countHitStatus(status);
		if (isHitedStatus(status)) {
			phase4_2.next(textObj, status, 59, 6, 385, 20);
			hitEffects ~= createHitEffect(textObj);
		}
		// 後は自前でやるのででええわー
		return true;
	}

	bool pahse4_2Out = false;
	
	PhaseDraw phase1_1;
	PhaseDraw phase1_2;
	PhaseDraw phase2_1;
	PhaseDraw phase2_2;
	PhaseDraw phase3_1;
	PhaseDraw phase3_2;
	PhaseDraw phase4_1;
	PhaseDraw phase4_2;
}
