﻿using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Ytl;
using Yanesdk.System;
using Kyojin.Model;
using Kyojin.Scene;

namespace Kyojin
{
    /// <summary>
    /// シーンIDの列挙子
    /// </summary>
    public static class Scenes
    {
        public const String TestScene = "testscene";
        public const String Logo = "logo";
        public const String Telop = "telop";       // テロップ画面
        public const String Startmenu = "startmenu";      // スタートメニュー
        public const String OptionSetting = "optionsetting";  // オプション設定画面
        public const String SeveLoad = "seveload";       // セーブロード画面
        public const String Selector = "selector";  // シナリオ選択画面
        public const String Scenario = "scenario";       // シナリオ画面
        public const String Ending = "ending";       // エンディング画面
        public const String EndingOption = "endingoption";       // エンディングオプション画面
        public const String MusicRoom = "musicroom";   // 音楽試聴
        public const String Demo = "demo";   // 音楽試聴

        public const String SelectorEyecatche = "selector_eyecatche";
        public const String ScenarioEndEyecatche = "scenario_end_eyecatche";
        public const String MainPartTelop = "main_part_telop";
        public const String MainPartEnding = "main_part_ending";
    }

    /// <summary>
    /// シーンIDより、対象のTaskを生成し返却するクラス
    /// </summary>
    class SceneFactory : TaskFactoryBase<String>
    {
        private GameSystem system;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="system">共通で使用するGameSysteオブジェクト</param>
        public SceneFactory(GameSystem system)
        {
            this.system = system;
        }

        /// <summary>
        /// シーン生成と遷移を定義する。
        /// </summary>
        /// <param name="name">シーン名</param>
        /// <returns>生成したシーンタスクを返却する。
        /// もし、対象のシーンが見つからなければnullを返却する</returns>
        public override TaskBase CreateTask(String id)
        {

            switch (id.ToLower())
            {
                case Scenes.Logo: return new Kyojin.Scene.Demo.LogoScene(system);
                case Scenes.Startmenu: return new Kyojin.Scene.Title.TitleScene(system);
                case Scenes.OptionSetting: return new Kyojin.Scene.Option.OptionScene(system);
                case Scenes.SeveLoad: return new Kyojin.Scene.SaveLoad.BookmarkScene(system);
                case Scenes.Selector: return new Kyojin.Scene.Selector.SelectorScene(system);
                case Scenes.Telop: return new Kyojin.Scene.Telop.TelopScene(system);
                case Scenes.Scenario: return new Kyojin.Scene.Scenario.ScenarioScene(system);
                case Scenes.Ending: return new Kyojin.Scene.Ending.EndingScene(system);
                case Scenes.MusicRoom: return new Kyojin.Scene.MusicRoom.MusicRoomScene(system);
                case Scenes.EndingOption: return new Kyojin.Scene.EndingOption.EndingOptionScene(system);
                case Scenes.Demo: return new Kyojin.Scene.Demo.DemoScene(system);
                case Scenes.SelectorEyecatche: return new Kyojin.Scene.EyeCatche.SelectorEyeCatcheScene(system);
                case Scenes.ScenarioEndEyecatche: return new Kyojin.Scene.EyeCatche.SenarioEndEyeCatcheScene(system);
                case Scenes.MainPartTelop: return new Kyojin.Scene.Telop.MainPartTelopScene(system);
                case Scenes.MainPartEnding: return new Kyojin.Scene.Ending.MainEndingScene(system);
            }
            system.LogWriter.Write("Invalid SceneID:" + id);
            return null;
        }
    }
}
