using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Draw;
using Yamalib.Util;
using Yanesdk.Timer;
using Yamalib.Input;
using System.Diagnostics;

namespace Kyojin.Component.Ending
{
    /// <summary>
    /// qbgXe[^X
    /// </summary>
    public enum HitStatus
    {
        GREAT,
        GOOD,
        BAD,
        POOR,
        ERROR,
        NONE
    };

    /// <summary>
    /// m[gijqbgƂ̃Cxg
    /// </summary>
    /// <param name="screen"></param>
    /// <param name="textObj"></param>
    /// <param name="hitTime"></param>
    /// <param name="histStatus"></param>
    /// <returns></returns>
    public delegate bool HitEvent(IScreen screen, TextObj textObj, long hitTime, HitStatus histStatus);


    /// <summary>
    /// ^C~Of[^
    /// </summary>
    public class TimingData
    {
        public TimingData(long hitTime, HitEvent[] hitEvent)
        {
            m_hitTime = hitTime;
            m_event = hitEvent;
        }

        public TimingData(long hitTime, HitEvent[] hitEvent, bool hidden)
            : this(hitTime, hitEvent)
        {
            m_hidden = hidden;
        }

        /// qbg~b
        public long HitTime
        {
            get { return m_hitTime; }
        }

        public HitEvent[] HitEvent
        {
            get { return m_event; }
        }

        public bool IsHidden
        {
            get { return m_hidden; }
            set { m_hidden = value; }
        }

        #region otB[h

        private long m_hitTime;
        private HitEvent[] m_event;
        private bool m_hidden;

        #endregion

    }

    /// <summary>
    /// e|f[^
    /// </summary>
    public class TempoData
    {
        /// RXgN^
        public TempoData(string text, List<TimingData> timing)
        {
            m_text = text;
            m_charText = text.ToCharArray();
            m_timing = timing;
        }

        public string Text
        {
            get { return m_text; }
        }

        public List<TimingData> Timing
        {
            get { return m_timing; }
        }

        public char GetNextLetter()
        {
            if (m_charText.Length > letterIndex)
            {
                return m_charText[letterIndex++];
            }
            return 'A';
        }

        #region otB[h

        private string m_text;
        private char[] m_charText;
        private List<TimingData> m_timing;
        // pϐ
        private int letterIndex = 0;

        #endregion

    }

    /// <summary>
    /// eLXgIuWFNg
    /// </summary>
    public class TextObj
    {
        /// <summary>
        /// qbgʃf[^NX
        /// </summary>
        public class HitResult
        {
            public HitResult(long hitTime, HitStatus hitStatus)
            {
                this.hitTime = hitTime;
                this.hitStatus = hitStatus;
            }

            public long HitTime
            {
                get { return hitTime; }
            }
            public HitStatus HitStatus
            {
                get { return hitStatus; }
            }

            private long hitTime;
            private HitStatus hitStatus;
        }

        #region otB[h

        private HitResult m_hitResult;
        private HitEvent[] m_event;
        private FixTimer m_timer;
        private long m_startTime = 0L;
        private ITexture m_img;
        private float m_rate;
        private int m_rad;
        private int m_alpha;
        private readonly Position m_pos = new Position(0, 0);
        private bool m_hitable;
        private bool m_endFlg;
        private bool m_drawEndFlg;
        private bool m_hidden;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="timer"></param>
        public TextObj(FixTimer timer)
        {
            m_timer = timer;
            m_startTime = timer.Time;
        }

        public TextObj(FixTimer timer, long startTime)
        {
            m_timer = timer;
            m_startTime = startTime;
        }

        /// <summary>
        /// qbgłf[^ǂ
        /// </summary>
        public bool IsHitable
        {
            get { return m_hitable; }
            set { m_hitable = value; }
        }

        /// <summary>
        /// `Iǂ
        /// </summary>
        public bool IsDrawEnd
        {
            get { return m_drawEndFlg; }
            set { m_drawEndFlg = value; }
        }

        /// <summary>
        /// I
        /// `您уfQ[gI
        /// </summary>
        public bool IsEnd
        {
            get { return m_endFlg; }
            set { m_endFlg = value; }
        }

        /// <summary>
        /// JnĂ邩
        /// </summary>
        public bool IsStart
        {
            get { return m_timer.Time > StartTime; }
        }

        /// <summary>
        /// 摜
        /// </summary>
        public ITexture Img
        {
            get { return m_img; }
            set { m_img = value; }
        }

        /// <summary>
        ///`ʒu
        /// </summary>
        public Position Pos
        {
            get { return m_pos; }
        }

        public float Rate
        {
            get { return m_rate; }
            set { m_rate = value; }
        }

        public int Rad
        {
            get { return m_rad; }
            set { m_rad = value; }
        }

        public int Alpha
        {
            get { return m_alpha; }
            set { m_alpha = value; }
        }

        /// <summary>
        ///  NĂ̎
        /// </summary>
        public long Time
        {
            get { return m_timer.Time - StartTime; }
        }

        /// <summary>
        /// B^C~O
        /// </summary>
        public bool IsHidden
        {
            get { return m_hidden; }
            set { m_hidden = value; }
        }

        private long m_targetTime;

        /// <summary>
        /// qbgCxg
        /// </summary>
        public HitEvent[] HitEvent
        {
            get { return m_event; }
            set { m_event = value; }
        }

        /// <summary>
        /// Jn
        /// </summary>
        public long StartTime
        {
            get { return m_startTime; }
        }

        /// <summary>
        /// ^[QbgɂĂqbg̃^C(ms)
        /// </summary>
        public long TargetTime
        {
            get { return m_targetTime; }
            set { m_targetTime = value; }
        }

        public HitResult HitResultData
        {
            get { return m_hitResult; }
            set { m_hitResult = value; }
        }

        /// IuWFNg̃V[Rs[𐶐
        public TextObj Clone()
        {
            TextObj obj = new TextObj(m_timer, m_startTime);
            obj.HitEvent = m_event;
            obj.HitResultData = m_hitResult;
            obj.Img = m_img;
            obj.Rate = m_rate;
            obj.Rad = m_rad;
            obj.Alpha = m_alpha;
            obj.Pos.X = m_pos.X;
            obj.Pos.Y = m_pos.Y;
            obj.IsHitable = m_hitable;
            obj.IsEnd = m_endFlg;
            obj.IsDrawEnd = m_drawEndFlg;
            obj.TargetTime = m_targetTime;
            return obj;
        }

        /// <summary>
        /// `揈
        /// </summary>
        /// <param name="screen"></param>
        public void OnPaint(IScreen screen)
        {
            if (!IsEnd)
            {
                if (m_hitable && !m_hidden)
                {
                    screen.SetColor(255, 0, 0, Alpha);
                }
                else
                {
                    screen.SetColor(255, 255, 255, Alpha);
                }
                screen.BltRotate(m_img, (int)m_pos.X, (int)m_pos.Y, m_rad, m_rate, 4);
            }
        }

        /// <summary>
        /// fQ[gN
        /// </summary>
        /// <param name="screen"></param>
        public void OnDrawDelegate(IScreen screen)
        {
            if (!IsEnd)
            {
                if (HitEvent == null)
                {
                    IsEnd = m_drawEndFlg;
                    return;
                }

                if (HitResultData != null)
                {
                    bool invoking = false;
                    for (int i = 0; i < HitEvent.Length; ++i)
                    {
                        if (HitEvent[i] == null)
                        {
                            continue;
                        }

                        bool result = HitEvent[i](screen, this, HitResultData.HitTime, HitResultData.HitStatus);
                        if (result)
                        {
                            HitEvent[i] = null;
                        }
                        else
                        {
                            invoking = true;
                        }
                    }
                    //ǂꂩ̃fQ[gN
                    IsEnd = m_drawEndFlg && !invoking;
                }
            }
        }

    }

    public class TextuaryTempo
    {

        #region 萔l


        #endregion

        #region otB[h

        // ړ^C~Op^C}
        private FixTimer m_timer;
        // tF[hAEgp
        private int fadeStartTime;
        private int fadeTime;
        private bool fadeOut = false;
        private bool m_stop = false;
        // qbgtO
        private bool m_invalidHit;
        // auto Play falg
        private bool m_autoPlay;
        // ^[Qbg͈
        private ITexture m_scopeImg;
        // qbgpfoCX
        private IMouseInput m_mouse;
        private bool m_mouseLBtPush;
        // tHg|Wg
        private FontRepository m_fontRep;
        // \ƂƂȂ镶
        private List<TempoData> m_tempoData;
        // gp镶
        private int m_textIndex = 0;
        // Jn镶TCY
        private float m_startRate = 0.2f;
        // I[ł̕TCY
        private float m_endRate = 1.5f;
        // `Jnʒu
        private Position m_startPos = new Position(10, 30);
        // `Iʒu
        private Position m_endPos = new Position(610, 450);
        // OK덷
        private long m_hitMargin = 400L;
        // Xs[h(ms)
        private long m_generateInterval = 100L;
        // hit pointɓB܂ł̎ (ms)
        private long m_arrivalTime = 1500L;
        // tF[hECtF[hEAEgpJE^
        private readonly RootCounterS m_alphaCounter;


        // vOp
        private List<TextObj> textObj;
        private long preGenTime = long.MinValue;
        private readonly Position centerPos = new Position();
        private int dxCenter;
        private int dyCenter;
        private int rad;

        /// ׂẴIuWFNgf[^쐬
        private readonly Dictionary<TextObj, TimingData> checkMap = new Dictionary<TextObj, TimingData>();

        #endregion


        #region vpeB

        public FixTimer Timer
        {
            get { return m_timer; }
            set { m_timer = value; }
        }

        public IMouseInput Mouse
        {
            get { return m_mouse; }
            set { m_mouse = value; }
        }

        public bool IsAutoPlay
        {
            get { return m_autoPlay; }
            set { m_autoPlay = value; }
        }

        public FontRepository FontRepository
        {
            get { return m_fontRep; }
            set { m_fontRep = value; }
        }

        public ITexture ScopeImg
        {
            get { return m_scopeImg; }
            set { m_scopeImg = value; }
        }

        public List<TempoData> TempoData
        {
            get { return m_tempoData; }
            set { m_tempoData = value; }
        }

        public int TextIndex
        {
            get { return m_textIndex; }
            set { m_textIndex = value; }
        }

        public Position StartPos
        {
            get { return m_startPos; }
            set { m_startPos = value; }
        }

        public Position EndPos
        {
            get { return m_endPos; }
            set { m_endPos = value; }
        }

        public long HitMargin
        {
            get { return m_hitMargin; }
            set { m_hitMargin = value; }
        }

        public float StartRate
        {
            get { return m_startRate; }
            set { m_startRate = value; }
        }

        public float EndRate
        {
            get { return m_endRate; }
            set { m_endRate = value; }
        }

        public long GenerateInterval
        {
            get { return m_generateInterval; }
            set { m_generateInterval = value; }
        }

        public long ArrivalTime
        {
            get { return m_arrivalTime; }
            set { m_arrivalTime = value; }
        }

        public RootCounterS AlphaCounter
        {
            get { return m_alphaCounter; }
        }

        #endregion

        /// <summary>
        /// qbgʂHitResultf[^𐶐ԋp
        /// </summary>
        /// <param name="targetTime"></param>
        /// <param name="hitTime"></param>
        /// <returns></returns>
        public static TextObj.HitResult createHitResult(long targetTime, long hitTime)
        {
            int errorMargin = (int)Math.Abs(targetTime - hitTime);

            // Great!
            if (50 >= errorMargin)
            {
                return new TextObj.HitResult(hitTime, HitStatus.GREAT);
            }
            // Good!
            if (75 >= errorMargin)
            {
                return new TextObj.HitResult(hitTime, HitStatus.GOOD);
            }
            // Bad!
            if (100 >= errorMargin)
            {
                return new TextObj.HitResult(hitTime, HitStatus.BAD);
            }
            // poor!
            return new TextObj.HitResult(hitTime, HitStatus.POOR);
        }

        /// <summary>
        /// RXgN^
        /// </summary>
        public TextuaryTempo()
        {
            m_alphaCounter = new RootCounterS(255, 255, 1);
            // S_߂Ă
            CalcCenterPos();
        }


        /// <summary>
        /// 쏈	
        /// </summary>
        /// <param name="screen"></param>
        public void OnMove(IScreen screen)
        {
            if (m_tempoData == null)
            {
                return;
            }
            m_timer.Update();
            if (m_stop)
            {
                return;
            }

            // At@
            m_alphaCounter.Inc();
            // ړ
            OnMoveTextObj(screen);

            // qbgꂽ
            if (m_mouse != null)
            {
                m_invalidHit = false;
                bool mouseLDown = m_mouse.IsPress(Yanesdk.Input.MouseInput.Button.Left);
                //bool mouseLNewlyDown = mouseLDown && !m_mouseLBtPush;
                bool mouseLNewlyDown = m_mouse.IsPush(Yanesdk.Input.MouseInput.Button.Left);
                // ǂꂩ̃IuWFNgɑΉqbg݂
                bool hitObject = !mouseLNewlyDown;
                long now = m_timer.Time;
                foreach (TextObj obj in textObj)
                {
                    if (!obj.IsStart || obj.IsEnd || !obj.IsHitable)
                    {
                        continue;
                    }
                    long time = obj.TargetTime;

                    if (m_autoPlay)
                    {
                        if ((time - now) < 50 || now > time)
                        {
                            // qbgʕۑ
                            if (!obj.IsHidden)
                            {
                                obj.HitResultData = createHitResult(time, now);
                                obj.IsHitable = false;
                            }
                            else
                            {
                                // Bf[^
                                obj.HitResultData = new TextObj.HitResult(time, HitStatus.NONE);
                                obj.IsHitable = false;
                            }
                            // m[g@̂OK
                            hitObject = true;
                        }
                    }
                    // }EXꂽ덷
                    else if (mouseLNewlyDown && IsInRange(time - m_hitMargin, time + m_hitMargin, now))
                    {
                        //printf("OK: %d\n", time - now);
                        // qbgʕۑ
                        if (!obj.IsHidden)
                        {
                            obj.HitResultData = createHitResult(time, now);
                            obj.IsHitable = false;
                        }
                        else
                        {
                            // Bf[^
                            obj.HitResultData = new TextObj.HitResult(time, HitStatus.NONE);
                            obj.IsHitable = false;
                        }
                        // m[g@̂OK
                        hitObject = true;
                    }
                    else if (now > time + m_hitMargin)
                    {
                        // qbgȂ
                        obj.HitResultData = new TextObj.HitResult(long.MinValue, !obj.IsHidden ? HitStatus.POOR : HitStatus.NONE);
                        obj.IsHitable = false;
                        // @Ƃɂ
                        hitObject = true;
                    }
                }

                if (!hitObject)
                {
                    // m[g@ĂȂ̂ɃqbĝŖ֌Wȃqbg
                    m_invalidHit = true;
                    //Log.print("HIT ERROR!!");
                }

                m_mouseLBtPush = mouseLDown;
            }
        }

        /// <summary>
        /// 쏈	
        /// </summary>
        /// <param name="screen"></param>
        public void OnMoveTextObj(IScreen screen)
        {
            // N_
            CalcCenterPos();
            float rateBreadth = m_endRate - m_startRate;
            float alphaRate = fadeOut ? 1.0f - ((m_timer.Time - fadeStartTime) / (float)fadeTime) : 1.0f;
            if (alphaRate < 0.0f)
            {
                alphaRate = 0.0f;
                m_stop = true;
            }
            float nowAlpha = fadeOut ? m_alphaCounter.Value() * alphaRate : m_alphaCounter.Value();
            foreach (TextObj obj in textObj)
            {
                if (obj.IsStart && !obj.IsEnd)
                {
                    // `悪IĂȂȂp
                    if (!obj.IsDrawEnd)
                    {
                        // `ʒuEpxEg嗦 ߂
                        float timeProgress = obj.Time / (float)m_arrivalTime;
                        obj.Pos.X = m_startPos.X + (int)(dxCenter * timeProgress);
                        obj.Pos.Y = m_startPos.Y + (int)(dyCenter * timeProgress);
                        obj.Rate = m_startRate + (rateBreadth * timeProgress);
                        obj.Rad = rad;

                        if (timeProgress < 1.0f)
                        {
                            obj.Alpha = (int)(nowAlpha * timeProgress);
                        }
                        else
                        {
                            obj.Alpha = (int)(nowAlpha - (nowAlpha * (timeProgress - 1.0f)));

                            // At@0ɂȂI
                            if (obj.Alpha < 0)
                            {
                                obj.IsDrawEnd = true;
                            }
                        }
                    }
                    obj.OnDrawDelegate(screen);
                }
            }
        }

        /// <summary>
        /// `揈
        /// </summary>
        /// <param name="screen"></param>
        public void OnPaint(IScreen screen)
        {
            if (m_tempoData == null)
            {
                return;
            }
            if (m_stop)
            {
                return;
            }

            // e|eLXg`
            for (int i = textObj.Count - 1; i >= 0; --i)
            {
                if (textObj[i].IsEnd || !textObj[i].IsStart)
                {
                    continue;
                }
                textObj[i].OnPaint(screen);
            }

            // ^[Qbg摜
            screen.BlendSrcAlpha();
            screen.SetColor(255, 255, 255, 200);
            screen.BltRotate(m_scopeImg, (int)centerPos.X, (int)centerPos.Y, rad, 1.5f, 4);
        }


        public bool IsInvalidHit()
        {
            return m_invalidHit;
        }

        /// <summary>
        /// ^C}ZbgāA쏀
        /// </summary>
        public void Reset()
        {
            textObj = null;
            preGenTime = long.MinValue;

            // ^C}Zbg
            m_timer.Reset();
            textObj = CreatTextObjAll(m_tempoData[m_textIndex]);
            preGenTime = m_timer.Time;
            m_timer.Reset();
        }

        /// <summary>
        /// c̃qbgf[^
        /// </summary>
        /// <returns></returns>
        public int RestHitData()
        {
            int nowTime = m_timer.Time;
            int count = 0;
            foreach (TextObj obj in textObj)
            {
                if (obj.IsHitable && obj.TargetTime > nowTime)
                {
                    ++count;
                }
            }
            return count;
        }

        public void Stop()
        {
            m_stop = true;
        }

        /// <summary>
        /// At@tF[hȂ\I
        /// </summary>
        /// <param name="fadeTime"></param>
        public void FadeStop(int fadeTime)
        {
            fadeStartTime = m_timer.Time;
            this.fadeTime = fadeTime;
            fadeOut = true;
        }

        #region Jo

        private static long Min(long x, long y)
        {
            return x < y ? x : y;
        }

        private static bool IsInRangeAbs(long just, long margin, long myValue)
        {
            return (just - margin) <= myValue && (just + margin) >= myValue;
        }

        private static bool IsInRange(long min, long max, long target)
        {
            return min <= target && max >= target;
        }

        /// <summary>
        /// Ɏw肵e|A`IuWFNg쐬
        /// </summary>
        /// <param name="data"></param>
        /// <param name="startTime"></param>
        /// <returns></returns>
        private TextObj CreateTextObj(TempoData data, long startTime)
        {
            char ch = data.GetNextLetter();
            ITexture img = FontRepository.GetTexture(ch, 0);
            TextObj obj = new TextObj(Timer, startTime);
            obj.Img = img;
            obj.Rate = StartRate;
            obj.Alpha = 0;
            obj.Pos.X = StartPos.X;
            obj.Pos.Y = StartPos.Y;
            //setHitable(obj, data, startTime);
            return obj;
        }

        private List<TextObj> CreatTextObjAll(TempoData data)
        {
            List<TextObj> result = new List<TextObj>();
            for (int i = 0; i < data.Text.Length; ++i)
            {
                result.Add(CreateTextObj(data, GenerateInterval * i));
            }

            // TextObj[] TimingData 蓖Ă
            foreach (TimingData timingData in data.Timing)
            {
                long time = timingData.HitTime;
                TextObj minData = null;
                long minTime = long.MaxValue;
                // ͈͓textObj Ƃx̂悢̂𒊏o
                foreach (TextObj textObj in result)
                {
                    if (IsInRangeAbs(time, m_hitMargin, textObj.StartTime + m_arrivalTime))
                    {
                        long aMinTime = Min(minTime, Math.Abs(time - (textObj.StartTime + m_arrivalTime)));
                        if (minTime > aMinTime)
                        {
                            minTime = aMinTime;
                            minData = textObj;
                        }
                    }
                }

                Debug.Assert(minData != null);
                if (checkMap.ContainsKey(minData))
                {
                    checkMap.Remove(minData);
                    //Log.print("over rite");
                }

                checkMap.Add(minData, timingData);
                minData.IsHitable = true;
                minData.TargetTime = time;
                minData.HitEvent = timingData.HitEvent;
                minData.IsHidden = timingData.IsHidden;
            }
            return result;
        }

        // JnI_蒆Ԉʒu߂
        private void CalcCenterPos()
        {
            dxCenter = (int)(EndPos.X - StartPos.X) / 2;
            centerPos.X = StartPos.X + dxCenter;

            dyCenter = (int)(EndPos.Y - StartPos.Y) / 2;
            centerPos.Y = StartPos.Y + dyCenter;

            // ͓ŃVOg
            rad = Yanesdk.Math.SinTable.Instance.Atan((int)(StartPos.X - EndPos.X), (int)(StartPos.Y - EndPos.Y)) >> 7;
        }

        #endregion


    }
}
