using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.System;
using Kyojin.Model;
using Yanesdk.Math;
using Yamalib.Util;
using Yanesdk.Draw;
using Yanesdk.Timer;
using Yamalib.Draw;
using Yamalib;
using System.Diagnostics;

namespace Kyojin.Scene.Telop
{

    /// <summary>
    /// lCp[gŃViIrɑ}
    /// ebvNX
    /// 
    /// gpƂ́ATelopSceneParamɃViIԍw肷邱
    /// </summary>
    class MainPartTelopScene : TaskBase, IDisposable
    {
        #region 萔l

        private const int MAX_RESOLUTION = 64;
        private const int RESOLUTION = 96;
        private const int SOFT_SIZE = 2;
        private const int WAIT_TIME = 300;

        private static readonly Rect BG_DRAW_RECT = new Rect(0, 0, 480, 480);
        private static readonly Size BG_DRAW_SIZE = new Size(640, 480);

        private enum PROCESS_TYPE { FADE_IN, FADE_OUT };

        /// ebv`t@C̎w
        private static readonly string[] LIST_FILENAME = new string[]
        {
		    "img/telop/telop1/telop1.lst",
		    "img/telop/telop2/telop2.lst",
		    "",
		    "",
		    "img/telop/telop3/telop3.lst",
		    "img/telop/telop4/telop4.lst",
		    "",
		    "img/telop/telop6/telop6.lst",
	    };


        #endregion

        #region otB[h

        private readonly GameSystem m_gSys;
        private bool init;

        private PROCESS_TYPE m_processType;
        private TextureLoader m_imgs;
        private RootCounterS m_alpha;
        private ICounter m_index;
        int m_waitCount;


        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="gameSystem"></param>
        public MainPartTelopScene(GameSystem gameSystem)
        {
            m_gSys = gameSystem;
            m_alpha = new RootCounterS();
            m_alpha.Set(255, 0, 4);
            m_index = new RootCounterS();
        }

        #region IDisposable o

        public void Dispose()
        {
            m_imgs.Dispose();
        }

        #endregion

        public override int Task(object o)
        {
            GameSystem gameSystem = (GameSystem)o;
            if (0 == OnMove(gameSystem))
            {
                return 0;
            }
            gameSystem.OnMoveCommon();
            if (!gameSystem.FpsTimer.ToBeSkip)
            {
                gameSystem.Screen.Select();
                OnPaint(gameSystem);
                gameSystem.OnDrawCommon();
                gameSystem.Screen.Update();
            }
            else
            {
                OnPaint(gameSystem);
                gameSystem.OnDrawCommon();
            }
            return 1;
        }

        /// <summary>
        /// 쏈
        /// </summary>
        /// <param name="gameSystem"></param>
        private int OnMove(GameSystem gameSystem)
        {
            if (!init)
            {
                OnInit();
                m_gSys.Screen.SetClearColor(0, 0, 0);
            }

            switch (m_processType)
            {
                case PROCESS_TYPE.FADE_IN:
                    m_index.Inc();
                    if (m_index.IsEnd && ++m_waitCount >= WAIT_TIME)
                    {
                        m_processType = PROCESS_TYPE.FADE_OUT;
                    }
                    break;
                case PROCESS_TYPE.FADE_OUT:
                    m_alpha.Inc();
                    if (m_alpha.IsEnd)
                    {
                        m_gSys.SceneController.ReturnScene();
                        return -1;
                    }
                    break;
                default:
                    Debug.Assert(false);
                    break;
            }

            return 1;
        }

        /// <summary>
        /// `揈
        /// </summary>
        /// <param name="gameSystem"></param>
        private void OnPaint(GameSystem gameSystem)
        {
            // ʏ
            m_gSys.Screen.Clear();

            switch (m_processType)
            {
                case PROCESS_TYPE.FADE_IN:
                    m_gSys.Screen.Blt(m_imgs.GetTexture(m_index.Value()), 0, 0, null, BG_DRAW_SIZE);
                    break;
                case PROCESS_TYPE.FADE_OUT:
                    m_gSys.Screen.SetColor(255, 255, 255, m_alpha.Value());
                    m_gSys.Screen.Blt(m_imgs.GetTexture(m_index.Value()), 0, 0, null, BG_DRAW_SIZE);
                    break;
                default:
                    Debug.Assert(false);
                    break;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        private void OnInit()
        {
            init = true;
            int fileIndex = (int)m_gSys.TelopParam.CallScenarioNo;
            // ͈̓`FbN
            if (fileIndex < 0 || fileIndex >= LIST_FILENAME.Length)
            {
                fileIndex = 0;
            }

            m_imgs = new TextureLoader();
            m_imgs.IsDefRelativePath = false;
            m_imgs.LoadDefFile(LIST_FILENAME[fileIndex]);
            int listElementNum = YanesdkUtil.GetElementNum(LIST_FILENAME[fileIndex]);

            //// ׂăLbV
            //for (int i = 0; i < m_imgs.getInfoList().size(); ++i)
            //{
            //    Texture t = m_imgs.Get(i);
            //}

            m_index.Set(0, listElementNum - 1, -10);

            m_processType = PROCESS_TYPE.FADE_IN;
        }

    }
}
