using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Draw;
using Yamalib.Util;
using Yanesdk.Math;

namespace Yamalib.Draw.Effect
{
    /// <summary>
    /// ^Cgebvł̕\\s܂
    /// </summary>
    public abstract class Headlinear : IDisposable
    {
        #region 萔l

        /// <summary>
        /// XP[Ol̒`
        /// </summary>
        protected const float RATE_SCALER = 128.0f;

        #endregion

        #region tB[ho

        protected bool init;
        protected bool finish;
        protected bool useSprite;	//!< XvCgŕ`sH
        protected bool m_reverse;


        // \X^C̎w
        protected int styleType;

        protected int m_disposeStep;	//!< I܂ł̃Xebv

        protected int m_interval;		//!< ̕\܂ł̋x~t[

        protected int intervalCount;
        protected int drawCount;

        protected int moveX;	//!< ړX
        protected int moveY;	//!< ړX

        protected int topMargin;
        protected int leftMargin;
        protected int bottomMargin;
        protected int rightMargin;

        protected List<int> vx;	//!< \ʒu̗
        protected List<int> vy;
        protected List<RootCounterS> vAlpha;	//!< eNX`̃l
        protected List<InteriorCounter> vRate;	//!< eNX`̊g僌[gl RATE_SCALER ŃXP[OĂ
        protected List<InteriorCounter> vMoveX;	//!< ړX
        protected List<InteriorCounter> vMoveY;	//!< ړY
        protected List<InteriorCounter> vRotation;	//!< ]p
        protected List<bool> roteFinish;	//!< eeNX`̈ړItO

        protected List<ITexture> vt;	//!< \ĂeNX`
        //protected Sprite.SpriteVector sv;	//!< \镶̃XvCg

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public Headlinear()
        {
            vx = new List<int>();
            vy = new List<int>();
            vAlpha = new List<RootCounterS>();
            vRate = new List<InteriorCounter>();
            vMoveX = new List<InteriorCounter>();
            vMoveY = new List<InteriorCounter>();
            vRotation = new List<InteriorCounter>();
            vt = new List<ITexture>();
            roteFinish = new List<bool>();
        }

        /// <summary>
        /// \X^Cݒ肷
        /// </summary>
        /// <param name="style"></param>
        public void SetStyle(int style)
        {
            if (styleType != style)
            {
                styleType = style;
                init = false;
                IsFinish = false;
            }
        }

        /// ړʂݒ肵܂
        public void SetMoveXY(int x_, int y_)
        {
            moveX = x_;
            moveY = y_;
        }

        /// ړʂ擾܂
        public void GetMoveXY(out int x_, out int y_)
        {
            x_ = moveX;
            y_ = moveY;
        }


        /// <summary>
        /// ƕƂ C^[o̐ݒ
        /// őIȕ`摬x܂
        /// </summary>
        public int Interval
        {
            get { return m_interval; }
            set { m_interval = value; }
        }

        /// <summary>
        /// Ō`n߂邩
        /// </summary>
        public bool Reverse
        {
            get { return m_reverse; }
            set { m_reverse = value; }
        }

        /// <summary>
        /// `揈̃Xebv
        /// </summary>
        public int DisposeStep
        {
            get { return m_disposeStep; }
            set { m_disposeStep = value; }
        }

        /// <summary>
        /// [hꂽeNX`ǉ܂
        /// </summary>
        /// <param name="t_"></param>
        public void AddTexture(ITexture t_)
        {
            vt.Add(t_);

            // ₵Ƃ
            vx.Add(0);
            vy.Add(0);
            vAlpha.Add(new RootCounterS(0, 255, 1));
            vRate.Add(new InteriorCounter());
            vMoveX.Add(new InteriorCounter(0, 0, 1));	// ɂƂ
            vMoveY.Add(new InteriorCounter(0, 0, 1));	// ɂƂ
            vRotation.Add(new InteriorCounter());
            roteFinish.Add(false);
        }

        /// ]ݒ肵܂
        public void SetMargin(int top, int left, int right, int bottom)
        {
            topMargin = top;
            leftMargin = left;
            bottomMargin = bottom;
            rightMargin = right;
        }

        /// SIuWFNg̕`At@ݒ肵܂
        public void SetAlphaCounterAll(int start, int end, int step)
        {
            foreach (RootCounterS c in vAlpha)
            {
                c.Set(start, end, step);
            }
        }

        public bool IsFinish
        {
            get { return finish; }
            set { finish = value; }
        }

        /// eNX`Ƒ̃NA
        public void Clear()
        {
            vt.Clear();
            vx.Clear();
            vy.Clear();
            vAlpha.Clear();
            vRate.Clear();
            vMoveX.Clear();
            vMoveY.Clear();
            vRotation.Clear();
            useSprite = false;
            init = false;
            finish = false;
            drawCount = 0;
            moveX = 0;
            moveY = 0;
            topMargin = 0;
            leftMargin = 0;
            bottomMargin = 0;
            rightMargin = 0;
            //sv = null;
            roteFinish = null;
        }

        /// `
        public abstract void OnDraw(IScreen screen);

        /// `挋ʂ炤
        public virtual void OnDraw(out Textures tv)
        {
            tv = null;
        }

        /// ẢzWʒu̎擾
        public virtual void GetXY(out int x_, out int y_)
        {
            x_ = y_ = 0;
        }

        #region IDisposable o

        public void Dispose()
        {
        }

        #endregion
    }

    /// <summary>
    /// ^Cgebvł̕\\s܂
    /// sxȂȂ߂炩ɃXChCĂ`悵܂
    /// </summary>
    public class SlideInHeadlinear : Headlinear
    {
        #region 萔l


        #endregion

        #region tB[ho

        private readonly SinTable sin = SinTable.Instance;	//!< ړʐp
        private int x;	//!< `ʒuX
        private int y;	//!< `ʒuY
        private bool fadeOut;	//!< tF[hAEg邩

        #endregion

        /// \ʒu̐ݒ
        public void SetXY(int x_, int y_)
        {
            x = x_;
            y = y_;
        }

        /// ɃtF[hAEg邩
        public void SetFadeOut(bool b_)
        {
            fadeOut = b_;
        }

        /// `ʒu̎擾
        public override void GetXY(out int x_, out int y_)
        {
            x_ = y_ = 0;
            if (finish)
            {
                int i = 0, posx, posy, minX = int.MaxValue, minY = int.MaxValue;
                foreach (ITexture t in vt)
                {
                    posx = vx[i] + moveX;
                    posy = vy[i] + moveY;
                    if (posx < minX)
                    {
                        minX = posx;
                    }
                    if (posy < minY)
                    {
                        minY = posy;
                    }
                    i++;
                }
                x_ = minX;
                y_ = minY;
            }
        }

        /// <summary>
        /// ĂяoȂ
        /// </summary>
        /// <param name="screen"></param>
        public override void OnDraw(IScreen screen)
        {
            // ݒ肵ĂɂĂ
            if (vt.Count == 0) return;

            if (!init)
            {
                OnInit(screen);
                init = true;
            }

            int posx, posy;
            if (!finish)
            {
                intervalCount++;
                if (intervalCount >= m_interval)
                {
                    intervalCount = 0;
                    drawCount++;
                }

                // CNg
                int i, j = 0;
                if (m_reverse)
                {
                    for (i = vAlpha.Count - 1; i >= 0; --i)
                    {
                        if (j > drawCount) break;

                        vAlpha[i]++;
                        vRotation[i]++;

                        // tF[hAEgݒ
                        if (fadeOut && vRotation[i].IsEnd && !roteFinish[i])
                        {
                            roteFinish[i] = true;
                            int alphaNow = vAlpha[i].Value();
                            vAlpha[i].Set(alphaNow, 0, 2);
                        }
                        j++;
                    }

                    // `
                    for (i = vAlpha.Count - 1; i >= 0; --i)
                    {
                        if (j > drawCount) break;

                        screen.SetColor(255, 255, 255, vAlpha[i].Value());

                        posx = vx[i] + sin.Sin(vRotation[i].Value(), moveX);
                        posy = vy[i] + sin.Sin(vRotation[i].Value(), moveY);

                        screen.Blt(vt[i], posx, posy);
                        j++;
                    }

                }
                else
                {	// !IsReverse

                    // eJE^̑
                    for (i = 0; i < vAlpha.Count; ++i)
                    {
                        if (i > drawCount) break;

                        vAlpha[i]++;
                        vRotation[i]++;

                        // tF[hAEgݒ
                        if (fadeOut && vRotation[i].IsEnd && !roteFinish[i])
                        {
                            roteFinish[i] = true;
                            int alphaNow = vAlpha[i].Value();
                            vAlpha[i].Set(alphaNow, 0, 2);
                        }
                    }

                    // `
                    j = 0;
                    foreach (ITexture t in vt)
                    {
                        if (j > drawCount) break;

                        screen.SetColor(255, 255, 255, vAlpha[j].Value());

                        posx = vx[j] + sin.Sin(vRotation[j].Value(), moveX);
                        posy = vy[j] + sin.Sin(vRotation[j].Value(), moveY);

                        screen.Blt(t, posx, posy);
                        ++j;
                    }
                }
            }
            else if (!fadeOut)
            {
                // `
                int i = 0;
                foreach (ITexture t in vt)
                {
                    posx = vx[i] + moveX;
                    posy = vy[i] + moveY;
                    screen.Blt(t, posx, posy);
                    i++;
                }
            }

            // GtFNg񂩁H
            for (int i = vAlpha.Count - 1; i >= 0; --i)
            {
                if (!vAlpha[i].IsEnd)
                {
                    break;
                }
                finish = true;
            }

            screen.ResetColor();
        }


        #region Jo

        /// <summary>
        /// 
        /// </summary>
        /// <param name="screen"></param>
        void OnInit(IScreen screen)
        {
            int size = vt.Count;	// eNX`̐
            int sunWidth = 0;	// SeNX`̘A
            int maxHeight = 0;	// ԍeNX`̍
            int maxWidth = 0;	// ԕLeNX`̕

            foreach (ITexture t in vt)
            {
                int height = int.MinValue;
                int width = int.MinValue;
                width = (int)t.Width;
                height = (int)t.Height;

                sunWidth += width;

                if (maxWidth < width)
                {
                    maxWidth = width;
                }

                if (maxHeight < height)
                {
                    maxHeight = height;
                }
            }

            int tWidth = 0;
            int tHeight;
            int offsetX = x;
            int offsetY = y;
            int adjustY;

            int i = 0;
            foreach (ITexture t in vt)
            {
                // ÕeNX`̕ɍ킹Ă炵Ă
                offsetX += tWidth;

                tWidth = (int)t.Width;
                tHeight = (int)t.Height;

                if (tHeight != maxHeight)
                {
                    adjustY = (maxHeight - tHeight) / 2;
                }
                else
                {
                    adjustY = 0;
                }

                vx[i] = offsetX;
                vy[i] = offsetY + adjustY;

                vAlpha[i].Set(0, 255, 3);

                vRotation[i].Set(0, 128, m_disposeStep);
                ++i;
            }
        }

        #endregion
    }

    public class SequentialDrawAlpha : Headlinear
    {

        #region tB[ho

        private int x;
        private int y;
        private int rateStep;
        private float startRate = 0.0f;

        #endregion

        /// <summary>
        /// \Jn̊g僌[g
        /// </summary>
        public float StartRate
        {
            get { return startRate; }
            set { startRate = value; }
        }

        /// <summary>
        /// kGtFNgt[̐ݒ
        /// </summary>
        /// <param name="step"></param>
        public void SetEffectingFrame(int step)
        {
            if (0 >= step)
            {
                step = 1;
            }
            rateStep = step;
        }

        /// <summary>
        /// `ʒu̐ݒ
        /// </summary>
        /// <param name="x_"></param>
        /// <param name="y_"></param>
        public void SetXY(int x_, int y_)
        {
            x = x_;
            y = y_;
        }

        /// <summary>
        /// `ʒu̎擾
        /// </summary>
        /// <param name="x_"></param>
        /// <param name="y_"></param>
        public override void GetXY(out int x_, out int y_)
        {
            x_ = x;
            y_ = y;
        }

        /// <summary>
        /// `揈
        /// </summary>
        /// <param name="screen"></param>
        public override void OnDraw(IScreen screen)
        {
            if (!init)
            {
                OnInit(screen);
                init = true;
            }

            if ((drawCount < vt.Count) && (intervalCount++ >= m_interval))
            {
                intervalCount = 0;
                drawCount++;
            }

            int i = 0;
            foreach (ITexture t in vt)
            {

                if (drawCount == i) break;

                if (!roteFinish[i])
                {
                    vRate[i]++;
                    vAlpha[i]++;

                    float fRate = (float)vRate[i].Value() / RATE_SCALER;
                    screen.SetColor(255, 255, 255, vAlpha[i].Value());
                    screen.BltRotate(t, x, y, 0, fRate, 4);	// `

                    if (vRate[i].IsEnd && vAlpha[i].IsEnd)
                    {
                        roteFinish[i] = true;
                    }
                }
                ++i;
            }

            i = 0;
            for (i = 0; i < roteFinish.Count; ++i)
            {
                if (!roteFinish[i]) break;
            }

            if (i == roteFinish.Count)
            {
                finish = true;
            }
        }


        #region Jo

        /// <summary>
        /// 
        /// </summary>
        /// <param name="screen"></param>
        private void OnInit(IScreen screen)
        {
            // eNX`̐
            int size = vt.Count;

            for (int i = 0; i < size; ++i)
            {
                // l
                vAlpha[i].Set(200, 0, 5);
                vRate[i].Set((int)(StartRate * RATE_SCALER), (int)(0.8f * RATE_SCALER), rateStep);
            }
        }

        #endregion
    }
}
