using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Math;
using Yanesdk.Timer;
using Yanesdk.Draw;

namespace Yamalib.Draw.Effect
{
    public class MoveViewBase
    {
        #region tB[ho

        protected readonly Rand rand = new Rand();
        protected readonly static SinTable st = SinTable.Instance;

        protected FixTimer timer;		//!< ^C~Ov^C}
        protected TextureLoader tl;	//!< 摜[hĂ
        protected ITexture t;			//!< ɂ傲ɂ傷eNX`
        protected int movecounter;	//!< t[JEg
        protected int posx;
        protected int posy;
        protected float rate;		//!< g僌[g
        protected readonly Rect textrue_rc = new Rect();
        protected int elementNum;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public MoveViewBase()
        {
            rand.Randomize();
        }

        /// 摜[hĂtextureloader
        public void SetTextureLoader(TextureLoader tl, int eleNum)
        {
            this.tl = tl;
            this.elementNum = eleNum;
            t = tl.GetTexture(GetNextRand());
        }

        /// ĂяoȂ
        public virtual void OnMove(IScreen screen)
        {
        }

        /// Ăяoi
        public virtual void OnDraw(IScreen screen)
        {
        }

        #region Jo

        /// <summary>
        /// eNX`[_ɐݒ肳Ăt@C玟̓KȃeNX`ԍ擾܂
        /// </summary>
        /// <returns></returns>
        protected int GetNextRand()
        {
            return rand.GetRand(elementNum);
        }


        #endregion
    }

    /// <summary>
    /// wiu`NX:ԂČ
    /// </summary>
    public class MoveView : MoveViewBase
    {
        #region tB[ho

        private int rad;			//!< px
        private int rad_speed;		//!< px

        private int rand_x;		//!< ړʂɑ΂邳Ȃ郉_
        private int amplitude;

        private bool radiate = false;
        private int radiate_x;
        private int radiate_y;

        #endregion

        /// <summary>
        ///  px̐ݒ
        /// </summary>
        public int AngleSpeed
        {
            get { return rad_speed; }
            set { rad_speed = value; }
        }

        /// <summary>
        /// _̐ݒ
        /// </summary>
        public int RandX
        {
            get { return rand_x; }
            set { rand_x = value; }
        }

        /// <summary>
        /// Uݒ肷
        /// </summary>
        public int Amplitude
        {
            get { return amplitude; }
            set { amplitude = value; }
        }

        /// <summary>
        /// `揈
        /// </summary>
        /// <param name="screen"></param>
        public override void OnDraw(IScreen screen)
        {
            if (tl == null)
            {
                return;
            }

            rad += rad_speed;
            if (rad > Y4dConst.C_RAD_MAX)
            {
                rad = 0;
            }

            if (radiate)
            {
                posx += radiate_x;
                posy += radiate_y;

                float sx = t.Width * rate;
                float sy = t.Height * rate;

                // 摜̋`߂Ăꂩ̓_ʓɂΏI
                textrue_rc.Left = posx - sx / 2;
                textrue_rc.Right = posx + sx / 2;
                textrue_rc.Top = posy - sy / 2;
                textrue_rc.Bottom = posy + sy / 2;

                if (textrue_rc.Left > 0 || textrue_rc.Top > 0
                    || textrue_rc.Right < screen.Width || textrue_rc.Bottom < screen.Height)
                {
                    radiate = false;
                    movecounter = 0;
                    posx = 320;
                    posy = 240;
                    rate = 1.5f;
                    rad = 0;
                    radiate_x = 0;
                    radiate_x = 0;

                    int no = rand.GetRand(elementNum);
                    t = tl.GetTexture(no);
                }
            }
            movecounter++;

            posx += st.Sin(rad, amplitude);
            if (rand_x != 0)
            {
                posx += rand.GetRand(rand_x) - rand_x / 2;	// _̃u
            }
            posy += rand.GetRand(60) - 30;
            rate += 0.03f;

            screen.SetColor(255, 255, 255, 128);
            screen.BltRotate(t, posx, posy, 0, rate, 4);

            // ʂUĎ̉ʂ
            if (movecounter == 175)
            {
                radiate = true;
                radiate_x = rand.GetRand(50) + 15;
                radiate_y = rand.GetRand(50) + 10;

                if (rand.GetRand(2) != 0) radiate_x = -radiate_x;
                if (rand.GetRand(2) != 0) radiate_y = -radiate_y;
            }
        }

        /// <summary>
        /// RXgN^
        /// </summary>
        public MoveView()
            : base()
        {

            this.timer = null;
            posx = 320;
            posy = 240;
            rad = 0;
            rad_speed = 36;
        }

    }
}
