using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Input;

namespace Yamalib.Input
{

    interface MouseAdaptable
    {
        /// }EXɓK邽߂́A}EX{^ɑΉL[̃}bsOf[^ԋp
        MouseInputAdapter.MouseKeyInputMap GetAdaptKeyMapping();
    }

    /// <summary>
    /// }EXɃ}bsOz肵KEY
    /// y4d_intput.key1̃X[p[ZbgɂȂĂ
    /// </summary>
    class MousedKey : VirtualKey, MouseAdaptable
    {
        public MousedKey()
        {
            Init();
            AddDefaultJoystickMapping();
        }

        /// ݂̐ݒjAftHg Key }bsOKp
        public void Init()
        {
            ClearDevice();
            ClearKeyList();

            keyboard = new KeyBoardInput();
            joystick = new JoyStick(0);

            // OԃfoCX
            AddDevice(keyboard);
            // PԃfoCX
            AddDevice(joystick);

            //	0	:	Escape
            AddKey(0, 0, (int)KeyCode.ESCAPE);

            //	1	:	Up
            AddKey(1, 0, (int)KeyCode.KP8);
            AddKey(1, 0, (int)KeyCode.UP);
            // PԃfoCXւǉ
            AddKey(1, 1, 0);

            //	2	:	Down
            AddKey(2, 0, (int)KeyCode.KP2);
            AddKey(2, 0, (int)KeyCode.DOWN);
            AddKey(2, 1, 1);

            //	3	:	Left
            AddKey(3, 0, (int)KeyCode.KP4);
            AddKey(3, 0, (int)KeyCode.LEFT);
            AddKey(3, 1, 2);
            //	4	:	Right
            AddKey(4, 0, (int)KeyCode.KP6);
            AddKey(4, 0, (int)KeyCode.RIGHT);
            AddKey(4, 1, 3);

            //	5	:	Space
            AddKey(5, 0, (int)KeyCode.SPACE);
            //	6	:	Return
            AddKey(6, 0, (int)KeyCode.RETURN);
            //	7	:	Backspace
            AddKey(7, 0, (int)KeyCode.BACKSPACE);
            //	8	:	Space
            AddKey(8, 0, (int)KeyCode.SPACE);
            //	9	:	PageUp
            AddKey(9, 0, (int)KeyCode.PAGEUP);
            //	10	:	PageDown
            AddKey(10, 0, (int)KeyCode.PAGEDOWN);
            //	11	:	Ctrl
            AddKey(11, 0, (int)KeyCode.LCTRL);
            //	12	:	ECtrl
            AddKey(12, 0, (int)KeyCode.RCTRL);
            //	13	:	C
            AddKey(13, 0, (int)KeyCode.c);
            //	AddKey	:	TAB
            AddKey(14, 0, (int)KeyCode.TAB);

        }

        public void AddJoyKeyLeft(int buttonID)
        {
            AddKey(6, 1, buttonID);
        }
        public void AddJoyKeyRight(int buttonID)
        {
            AddKey(7, 1, buttonID);
        }
        public void AddJoyKeyWheelUp(int buttonID)
        {
            AddKey(9, 1, buttonID);
        }
        public void AddJoyKeyWheelDown(int buttonID)
        {
            AddKey(10, 1, buttonID);
        }
        public void AddJoyKeyExit(int buttonID)
        {
            AddKey(11, 1, buttonID);
        }

        /// }EXɓK邽߂́A}EX{^ɑΉL[̃}bsOf[^ԋp
        /**
            ł̃}bsO
            LEFT -> RETURN
            RIGHT -> BACKSPACE
            MIDDLE -> SPACE
            WHEEL_UP -> PAGEUP
            WHEEL_DOWN -> PAGEDOWN
        */
        public MouseInputAdapter.MouseKeyInputMap GetAdaptKeyMapping()
        {
            MouseInputAdapter.MouseKeyInputMap map =
                new MouseInputAdapter.MouseKeyInputMap();
            map.Set(MouseInput.Button.Left, 6);
            map.Set(MouseInput.Button.Right, 7);
            map.Set(MouseInput.Button.Middle, 8);
            map.Set(MouseInput.Button.XButton1, 9);
            map.Set(MouseInput.Button.XButton2, 10);
            return map;
        }

        /// joystick ̃ftHg}bsOǉ
        private void AddDefaultJoystickMapping()
        {
            //	3	:	Left
            AddKey(3, 1, 1);
            //	4	:	Right
            AddKey(4, 1, 2);
            //	5	:	Space
            AddKey(5, 1, 3);
            //	6	:	Return
            AddKey(6, 1, 4);
            //	7	:	Backspace
            AddKey(7, 1, 5);
            //	8	:	Space
            AddKey(8, 1, 6);
            //	9	:	PageUp
            AddKey(9, 1, 7);
            //	10	:	PageDown
            AddKey(10, 1, 8);
        }

        private KeyBoardInput keyboard;
        private JoyStick joystick;

    }
}
