using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.System;
using Kyojin.Model;
using Yanesdk.Input;
using Yamalib.GUI;
using Yamalib.Input;
using Yanesdk.Draw;
using Yamalib.Util;
using Yanesdk.GUIParts;

namespace Kyojin.Scene.YesNo
{
    public class YesNoScene : TaskBase, IDisposable
    {
        #region 萔l

        /// _CAOŉꂽ{^̃^Cv
        public enum CLICK : int { NO_CLICK = -1, YES = 0, NO, CANCEL };
        /// _CAÕ^Cv
        public enum TYPE : int { FINISH = 0, OVERWRITE, UWAGAKI, SELECT1, LOAD, SAVE, LOAD_AUTO, SAVE_ONLY };

        /// _CAO`t@C̃pX
        private static readonly string[] PROP_FILENAME = new string[]{
		    "img/dialog/dialog_finish.txt",
		    "img/dialog/dialog_overwrite.txt",
		    "img/dialog/dialog_overwrite.txt",
		    "",
		    "img/dialog/dialog_load.txt",	// LOAD
		    "img/dialog/dialog_seve.txt",	// SEVE
		    "img/dialog/dialog_load_auto.txt",	// LOAD_AUTO
		    "img/dialog/dialog_save_only.txt",	// SAVE_ONLY
		    "",
	    };

        //private static readonly string C_PROP_KEY_BUTTON_NM = "BUTTON_NM";
        //private static readonly string C_PROP_KEY_BUTTON_ACTIVE = "BUTTON_ACTIVE";
        //private static readonly string C_PROP_KEY_BUTTON_NON_ACTIVE = "BUTTON_NON_ACTIVE";
        //private static readonly string C_PROP_KEY_BUTTON_OX = "BUTTON_OX";
        //private static readonly string C_PROP_KEY_BUTTON_OY = "BUTTON_OY";

        #endregion

        #region otB[h

        private GameSystem m_gSys;
        private TextureDialog m_dialog;
        //private IMouseInput m_mouse;
        //private IKeyInput m_key;
        private bool init;
        //private bool m_carsorHide;
        private ControlContext ctrlContext;

        private CLICK m_click;
        private TYPE m_type = TYPE.FINISH;


        #endregion

        public YesNoScene(GameSystem gameSystem)
        {
            m_gSys = gameSystem;
        }

        public CLICK ClickState
        {
            get { return m_click; }
            set { m_click = value; }
        }

        public TYPE DialogType
        {
            get { return m_type; }
            set
            {
                if (m_type != value)
                {
                    m_type = value;
                    init = false;
                }
            }
        }

        #region IDisposable o

        public void Dispose()
        {
            throw new Exception("The method or operation is not implemented.");
        }

        #endregion

        public override int Task(object o)
        {
            GameSystem gameSystem = (GameSystem)o;
            OnMove(gameSystem);
            if (!gameSystem.FpsTimer.ToBeSkip)
            {
                return OnPaint(gameSystem);
            }
            return 1;
        }

        /// <summary>
        /// 쏈
        /// </summary>
        /// <param name="gameSystem"></param>
        private void OnMove(GameSystem gameSystem)
        {
        }

        /// <summary>
        /// `揈
        /// </summary>
        /// <param name="gameSystem"></param>
        private int OnPaint(GameSystem gameSystem)
        {
            if (!init)
            {
                OnInit();
                init = true;
            }

            NullableMouseInput aMouse = (NullableMouseInput)m_gSys.Mouse;
            NullableKeyInput aKey = (NullableKeyInput)m_gSys.Key;
            NullableMouseInput aKeyMouse = (NullableMouseInput)m_gSys.KeyDecolateMouse;
            JoyStick aJoystick = m_gSys.JoyStick;

            aMouse.Enable();
            aKey.Enable();
            aKeyMouse.Enable();
            //aJoystick.enable();

            //aMouse.Update();
            aKey.Update();
            m_gSys.KeyDecolateMouse.Update();
            //aKeyMouse.Update();

            Color4ub colorOrg = YanesdkUtil.GetNowScreenColor(m_gSys.Screen);

            try
            {
                m_gSys.Screen.ResetColor();
                m_dialog.OnPaint(m_gSys.Screen, ctrlContext, 0, 0);

                List<TextureGUIControl.Control> bts = m_dialog.GetButton();
                m_click = CLICK.NO_CLICK;
                for (int i = 0; i < bts.Count; ++i)
                {
                    FontButton fontButton = bts[i].Parts as FontButton;
                    if (fontButton != null)
                    {
                        if (fontButton.IsDown)
                        {
                            m_click = (CLICK)i;
                            m_gSys.YesnoClickState = (CLICK)i;
                            //m_carsorHide = false;
                            return 0;
                        }
                    }
                }

                // ̃_CAOȊOׂẴ}EXLZ
                aMouse.Disable();
                aKey.Disable();
                aKeyMouse.Disable();
                //aJoystick.disable();

            }
            catch (Exception e)
            {
                m_gSys.LogWriter.Write(e.Message);
                m_gSys.LogWriter.Write(e.StackTrace);
                throw e;
            }
            finally
            {
                m_gSys.Screen.SetColor(colorOrg);
            }
            return 1;
        }

        /// <summary>
        /// 
        /// </summary>
        private void OnInit()
        {
            ctrlContext = new ControlContext();
            ctrlContext.MouseInput = m_gSys.MouseOriginal;
            ctrlContext.SmartTextureLoader = m_gSys.SmartTextureLoader;
            ctrlContext.SmartSoundLoader = m_gSys.SmartSoundLoader;
            ctrlContext.Param = new FocusableGUIParam(m_gSys.KeyDecolateMouse, m_gSys.Key);

            m_dialog = TextureDialog.CreateDialogBox(
                            m_gSys.createDialogResources(),
                            PROP_FILENAME[(int)m_type],
                            ctrlContext,
                            m_gSys.Key,
                            4, 5);
            m_dialog.OnInit(ctrlContext);

            // }EX\
            m_gSys.Mouse.Show();
        }



    }
}
