using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Draw;
using Yamalib.Util;

namespace Kyojintachi.src.yamalib.draw
{

    /// <summary>
    /// vvgJ[\`NX
    /// z̃vvgJ[\`
    /// \Ԃ`JnAJ[\̎c`悵܂B
    /// </summary>
    public class PromptCarsor
    {
        #region otB[h

        private ITexture carsor;		//!< J[\摜
        private int x;
        private int y;			//!< `ʒu
        private int blink;			//!< _őx
        private int dispflame;		//!< \t[
        private int nondispflame;	//!< \t[
        private bool blend;			//!< uh邩
        private bool disp;			//!< \

        private RootCounter alpha;
        private int flamecounter;
        private int dispcounter;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public PromptCarsor()
        {
            blink = 20;
            dispflame = 5;
            nondispflame = 5;
            blend = true;
            disp = true;
            alpha = new RootCounter();
            alpha.ReverseFlg = (true);
            alpha.Set(0, 255, 1);
            calcAlphaStep();
            alpha.opAssign(255);
        }

        /// vvgJ[\p̃eNX`ݒ肵܂
        /*
            ݒ肵Ȃ΁AŔeNX`𐶐Agp
        */
        public void SetTexture(ITexture t) { carsor = t; }

        /// ł̂Pt[
        public void SetBlinkSpeed(int speed)
        {
            blink = speed;
        }

        /// Ŏ̃J[\S\(=255)\
        public void SetDispFlame(int flame)
        {
            if (flame > blink)
            {
                dispflame = blink;
            }
            else
            {
                dispflame = flame;
            }
        }

        /// ̒ŁAvvgJ[\\ĂȂt[̐ݒ
        public void SetNonDispFlame(int flame)
        {
            nondispflame = flame;
        }

        /// \ʒu̐ݒ
        public void SetXY(int x_, int y_)
        {
            x = x_;
            y = y_;
        }

        /// \ʒu̎擾
        public void GetXY(out int x_, out int y_)
        {
            x_ = x;
            y_ = y;
        }

        /// uh邩
        public void SetBlend(bool b) { blend = b; }

        /// Ԃ
        public void Seset()
        {
            flamecounter = 0;
        }

        /// Ăяo
        public void OnPaint(IScreen screen)
        {
            if (carsor == null) return;

            if (!disp)
            {
                dispcounter++;
                if (dispcounter >= nondispflame)
                {
                    disp = true;
                    dispcounter = 0;
                }
                return;
            }

            if (flamecounter < dispflame)
            {
                screen.BlendAddColorAlpha();
                screen.Blt(carsor, x, y);
            }
            else
            {
                alpha++;
                if (blend)
                {
                    screen.BlendAddColorAlpha();
                    screen.SetColor(255, 255, 255, alpha.Value());
                    screen.Blt(carsor, x, y);
                }
                else
                {
                }
            }

            // g猳ɖ߂Ƃ
            screen.ResetColor();

            flamecounter++;

            if (flamecounter >= blink)
            {
                flamecounter = 0;
                alpha.Reset();
                alpha.opAssign(255);
                //			disp = false;
            }
        }

        #region Jo

        private void calcAlphaStep()
        {
            int n = blink - dispflame;
            int step = 255 / n;
            alpha.StepValue = (step);
        }


        #endregion

    }
}
