using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Draw;
using Yamalib.Util;
using Yanesdk.Math;

namespace Yamalib.Draw.Effect
{
    /// <summary>
    /// vp̐jNX
    /// </summary>
    public class ClockHand
    {
        #region tB[ho

        private int x;
        private int y;
        private bool around;
        private ITexture texture;

        private ClockHand coopeHand;	//!< Agj
        private bool reverse;
        private bool rotation = true;	//!< ]
        private bool bDivTick;  //!< PNbN𕪊삷邩
        //private ITexture hand;	//!< jeNX`
        private readonly InteriorCounter divTickCounter = new InteriorCounter();
        private readonly InteriorCounter divRoundCounter = new InteriorCounter();
        private int divTick; 	//!< PNbN̕ݒ肵܂
        private int divRound;	//!< P]̕

        #endregion

        /// <summary>
        /// jeNX`ݒ肵܂
        /// </summary>
        public ITexture Texture
        {
            get { return texture; }
            set { texture = value; }
        }

        /// <summary>
        /// v肩H
        /// </summary>
        public bool IsReverse
        {
            get { return reverse; }
            set { reverse = value; }
        }

        /// <summary>
        /// ]Ԃݒ肵܂
        /// </summary>
        public bool Rotate
        {
            get { return rotation; }
            set { rotation = value; }
        }

        /// <summary>
        /// jP
        /// </summary>
        public bool IsAround
        {
            get
            {
                if (around)
                {
                    around = false;
                    return true;
                }
                return false;

            }
        }

        /// <summary>
        /// j̉]ӒSݒ肵܂
        /// </summary>
        /// <param name="x_"></param>
        /// <param name="y_"></param>
        public void SetXY(int x_, int y_)
        {
            x = x_;
            y = y_;
        }

        /// <summary>
        /// j̉]ӒS̈ʒuԋp܂
        /// </summary>
        /// <param name="x_"></param>
        /// <param name="y_"></param>
        public void GetXY(out int x_, out int y_)
        {
            x_ = x;
            y_ = y;
        }

        /// <summary>
        /// PNbN̓̕ݒ肵܂
        /// </summary>
        /// <param name="div"></param>
        public void SetDivTick(int div)
        {
            divTick = div;
            divTickCounter.Set(0, 512, div);
            // PNbNLɂ
            bDivTick = true;
        }

        /// <summary>
        /// P]̕ݒ肵܂
        /// </summary>
        /// <param name="div"></param>
        public void SetDivRound(int div)
        {
            divRound = div;
            divRoundCounter.Set(0, 512, div);
        }

        /// <summary>
        /// Ag鏬jݒ肵܂
        /// </summary>
        /// <param name="hand_"></param>
        public void SetCooperateHand(ClockHand hand_)
        {
            coopeHand = hand_;
            /// AgȂ玩Iɂ͉]Ȃ
            rotation = false;
        }

        /// <summary>
        /// lݒ肵܂
        /// </summary>
        /// <param name="i"></param>
        public void SetInit(int i)
        {
            divRoundCounter.SetFlame(i);
            divRoundCounter++;
            SetTickCounter(divRoundCounter.Value());
        }

        /// <summary>
        /// ړ
        /// </summary>
        /// <param name="screen"></param>
        public void OnMove(IScreen screen)
        {
            // ]H
            if (rotation)
            {
                // ړ́H
                if (bDivTick)
                {
                    // Pړ
                    divTickCounter++;
                    if (divTickCounter.IsEnd)
                    {
                        rotation = false;
                    }
                }
                else
                {
                    divRoundCounter++;
                    if (divRoundCounter.IsEnd)
                    {
                        divRoundCounter.Set(0, 512, divRound);
                        around = true;
                    }
                }
            }
            else
            {

                if (coopeHand != null)
                {
                    // AgjH
                    if (coopeHand.IsAround)
                    {

                        if (divRoundCounter.IsEnd)
                        {
                            divRoundCounter.Set(0, 512, divRound);
                            divRoundCounter++;
                            around = true;
                        }

                        // jOrad
                        int radPre = divRoundCounter.Value();
                        divRoundCounter++;
                        int rad = divRoundCounter.Value();
                        divTickCounter.Set(radPre, rad, divTick);

                        rotation = true;
                    }
                }
            }
        }

        /// <summary>
        /// `揈
        /// </summary>
        /// <param name="screen"></param>
        /// <param name="baseX"></param>
        /// <param name="baseY"></param>
        public void OnDraw(IScreen screen, int baseX, int baseY)
        {
            // eNX`ZbgĂ
            if (texture == null) return;

            int rad;
            if (bDivTick)
            {
                rad = divTickCounter.Value();
            }
            else
            {
                rad = divRoundCounter.Value();
            }

            // t]Ȃ߂̂[
            if (reverse)
            {
                rad = 512 - rad;
            }

            // `
            screen.BltRotate(texture, x + baseX, y + baseY, rad, 1.0f, 7);
        }


        #region Jo

        private void SetTickCounter(int start_)
        {
            divTickCounter.Set(start_, start_, 1);
            divTickCounter++;
        }

        #endregion
    }

    /// <summary>
    /// v̐jǗNX
    /// </summary>
    public class ClockHandManager
    {
        #region tB[ho

        private readonly List<ClockHand> clockHands = new List<ClockHand>();

        #endregion

        /// ĂяoȂ
        public void OnMove(IScreen screen)
        {
            foreach (ClockHand hand in clockHands)
            {
                hand.OnMove(screen);
            }
        }

        /// ĂяoȂ
        public void OnDraw(IScreen screen, int baseX, int baseY)
        {
            foreach (ClockHand hand in clockHands)
            {
                hand.OnDraw(screen, baseX, baseY);
            }
        }

        /// jǉ
        public void AddClockHand(ClockHand hand_)
        {
            clockHands.Add(hand_);
        }

    }

    /// <summary>
    /// v\pNX
    /// ȂAgȂ
    /// </summary>
    public class ClockDisplaySimple
    {
        #region 萔l

        public const int RENGE = 100;
        public const int RATE = 128;

        #endregion

        #region tB[ho

        private readonly SinTable sin;
        private readonly Rand rand;

        private ITexture oldTexture;	//!< łɂÂeNX`
        private ITexture newTexture;	//!< VeNX`

        private TextureLoader tl;
        private int elementNum;

        private readonly Rect dstRect = new Rect();
        private bool drawOld;
        private bool drawNew;
        private int x;
        private int y;
        private int newx;
        private int newy;
        private int intx;
        private int inty;
        private int rotateRenge;

        private int ox;		//!< ]̒S
        private int oy; 	//!< ]̒S
        private bool move;
        private int count;

        private int textureCounter;

        private RootCounter stopCounter;
        private RootCounterS moveCounter;
        private RootCounter radCounter;
        private RootCounter changeRoteCounter;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public ClockDisplaySimple()
        {
            sin = SinTable.Instance;
            rand = new Rand();
            rand.Randomize();
            stopCounter = new RootCounter();
            moveCounter = new RootCounterS();
            radCounter = new RootCounter(0, 512, 30);
            changeRoteCounter = new RootCounter(0, 512, 3);
            rotateRenge = RENGE;
        }

        /// <summary>
        /// \ׂ摜̃eNX`Zbg
        /// </summary>
        /// <param name="tl_"></param>
        /// <param name="elementNum"></param>
        public void SetTextureLoader(TextureLoader tl_, int elementNum)
        {
            this.elementNum = elementNum;
            int size = elementNum;
            if (2 <= size)
            {
                tl = tl_;

                for (int i = 0; i < elementNum; ++i)
                {
                    ITexture t = tl.GetTexture(i);
                }

                oldTexture = tl.GetTexture(0);
                newTexture = tl.GetTexture(rand.GetRand(size));
            }
        }

        /// <summary>
        /// \ʒu̎擾
        /// </summary>
        /// <param name="x_"></param>
        /// <param name="y_"></param>
        public void GetXY(out int x_, out int y_)
        {
            x_ = x;
            y_ = y;
        }

        /// <summary>
        /// \`
        /// </summary>
        /// <param name="drawRc"></param>
        public void SetRect(Rect rc)
        {
            dstRect.SetRect(rc.Left, rc.Top, rc.Right, rc.Bottom);
            SetXY((int)dstRect.Left, (int)dstRect.Top);
        }

        /// <summary>
        /// \`
        /// </summary>
        /// <param name="left"></param>
        /// <param name="top"></param>
        /// <param name="right"></param>
        /// <param name="bottom"></param>
        public void SetRect(int left, int top, int right, int bottom)
        {
            dstRect.SetRect(left, top, right, bottom);
            SetXY(left, top);
        }

        /// <summary>
        /// ]̏px̐ݒ
        /// </summary>
        /// <param name="rad_"></param>
        public void SetInitRad(int rad_)
        {
            radCounter.SetInit(rad_);
            radCounter.Reset();
        }

        /// <summary>
        /// ]̒̐ݒ
        /// </summary>
        public int RotateRenge
        {
            get { return rotateRenge; }
            set { rotateRenge = value; }
        }


        /// <summary>
        /// \؂ւ܂ł̃t[
        /// </summary>
        /// <param name="time_"></param>
        public void SetStopTime(int time_)
        {
            stopCounter.Set(0, time_, 1);
        }

        /// <summary>
        /// ړ
        /// </summary>
        /// <param name="screen"></param>
        public void OnMove(IScreen screen)
        {
            stopCounter++;

            // \ւ̂H
            if (stopCounter.IsLapAround)
            {
                // ܂]Sݒ肷
                radCounter++;

                ox = intx + ((rotateRenge * (sin.Cos(radCounter.Value()))) >> 16);
                oy = inty + ((rotateRenge * (sin.Sin(radCounter.Value()))) >> 16);

                // ւ]JE^ɏlݒ
                changeRoteCounter.SetInit(radCounter.Value());
                changeRoteCounter.Reset();
                count = 0;
                move = true;
            }

            // ւȂ񂩁H
            if (move)
            {
                ++count;
                x = ox - ((rotateRenge * (sin.Cos(changeRoteCounter.Value()))) >> 16);
                y = oy - ((rotateRenge * (sin.Sin(changeRoteCounter.Value()))) >> 16);
                newx = ox - ((rotateRenge * (sin.Cos(changeRoteCounter.Value() - RATE))) >> 16);
                newy = oy - ((rotateRenge * (sin.Sin(changeRoteCounter.Value() - RATE))) >> 16);
                changeRoteCounter++;
                if (count >= RATE / changeRoteCounter.StepValue)
                {
                    move = false;
                    x = intx;
                    y = inty;
                    newx = -1;
                    newy = -1;
                    SwapTexture();
                }
            }

            Rect rc = new Rect();
            rc.SetRect(x, y, x + (int)oldTexture.Width, y + (int)oldTexture.Height);
            if (CollisionRect(dstRect, rc))
            {
                drawOld = true;
            }
            else
            {
                drawOld = false;
            }

            rc.SetRect(newx, newy, newx + (int)newTexture.Width, newy + (int)newTexture.Height);
            if (CollisionRect(dstRect, rc))
            {
                drawNew = true;
            }
            else
            {
                drawNew = false;
            }
        }

        /// <summary>
        /// `揈
        /// </summary>
        /// <param name="screen"></param>
        /// <param name="baseX"></param>
        /// <param name="baseY"></param>
        public void OnDraw(IScreen screen, int baseX, int baseY)
        {
            // eNX`ZbgĂ
            if (oldTexture == null || newTexture == null) return;
            // `
            if (drawOld)
            {
                screen.Blt(oldTexture, x + baseX, y + baseY);
            }
            if (drawNew)
            {
                screen.Blt(newTexture, newx + baseX, newy + baseY);
            }
        }


        #region Jo

        /// <summary>
        /// \ʒu̐ݒ
        /// </summary>
        /// <param name="x_"></param>
        /// <param name="y_"></param>
        private void SetXY(int x_, int y_)
        {
            intx = x = x_;
            inty = y = y_;

            ox = x + (int)((RotateRenge * (sin.Cos(radCounter.Value()))) >> 16);
            oy = y + (int)((RotateRenge * (sin.Sin(radCounter.Value()))) >> 16);
        }

        /// <summary>
        ///  ṼeNX`Xbv܂
        /// </summary>
        private void SwapTexture()
        {
            ITexture tmp = oldTexture;
            oldTexture = newTexture;
            newTexture = tmp;
            //int size = noiseTextureLoader.getInfoList().size();

            newTexture = tl.GetTexture(rand.GetRand(elementNum));

            ++textureCounter;
        }

        /// <summary>
        /// `m̂̓蔻	
        /// </summary>
        /// <param name="rc1"></param>
        /// <param name="rc2"></param>
        /// <returns></returns>
        private bool CollisionRect(Rect rc1, Rect rc2)
        {
            //  refered by D5iOO
            long a = (int)(rc1.Left - rc2.Right) & (int)(rc2.Left - rc1.Right)
                           & (int)(rc1.Top - rc2.Bottom) & (int)(rc2.Top - rc1.Bottom);
            return (((int)a) >> 31) != 0 ? true : false;
        }

        #endregion
    }

    /// <summary>
    /// pvNX
    /// ۂ̎ԂƂ͉̊֌W܂
    /// ClockHand  ClockManager ɂ
    /// </summary>
    public class DecorativeColck : IDisposable
    {
        #region 萔l

        private const int OX = 308;
        private const int OY = 175;

        /// \̔z
        private static readonly int[][] ayPt = new int[][] {
		    new int[] { 297, 83, 327, 111 },
		    new int[] {  337, 94, 367, 122 },
		    new int[] {  369, 126, 399, 154 },
		    new int[] {  375, 170, 405, 198 },
		    new int[] {  353, 212, 383, 240 },
		    new int[] {  313, 237, 343, 265 },
		    new int[] {  253, 227, 283, 245 },
		    new int[] {  220, 191, 250, 219 },
		    new int[] {  217, 146, 247, 174 },
		    new int[] {  237, 106, 267, 134 }
	    };

        #endregion

        #region tB[ho

        private ITexture t_clockBase;
        private ITexture t_clock;		/// ṽeNX`
        private ITexture t_bigHand;		/// v̑j
        private ITexture t_littelHand;	/// v̏j

        private int x;	//!< \ʒu
        private int y;	//!< \ʒu

        private ClockHand hand1;
        private ClockHand hand2;
        private ClockHand hand3;
        private ClockHand hand4;
        private ClockHandManager manager;	//!< v̐jǗl

        private List<ClockDisplaySimple> items;	//!< \ṽxN^[
        private TextureLoader tl1;
        private Rand rand;

        #endregion

        #region IDisposable o

        public void Dispose()
        {
            YamalibUtility.Dispose(t_clockBase);
            YamalibUtility.Dispose(t_clock);
            YamalibUtility.Dispose(t_bigHand);
            YamalibUtility.Dispose(t_littelHand);
            YamalibUtility.Dispose(tl1);
        }

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public DecorativeColck()
        {
            rand = new Rand();
            rand.Randomize();

            // v~
            t_clockBase = YamalibConst.CreateTexture("img/demo/clock_base.png");

            //  v
            t_clock = YamalibConst.CreateTexture("img/demo/clock.png");

            // j
            t_bigHand = YamalibConst.CreateTexture("img/demo/hand.png");

            // j
            t_littelHand = YamalibConst.CreateTexture("img/demo/lhand.png");

            hand1 = new ClockHand();
            hand2 = new ClockHand();
            hand3 = new ClockHand();
            hand4 = new ClockHand();
            DateTime date = DateTime.Now;

            // 
            hand1.Texture = t_bigHand;
            hand1.SetXY(OX, OY);
            hand1.SetDivRound(60);
            hand1.SetDivTick(5);
            hand1.SetInit(date.Minute);

            // 1 / 60
            hand2.Texture = t_littelHand;
            hand2.SetXY(OX, OY);
            hand2.SetDivRound(60);
            hand2.IsReverse = (true);

            // b
            hand3.Texture = t_bigHand;
            hand3.SetXY(OX, OY);
            hand3.SetDivRound(60);
            hand3.SetDivTick(10);
            hand3.SetInit(date.Second);

            // 
            hand4.Texture = t_bigHand;
            hand4.SetXY(OX, OY);
            hand4.SetDivRound(12);
            hand4.SetDivTick(5);
            hand4.SetInit(date.Hour % 12);

            // Agj̐ݒ
            hand3.SetCooperateHand(hand2);
            hand1.SetCooperateHand(hand3);
            hand4.SetCooperateHand(hand1);

            manager = new ClockHandManager();

            manager.AddClockHand(hand2);
            manager.AddClockHand(hand3);
            manager.AddClockHand(hand1);
            manager.AddClockHand(hand4);

            // vv
            tl1 = new TextureLoader();
            tl1.IsDefRelativePath = false;
            tl1.LoadDefFile("img/demo/clock_item/item1.lst");

            //// LbVɋĂ
            //tl1.setCacheSize(-1);	// LbV
            //for(int i = 0; i < tl1.getInfoList().size(); ++i) {
            //    Texture t = tl1.Get(i);
            //}

            items = new List<ClockDisplaySimple>();

            foreach (int[] pt in ayPt)
            {
                ClockDisplaySimple item = new ClockDisplaySimple();
                item.SetRect(pt[0], pt[1], pt[2], pt[3]);
                item.SetStopTime(60 + rand.GetRand(30));
                item.SetTextureLoader(tl1, YanesdkUtil.GetElementNum("img/demo/clock_item/item1.lst"));
                item.SetInitRad(rand.GetRand(512));
                items.Add(item);
            }
        }


        /// <summary>
        /// \ʒu̐ݒ
        /// </summary>
        /// <param name="x_"></param>
        /// <param name="y_"></param>
        public void SetXY(int x_, int y_)
        {
            x = x_;
            y = y_;
        }

        /// <summary>
        /// \ʒu̎擾
        /// </summary>
        /// <param name="x_"></param>
        /// <param name="y_"></param>
        public void GetXY(out int x_, out int y_)
        {
            x_ = x;
            y_ = y;
        }

        /// ĂяoȂ
        public void OnMove(IScreen screen)
        {
            manager.OnMove(screen);

            // \`
            foreach (ClockDisplaySimple item in items)
            {
                item.OnMove(screen);
            }
        }


        /// ĂяoȂ
        public void OnDraw(IScreen screen)
        {
            screen.SetColor(255, 255, 255);
            // v~
            screen.Blt(t_clockBase, x, y);

            // \`
            foreach (ClockDisplaySimple item in items)
            {
                item.OnDraw(screen, x, y);
            }

            // vfޕ`
            screen.Blt(t_clock, x, y);

            // `
            manager.OnDraw(screen, x, y);
        }
    }
}
