using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Draw;
using Yamalib.Util;
using Yanesdk.Math;

namespace Yamalib.Draw.Effect
{
    /// <summary>
    /// ^Cgebvł̕\\s܂
    /// </summary>
    public abstract class Headlinear : IDisposable
    {
        #region 萔l

        /// <summary>
        /// XP[Ol̒`
        /// </summary>
        protected const float RATE_SCALER = 128.0f;

        #endregion

        #region tB[ho

        protected bool init;
        protected bool finish;
        protected bool useSprite;	//!< XvCgŕ`sH
        protected bool m_reverse;


        // \X^C̎w
        protected int styleType;

        protected int m_disposeStep;	//!< I܂ł̃Xebv

        protected int m_interval;		//!< ̕\܂ł̋x~t[

        protected int intervalCount;
        protected int drawCount;

        protected int moveX;	//!< ړX
        protected int moveY;	//!< ړX

        protected int topMargin;
        protected int leftMargin;
        protected int bottomMargin;
        protected int rightMargin;

        protected List<int> vx;	//!< \ʒu̗
        protected List<int> vy;
        protected List<RootCounterS> vAlpha;	//!< eNX`̃l
        protected List<InteriorCounter> vRate;	//!< eNX`̊g僌[gl RATE_SCALER ŃXP[OĂ
        protected List<InteriorCounter> vMoveX;	//!< ړX
        protected List<InteriorCounter> vMoveY;	//!< ړY
        protected List<InteriorCounter> vRotation;	//!< ]p
        protected List<bool> roteFinish;	//!< eeNX`̈ړItO

        protected List<ITexture> vt;	//!< \ĂeNX`
        //protected Sprite.SpriteVector sv;	//!< \镶̃XvCg

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public Headlinear()
        {
            vx = new List<int>();
            vy = new List<int>();
            vAlpha = new List<RootCounterS>();
            vRate = new List<InteriorCounter>();
            vMoveX = new List<InteriorCounter>();
            vMoveY = new List<InteriorCounter>();
            vRotation = new List<InteriorCounter>();
            vt = new List<ITexture>();
            roteFinish = new List<bool>();
        }

        /// <summary>
        /// \X^Cݒ肷
        /// </summary>
        /// <param name="style"></param>
        public void SetStyle(int style)
        {
            if (styleType != style)
            {
                styleType = style;
                init = false;
                IsFinish = false;
            }
        }

        /// ړʂݒ肵܂
        public void SetMoveXY(int x_, int y_)
        {
            moveX = x_;
            moveY = y_;
        }

        /// ړʂ擾܂
        public void GetMoveXY(out int x_, out int y_)
        {
            x_ = moveX;
            y_ = moveY;
        }


        /// <summary>
        /// ƕƂ C^[o̐ݒ
        /// őIȕ`摬x܂
        /// </summary>
        public int Interval
        {
            get { return m_interval; }
            set { m_interval = value; }
        }

        /// <summary>
        /// Ō`n߂邩
        /// </summary>
        public bool Reverse
        {
            get { return m_reverse; }
            set { m_reverse = value; }
        }

        /// <summary>
        /// `揈̃Xebv
        /// </summary>
        public int DisposeStep
        {
            get { return m_disposeStep; }
            set { m_disposeStep = value; }
        }

        /// <summary>
        /// [hꂽeNX`ǉ܂
        /// </summary>
        /// <param name="t_"></param>
        public void AddTexture(ITexture t_)
        {
            vt.Add(t_);

            // ₵Ƃ
            vx.Add(0);
            vy.Add(0);
            vAlpha.Add(new RootCounterS(0, 255, 1));
            vRate.Add(new InteriorCounter());
            vMoveX.Add(new InteriorCounter(0, 0, 1));	// ɂƂ
            vMoveY.Add(new InteriorCounter(0, 0, 1));	// ɂƂ
            vRotation.Add(new InteriorCounter());
            roteFinish.Add(false);
        }

        /// ]ݒ肵܂
        public void SetMargin(int top, int left, int right, int bottom)
        {
            topMargin = top;
            leftMargin = left;
            bottomMargin = bottom;
            rightMargin = right;
        }

        /// SIuWFNg̕`At@ݒ肵܂
        public void SetAlphaCounterAll(int start, int end, int step)
        {
            foreach (RootCounterS c in vAlpha)
            {
                c.Set(start, end, step);
            }
        }

        public bool IsFinish
        {
            get { return finish; }
            set { finish = value; }
        }

        /// eNX`Ƒ̃NA
        public virtual void Clear()
        {
            vt.Clear();
            vx.Clear();
            vy.Clear();
            vAlpha.Clear();
            vRate.Clear();
            vMoveX.Clear();
            vMoveY.Clear();
            vRotation.Clear();
            useSprite = false;
            init = false;
            finish = false;
            drawCount = 0;
            moveX = 0;
            moveY = 0;
            topMargin = 0;
            leftMargin = 0;
            bottomMargin = 0;
            rightMargin = 0;
            //sv = null;
            roteFinish.Clear();
        }

        /// `
        public abstract void OnDraw(IScreen screen);

        /// `挋ʂ炤
        public virtual void OnDraw(out Textures tv)
        {
            tv = null;
        }

        /// ẢzWʒu̎擾
        public virtual void GetXY(out int x_, out int y_)
        {
            x_ = y_ = 0;
        }

        #region IDisposable o

        public void Dispose()
        {
        }

        #endregion
    }

    /// <summary>
    /// ^Cgebvł̕\\s܂
    /// sxȂȂ߂炩ɃXChCĂ`悵܂
    /// </summary>
    public class SlideInHeadlinear : Headlinear
    {
        #region 萔l


        #endregion

        #region tB[ho

        private readonly SinTable sin = SinTable.Instance;	//!< ړʐp
        private int x;	//!< `ʒuX
        private int y;	//!< `ʒuY
        private bool fadeOut;	//!< tF[hAEg邩

        #endregion

        /// \ʒu̐ݒ
        public void SetXY(int x_, int y_)
        {
            x = x_;
            y = y_;
        }

        /// ɃtF[hAEg邩
        public void SetFadeOut(bool b_)
        {
            fadeOut = b_;
        }

        /// `ʒu̎擾
        public override void GetXY(out int x_, out int y_)
        {
            x_ = y_ = 0;
            if (finish)
            {
                int i = 0, posx, posy, minX = int.MaxValue, minY = int.MaxValue;
                foreach (ITexture t in vt)
                {
                    posx = vx[i] + moveX;
                    posy = vy[i] + moveY;
                    if (posx < minX)
                    {
                        minX = posx;
                    }
                    if (posy < minY)
                    {
                        minY = posy;
                    }
                    i++;
                }
                x_ = minX;
                y_ = minY;
            }
        }

        /// <summary>
        /// ĂяoȂ
        /// </summary>
        /// <param name="screen"></param>
        public override void OnDraw(IScreen screen)
        {
            // ݒ肵ĂɂĂ
            if (vt.Count == 0) return;

            if (!init)
            {
                OnInit(screen);
                init = true;
            }

            int posx, posy;
            if (!finish)
            {
                intervalCount++;
                if (intervalCount >= m_interval)
                {
                    intervalCount = 0;
                    drawCount++;
                }

                // CNg
                int i, j = 0;
                if (m_reverse)
                {
                    for (i = vAlpha.Count - 1; i >= 0; --i)
                    {
                        if (j > drawCount) break;

                        vAlpha[i]++;
                        vRotation[i]++;

                        // tF[hAEgݒ
                        if (fadeOut && vRotation[i].IsEnd && !roteFinish[i])
                        {
                            roteFinish[i] = true;
                            int alphaNow = vAlpha[i].Value();
                            vAlpha[i].Set(alphaNow, 0, 2);
                        }
                        j++;
                    }

                    // `
                    for (i = vAlpha.Count - 1; i >= 0; --i)
                    {
                        if (j > drawCount) break;

                        screen.SetColor(255, 255, 255, vAlpha[i].Value());

                        posx = vx[i] + sin.Sin(vRotation[i].Value(), moveX);
                        posy = vy[i] + sin.Sin(vRotation[i].Value(), moveY);

                        screen.Blt(vt[i], posx, posy);
                        j++;
                    }

                }
                else
                {	// !IsReverse

                    // eJE^̑
                    for (i = 0; i < vAlpha.Count; ++i)
                    {
                        if (i > drawCount) break;

                        vAlpha[i]++;
                        vRotation[i]++;

                        // tF[hAEgݒ
                        if (fadeOut && vRotation[i].IsEnd && !roteFinish[i])
                        {
                            roteFinish[i] = true;
                            int alphaNow = vAlpha[i].Value();
                            vAlpha[i].Set(alphaNow, 0, 2);
                        }
                    }

                    // `
                    j = 0;
                    foreach (ITexture t in vt)
                    {
                        if (j > drawCount) break;

                        screen.SetColor(255, 255, 255, vAlpha[j].Value());

                        posx = vx[j] + sin.Sin(vRotation[j].Value(), moveX);
                        posy = vy[j] + sin.Sin(vRotation[j].Value(), moveY);

                        screen.Blt(t, posx, posy);
                        ++j;
                    }
                }
            }
            else if (!fadeOut)
            {
                // `
                int i = 0;
                foreach (ITexture t in vt)
                {
                    posx = vx[i] + moveX;
                    posy = vy[i] + moveY;
                    screen.Blt(t, posx, posy);
                    i++;
                }
            }

            // GtFNg񂩁H
            for (int i = vAlpha.Count - 1; i >= 0; --i)
            {
                if (!vAlpha[i].IsEnd)
                {
                    break;
                }
                finish = true;
            }

            screen.ResetColor();
        }


        #region Jo

        /// <summary>
        /// 
        /// </summary>
        /// <param name="screen"></param>
        void OnInit(IScreen screen)
        {
            int size = vt.Count;	// eNX`̐
            int sunWidth = 0;	// SeNX`̘A
            int maxHeight = 0;	// ԍeNX`̍
            int maxWidth = 0;	// ԕLeNX`̕

            foreach (ITexture t in vt)
            {
                int height = int.MinValue;
                int width = int.MinValue;
                width = (int)t.Width;
                height = (int)t.Height;

                sunWidth += width;

                if (maxWidth < width)
                {
                    maxWidth = width;
                }

                if (maxHeight < height)
                {
                    maxHeight = height;
                }
            }

            int tWidth = 0;
            int tHeight;
            int offsetX = x;
            int offsetY = y;
            int adjustY;

            int i = 0;
            foreach (ITexture t in vt)
            {
                // ÕeNX`̕ɍ킹Ă炵Ă
                offsetX += tWidth;

                tWidth = (int)t.Width;
                tHeight = (int)t.Height;

                if (tHeight != maxHeight)
                {
                    adjustY = (maxHeight - tHeight) / 2;
                }
                else
                {
                    adjustY = 0;
                }

                vx[i] = offsetX;
                vy[i] = offsetY + adjustY;

                vAlpha[i].Set(0, 255, 3);

                vRotation[i].Set(0, 128, m_disposeStep);
                ++i;
            }
        }

        #endregion
    }

    public class SequentialDrawAlpha : Headlinear
    {

        #region tB[ho

        private int x;
        private int y;
        private int rateStep;
        private float startRate = 0.0f;

        #endregion

        /// <summary>
        /// \Jn̊g僌[g
        /// </summary>
        public float StartRate
        {
            get { return startRate; }
            set { startRate = value; }
        }

        /// <summary>
        /// kGtFNgt[̐ݒ
        /// </summary>
        /// <param name="step"></param>
        public void SetEffectingFrame(int step)
        {
            if (0 >= step)
            {
                step = 1;
            }
            rateStep = step;
        }

        /// <summary>
        /// `ʒu̐ݒ
        /// </summary>
        /// <param name="x_"></param>
        /// <param name="y_"></param>
        public void SetXY(int x_, int y_)
        {
            x = x_;
            y = y_;
        }

        /// <summary>
        /// `ʒu̎擾
        /// </summary>
        /// <param name="x_"></param>
        /// <param name="y_"></param>
        public override void GetXY(out int x_, out int y_)
        {
            x_ = x;
            y_ = y;
        }

        /// <summary>
        /// `揈
        /// </summary>
        /// <param name="screen"></param>
        public override void OnDraw(IScreen screen)
        {
            if (!init)
            {
                OnInit(screen);
                init = true;
            }

            if ((drawCount < vt.Count) && (intervalCount++ >= m_interval))
            {
                intervalCount = 0;
                drawCount++;
            }

            int i = 0;
            foreach (ITexture t in vt)
            {

                if (drawCount == i) break;

                if (!roteFinish[i])
                {
                    vRate[i]++;
                    vAlpha[i]++;

                    float fRate = (float)vRate[i].Value() / RATE_SCALER;
                    screen.SetColor(255, 255, 255, vAlpha[i].Value());
                    screen.BltRotate(t, x, y, 0, fRate, 4);	// `

                    if (vRate[i].IsEnd && vAlpha[i].IsEnd)
                    {
                        roteFinish[i] = true;
                    }
                }
                ++i;
            }

            i = 0;
            for (i = 0; i < roteFinish.Count; ++i)
            {
                if (!roteFinish[i]) break;
            }

            if (i == roteFinish.Count)
            {
                finish = true;
            }
        }


        #region Jo

        /// <summary>
        /// 
        /// </summary>
        /// <param name="screen"></param>
        private void OnInit(IScreen screen)
        {
            // eNX`̐
            int size = vt.Count;

            for (int i = 0; i < size; ++i)
            {
                // l
                vAlpha[i].Set(200, 0, 5);
                vRate[i].Set((int)(StartRate * RATE_SCALER), (int)(0.8f * RATE_SCALER), rateStep);
            }
        }

        #endregion
    }

    /// <summary>
    ///  ^Cgebvł̕\\s܂
    /// sxȂg傳ꂽԂkꂽԂɈڍs܂
    /// </summary>
    public class ReduceHeadlinear : Headlinear
    {
        #region 萔l

        /// <summary>
        /// \X^C̒`
        /// </summary>
        public enum Style : int { LEFT, CENTER, RIGHT, TOP_LEFT, BOTTM_LEFT, TOP_RIGHT, BOTTOM_RIGHT };

        #endregion

        #region tB[ho

        private Rand rand;
        private float startRate;
        private bool fadeOut;
        private bool nowFade;
        //private int alphaStep;
        private int rateStep;
        private bool randMove;	//!< w肳ĂmoveX,moveY_ɐݒ肷邩H
        private bool useUserPos;
        private int posx = int.MinValue;
        private int posy = int.MinValue;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public ReduceHeadlinear()
            : base()
        {
            rand = new Rand();
            rand.Randomize();
            startRate = 5;	// 5炢H
            rateStep = 128;	// 128ŊgI
        }


        /// \ʒuł߂
        public void SetXY(int x, int y)
        {
            posx = x;
            posy = y;
            useUserPos = true;
        }

        public void SetRandomMove(bool b)
        {
            randMove = b;
        }

        /// kGtFNgt[̐ݒ
        public void SetEffectingFrame(int step)
        {
            if (0 >= step)
            {
                step = 1;
            }
            rateStep = step;
        }

        /// tF[hAEg邩ǂH
        public void SetFadeOut(bool b_)
        {
            fadeOut = true;
        }

        /// \Jn̊g僌[g
        public void SetStartRate(float rate_)
        {
            startRate = rate_;
        }

        public override void OnDraw(IScreen screen)
        {
            // ݒ肵ĂɂĂ
            if (vt.Count == 0) return;

            if (!init)
            {
                // X^C瑮ݒ肷
                if (!useSprite)
                {
                    OnInit(screen);
                }
                else
                {
                    //onInitWithSprite(screen);
                }
            }

            if (!finish)
            {
                intervalCount++;
                if (intervalCount >= Interval)
                {
                    intervalCount = 0;
                    drawCount++;
                }

                // CNg
                if (Reverse)
                {
                    int j = 0;
                    for (int i = vAlpha.Count - 1; i >= 0; --i)
                    {
                        if (j > drawCount) break;
                        vAlpha[i]++;
                        vRate[i]++;
                        vMoveX[i]++;
                        vMoveY[i]++;
                        j++;
                    }
                }
                else
                {
                    for (int i = 0; i < vAlpha.Count; ++i)
                    {
                        if (i > drawCount) break;
                        vAlpha[i]++;
                        vRate[i]++;
                        vMoveX[i]++;
                        vMoveY[i]++;
                    }
                }
            }

            // `抮āAtF[hAEgłΕ`悷邱Ƃ͂Ȃ
            if (!(finish && fadeOut))
            {
                if (!useSprite)
                {
                    OnDrawTextures(screen);
                }
                else
                {
                    //onDrawSprite(screen);
                }
            }

            // GtFNg񂩁H
            if (!finish)
            {
                if (Reverse)
                {
                    for (int i = 0; i < vAlpha.Count; ++i)
                    {
                        if (!vAlpha[i].IsEnd || !vRate[i].IsEnd
                           || !vMoveX[i].IsEnd || !vMoveX[i].IsEnd)
                        {
                            break;
                        }
                        if (fadeOut && !nowFade)
                        {
                            foreach (RootCounterS c in vAlpha)
                            {
                                c.Set(255, 0, 4);
                            }
                            nowFade = true;
                        }
                        else
                        {
                            finish = true;
                        }
                    }
                }
                else
                {
                    for (int i = vAlpha.Count - 1; i >= 0; --i)
                    {
                        if (!vAlpha[i].IsEnd || !vRate[i].IsEnd
                           || !vMoveX[i].IsEnd || !vMoveX[i].IsEnd)
                        {
                            break;
                        }

                        if (fadeOut && !nowFade)
                        {
                            foreach (RootCounterS c in vAlpha)
                            {
                                c.Set(255, 0, 4);
                            }
                            nowFade = true;
                        }
                        else
                        {
                            finish = true;
                        }
                    }
                }
            }
        }

        /// \ʒu̎擾
        public override void GetXY(out int x_, out int y_)
        {
            x_ = y_ = 0;
            if (finish)
            {
                int i = 0, x, y, minX = int.MaxValue, minY = int.MaxValue;
                if (!useSprite)
                {
                    //foreach (ITexture t in vt)
                    //{
                    //    // W̒Sɕ`悳Ƃ
                    //    x = vx[i] - (int)t.Width / 2;
                    //    y = vy[i] - (int)t.Height / 2;
                    //    if (x < minX)
                    //    {
                    //        minX = x;
                    //    }
                    //    if (y < minY)
                    //    {
                    //        minY = y;
                    //    }
                    //    i++;
                    //}

                    foreach (ITexture s in vt)
                    {
                        // W̒Sɕ`悳Ƃ
                        x = vx[i];//-(int)s.rcRect.Width/2;
                        y = vy[i];//-(int)s.rcRect.Height/2;
                        if (x < minX)
                        {
                            minX = x;
                        }
                        if (y < minY)
                        {
                            minY = y;
                        }
                        i++;
                    }

                }
                else
                {
                    //foreach(inout SimpleSprite s;sv) {
                    //    // W̒Sɕ`悳Ƃ
                    //    x = vx[i];//-(int)s.rcRect.Width/2;
                    //    y = vy[i];//-(int)s.rcRect.Height/2;
                    //    if (x<minX) {
                    //        minX = x;
                    //    }
                    //    if (y<minY) {
                    //        minY = y;
                    //    }
                    //    i++;
                    //}
                }
                x_ = minX;
                y_ = minY;
            }
        }

        // 
        public override void Clear()
        {
            base.Clear();
            useUserPos = false;
        }

        #region Jo

        /// <summary>
        /// eNX`̗񂩂`悷
        /// </summary>
        /// <param name="screen"></param>
        private void OnDrawTextures(IScreen screen)
        {

            // `
            int x;
            int y;
            int alpha;
            float rate = 1.0f;

            screen.BlendSrcAlpha();

            if (!finish)
            {
                if (Reverse)
                {
                    int i, j = 0;
                    for (i = vt.Count - 1; i >= 0; --i)
                    {
                        if (j > drawCount) break;

                        int offsetx = vMoveX[i].Value();
                        int offsety = vMoveY[i].Value();

                        x = vx[i] + offsetx;
                        y = vy[i] + offsety;
                        alpha = vAlpha[i].Value();
                        rate = (vRate[i].Value() / RATE_SCALER);	// XP[O߂

                        screen.SetColor(255, 255, 255, alpha);
                        screen.BltRotate(vt[i], x, y, (Rect)null, 0, rate, 0, 0);	// `
                        j++;
                    }
                }
                else
                {
                    for (int i = 0; i < vt.Count; i++)
                    {
                        if (i > drawCount) break;

                        int offsetx = vMoveX[i].Value();
                        int offsety = vMoveY[i].Value();

                        x = vx[i] + offsetx;
                        y = vy[i] + offsety;
                        alpha = vAlpha[i].Value();
                        rate = (vRate[i].Value() / RATE_SCALER);	// XP[O߂

                        screen.SetColor(255, 255, 255, alpha);
                        screen.BltRotate(vt[i], x, y, (Rect)null, 0, rate, 0, 0);	// `
                    }

                }
            }
            else
            {
                for (int i = 0; i < vt.Count; i++)
                {
                    x = vx[i];
                    y = vy[i];
                    screen.SetColor(255, 255, 255);
                    screen.Blt(vt[i], x, y);	// `
                }
            }

            screen.ResetColor();
        }


        //private void onDrawSprite(IScreen screen)
        //{
        //    //// `
        //    //int x;
        //    //int y;
        //    //int alpha;
        //    //float rate = 1.0f;

        //    //screen.blendSrcAlpha();

        //    //if (!finish) {
        //    //    if (reverse) {
        //    //        int i,j;
        //    //        for (i = sv.length-1; i>=0; --i) {
        //    //            if (j > drawCount) break;

        //    //            int offsetx = vMoveX[i].get();
        //    //            int offsety = vMoveY[i].get();

        //    //            x = vx[i] + offsetx;
        //    //            y = vy[i] + offsety;
        //    //            alpha = vAlpha[i].get();
        //    //            rate = (vRate[i].get()/RATE_SCALER);	// XP[O߂

        //    //            screen.setColor(255,255,255,alpha);
        //    //            screen.bltRotate(sv[i].texture,x,y,&sv[i].rcRect,0,rate,0,0);	// `
        //    //            j++;
        //    //        }
        //    //    } else {
        //    //        foreach(int i,inout SimpleSprite s; sv) {
        //    //            if (i > drawCount) break;

        //    //            int offsetx = vMoveX[i].get();
        //    //            int offsety = vMoveY[i].get();

        //    //            x = vx[i] + offsetx;
        //    //            y = vy[i] + offsety;
        //    //            alpha = vAlpha[i].get();
        //    //            rate = (vRate[i].get()/RATE_SCALER);	// XP[O߂

        //    //            screen.setColor(255,255,255,alpha);
        //    //            screen.bltRotate(s.texture,x,y,&s.rcRect,0,rate,0,0);	// `
        //    //        }
        //    //    }
        //    //} else {
        //    //    foreach(int i,inout SimpleSprite s; sv) {
        //    //        x = vx[i];
        //    //        y = vy[i];
        //    //        screen.setColor(255,255,255);
        //    //        screen.blt(s.texture,x,y,&s.rcRect);	// `
        //    //    }
        //    //}

        //    //screen.resetColor();
        //}

        /// <summary>
        /// 
        /// </summary>
        /// <param name="screen"></param>
        private void OnInitTexture(IScreen screen)
        {
            init = true;
            drawCount = 0;

            // ʃTCY
            int screenX = screen.Width;
            int screenY = screen.Height;

            int size = vt.Count;	// eNX`̐
            int sumWidth = 0;	// SeNX`̘A
            int maxHeight = 0;	// ԍeNX`̍
            int maxWidth = 0;	// ԕLeNX`̕

            foreach (ITexture t in vt)
            {
                int height;
                int width;
                width = (int)t.Width;
                height = (int)t.Height;

                sumWidth += width;

                if (maxWidth < width)
                {
                    maxWidth = width;
                }

                if (maxHeight < height)
                {
                    maxHeight = height;
                }
            }

            // ̃eNX`̃TCY
            int tWidth = 0;
            int tHeight = 0;
            // \ʒu
            int x, y;
            int offsetX, offsetY;
            int adjustX, adjustY;

            switch ((Style)styleType)
            {
                case Style.LEFT:	// 
                    {
                        int i = 0;
                        offsetX = leftMargin;
                        offsetY = (screenY - maxHeight) / 2;

                        foreach (ITexture t in vt)
                        {
                            tWidth = (int)t.Width;
                            tHeight = (int)t.Height;

                            // ԍŏ͉ZȂĂ`
                            if (i > 0)
                            {
                                offsetX += tWidth;
                            }

                            if (tHeight != maxHeight)
                            {
                                adjustY = (maxHeight - tHeight) / 2;
                            }
                            else
                            {
                                adjustY = 0;
                            }

                            vx[i] = offsetX;
                            vy[i] = offsetY + adjustY;

                            // JE^̐ݒ
                            SetBasicCounter(i);
                            ++i;
                        }
                    }
                    break;
                case Style.CENTER:	// Z^O
                    {
                        int i = 0;

                        if (useUserPos)
                        {
                            offsetX = posx;
                            offsetY = posy;
                        }
                        else
                        {
                            offsetX = (screenX - sumWidth) / 2;//+(sumWidth/vt.size())/2;
                            offsetY = (screenY - maxHeight) / 2;
                        }
                        foreach (ITexture t in vt)
                        {
                            tWidth = (int)t.Width;
                            tHeight = (int)t.Height;

                            // ԍŏ͉ZȂĂ`
                            if (i > 0)
                            {
                                offsetX += tWidth;
                            }

                            if (tHeight != maxHeight)
                            {
                                adjustY = (maxHeight - tHeight) / 2;
                            }
                            else
                            {
                                adjustY = 0;
                            }

                            vx[i] = offsetX;
                            vy[i] = offsetY + adjustY;

                            vMoveX[i].Set(moveX, 0, rateStep);
                            vMoveY[i].Set(moveY, 0, rateStep);

                            // JE^̐ݒ
                            SetBasicCounter(i);
                            ++i;
                        }
                    }
                    break;
                case Style.RIGHT:	// E
                    {
                        int i = 0;
                        offsetX = (screenX - rightMargin) + sumWidth;
                        offsetY = (screenY - maxHeight) / 2;

                        foreach (ITexture t in vt)
                        {
                            tWidth = (int)t.Width;
                            tHeight = (int)t.Height;

                            // ԍŏ͉ZȂĂ`
                            if (i > 0)
                            {
                                offsetX += tWidth;
                            }

                            if (tHeight != maxHeight)
                            {
                                adjustY = (maxHeight - tHeight) / 2;
                            }
                            else
                            {
                                adjustY = 0;
                            }

                            vx[i] = offsetX;
                            vy[i] = offsetY + adjustY;

                            // JE^̐ݒ
                            SetBasicCounter(i);
                            ++i;
                        }
                    }
                    break;
                case Style.TOP_LEFT:	// 
                    {
                        int i;
                        offsetX = (maxWidth / 2) + leftMargin;
                        offsetY = topMargin + (maxHeight / 2);

                        // ܂Ԃʒu
                        int turnPos = vt.Count / 2;

                        // ܂Ԃn_܂ł̍߂
                        for (i = 0; i < turnPos; ++i)
                        {
                            offsetY += (int)vt[i].Height;
                        }

                        // `ʒubottomł͂Ȃ̂ŁA߂Ă
                        offsetY -= (int)vt[0].Height;

                        i = 0;
                        foreach (ITexture t in vt)
                        {
                            if (i == turnPos)
                            {
                                offsetX += tWidth;
                            }

                            tWidth = (int)t.Width;
                            tHeight = (int)t.Height;

                            if (i < turnPos)
                            {
                                if (i > 0)
                                {
                                    offsetY -= tHeight;
                                }

                                if (tWidth != maxWidth)
                                {
                                    adjustX = (maxWidth - tWidth) / 2;
                                }
                                else
                                {
                                    adjustX = 0;
                                }

                                x = vx[i] = offsetX + adjustX;
                                y = vy[i] = offsetY;

                                vMoveX[i].Set(moveX, 0, rateStep);
                                vMoveY[i].Set(moveY, 0, rateStep);
                            }
                            else
                            {
                                // ܂Ԃŏ͉ZȂĂ`
                                if (i != turnPos)
                                {
                                    offsetX += tWidth;
                                }

                                if (tHeight != maxHeight)
                                {
                                    adjustY = (maxHeight - tHeight) / 2;
                                }
                                else
                                {
                                    adjustY = 0;
                                }

                                vx[i] = offsetX;
                                vy[i] = offsetY + adjustY;

                                vMoveX[i].Set(moveX, 0, rateStep);
                                vMoveY[i].Set(moveY, 0, rateStep);
                            }

                            // {JE^̐ݒ
                            SetBasicCounter(i);
                            ++i;
                        }
                    }
                    break;
                case Style.BOTTM_LEFT:	// 
                    {
                        int i;
                        offsetX = (maxWidth / 2) + leftMargin;
                        offsetY = screenY - bottomMargin + (maxHeight / 2);

                        // ܂Ԃʒu
                        int turnPos = vt.Count / 2;

                        // ܂Ԃn_܂ł̍߂
                        for (i = 0; i < turnPos; ++i)
                        {
                            offsetY -= (int)vt[i].Height;
                        }

                        i = 0;
                        foreach (ITexture t in vt)
                        {
                            if (i == turnPos)
                            {
                                offsetX += tWidth;
                            }

                            tWidth = (int)t.Width;
                            tHeight = (int)t.Height;

                            if (i < turnPos)
                            {
                                if (i > 0)
                                {
                                    offsetY += tHeight;
                                }

                                if (tWidth != maxWidth)
                                {
                                    adjustX = (maxWidth - tWidth) / 2;
                                }
                                else
                                {
                                    adjustX = 0;
                                }

                                x = vx[i] = offsetX + adjustX;
                                y = vy[i] = offsetY;

                                vMoveX[i].Set(moveX, 0, rateStep);
                                vMoveY[i].Set(moveY, 0, rateStep);
                            }
                            else
                            {
                                // ܂Ԃŏ͉ZȂĂ`
                                if (i != turnPos)
                                {
                                    offsetX += tWidth;
                                }

                                if (tHeight != maxHeight)
                                {
                                    adjustY = (maxHeight - tHeight) / 2;
                                }
                                else
                                {
                                    adjustY = 0;
                                }

                                vx[i] = offsetX;
                                vy[i] = offsetY + adjustY;

                                vMoveX[i].Set(moveX, 0, rateStep);
                                vMoveY[i].Set(moveY, 0, rateStep);
                            }

                            // {JE^̐ݒ
                            SetBasicCounter(i);
                            ++i;
                        }
                    }
                    break;
                case Style.TOP_RIGHT:	// E
                    {
                        int i;
                        offsetX = (screenX - rightMargin) + (maxWidth / 2);
                        offsetY = topMargin + (maxHeight / 2);

                        // ܂Ԃʒu
                        int turnPos = vt.Count / 2;

                        // ܂Ԃn_܂ł̕߂
                        for (i = 0; i < turnPos; ++i)
                        {
                            offsetX -= (int)vt[i].Width;
                        }

                        i = 0;
                        foreach (ITexture t in vt)
                        {
                            if (i == turnPos)
                            {
                                offsetY += tHeight;
                            }

                            tWidth = (int)t.Width;
                            tHeight = (int)t.Height;

                            if (i < turnPos)
                            {
                                if (i > 0)
                                {
                                    offsetX += tWidth;
                                }

                                if (tHeight != maxHeight)
                                {
                                    adjustY = (maxHeight - tHeight) / 2;
                                }
                                else
                                {
                                    adjustY = 0;
                                }

                                vx[i] = offsetX;
                                vy[i] = offsetY + adjustY;

                                vMoveX[i].Set(moveX, 0, rateStep);
                                vMoveY[i].Set(moveY, 0, rateStep);
                            }
                            else
                            {
                                // ܂Ԃŏ͉ZȂĂ`
                                if (i != turnPos)
                                {
                                    offsetY += tHeight;
                                }

                                if (tWidth != maxWidth)
                                {
                                    adjustX = (maxWidth - tWidth) / 2;
                                }
                                else
                                {
                                    adjustX = 0;
                                }

                                vx[i] = offsetX + adjustX;
                                vy[i] = offsetY;


                                vMoveX[i].Set(moveX, 0, rateStep);
                                vMoveY[i].Set(moveY, 0, rateStep);
                            }

                            // {JE^̐ݒ
                            SetBasicCounter(i);
                            ++i;
                        }
                    }
                    break;
                case Style.BOTTOM_RIGHT:	// E
                    {
                        int i;
                        offsetX = (screenX - rightMargin) + (maxWidth / 2);
                        offsetY = (screenY - bottomMargin) - (maxHeight / 2);

                        // ܂Ԃʒu
                        int turnPos = vt.Count / 2;

                        // ܂Ԃn_܂ł̕߂
                        for (i = 0; i < turnPos; ++i)
                        {
                            offsetX -= (int)vt[i].Width;
                        }

                        i = 0;
                        foreach (ITexture t in vt)
                        {
                            if (i == turnPos)
                            {
                                offsetY -= tHeight;
                            }

                            tWidth = (int)t.Width;
                            tHeight = (int)t.Height;

                            if (i < turnPos)
                            {
                                if (i > 0)
                                {
                                    offsetX += tWidth;
                                }

                                if (tHeight != maxHeight)
                                {
                                    adjustY = (maxHeight - tHeight) / 2;
                                }
                                else
                                {
                                    adjustY = 0;
                                }

                                vx[i] = offsetX;
                                vy[i] = offsetY + adjustY;

                                vMoveX[i].Set(moveX, 0, rateStep);
                                vMoveY[i].Set(moveY, 0, rateStep);
                            }
                            else
                            {
                                // ܂Ԃŏ͉ZȂĂ`
                                if (i != turnPos)
                                {
                                    offsetY -= tHeight;
                                }

                                if (tWidth != maxWidth)
                                {
                                    adjustX = (maxWidth - tWidth) / 2;
                                }
                                else
                                {
                                    adjustX = 0;
                                }

                                vx[i] = offsetX + adjustX;
                                vy[i] = offsetY;

                                vMoveX[i].Set(moveX, 0, rateStep);
                                vMoveY[i].Set(moveY, 0, rateStep);
                            }

                            // {JE^̐ݒ
                            SetBasicCounter(i);
                            ++i;
                        }
                    }
                    break;
                default:
                    //Log.printError("Headlinear.OnDraw:Invalid Style!\n");
                    break;
            }
        }


        private void OnInit(IScreen screen)
        {
            init = true;
            drawCount = 0;

            // ʃTCY
            int screenX = screen.Width;
            int screenY = screen.Height;

            int size = vt.Count;	// eNX`̐
            int sumWidth = 0;	// SeNX`̘A
            int maxHeight = 0;	// ԍeNX`̍
            int maxWidth = 0;	// ԕLeNX`̕

            foreach (ITexture s in vt)
            {
                int height;
                int width;
                width = (int)s.Width;
                height = (int)s.Height;

                sumWidth += width;

                if (maxWidth < width)
                {
                    maxWidth = width;
                }

                if (maxHeight < height)
                {
                    maxHeight = height;
                }
            }

            // ̃eNX`̃TCY
            int tWidth = 0;
            int tHeight = 0;
            // \ʒu
            int x, y;
            int offsetX, offsetY;
            int adjustX, adjustY;

            switch ((Style)styleType)
            {
                case Style.LEFT:	// 
                    {
                        int i = 0;
                        offsetX = leftMargin;
                        offsetY = (screenY - maxHeight) / 2;

                        foreach (ITexture t in vt)
                        {
                            tWidth = (int)t.Width;
                            tHeight = (int)t.Height;

                            // ԍŏ͉ZȂĂ`
                            if (i > 0)
                            {
                                offsetX += tWidth;
                            }

                            if (tHeight != maxHeight)
                            {
                                adjustY = (maxHeight - tHeight) / 2;
                            }
                            else
                            {
                                adjustY = 0;
                            }

                            vx[i] = offsetX;
                            vy[i] = offsetY + adjustY;

                            // JE^̐ݒ
                            SetBasicCounter(i);
                            ++i;
                        }
                    }
                    break;
                case Style.CENTER:	// Z^O
                    {
                        int i = 0;

                        if (useUserPos)
                        {
                            offsetX = posx;
                            offsetY = posy;
                        }
                        else
                        {
                            offsetX = (screenX - sumWidth) / 2 + (sumWidth / size) / 2;
                            offsetY = (screenY - maxHeight) / 2;
                        }
                        foreach (ITexture s in vt)
                        {
                            tWidth = (int)s.Width;
                            tHeight = (int)s.Height;

                            // ԍŏ͉ZȂĂ`
                            if (i > 0)
                            {
                                offsetX += tWidth;
                            }

                            if (tHeight != maxHeight)
                            {
                                adjustY = (maxHeight - tHeight) / 2;
                            }
                            else
                            {
                                adjustY = 0;
                            }

                            vx[i] = offsetX;
                            vy[i] = offsetY + adjustY;

                            int mx = 0, my = 0;

                            if (randMove)
                            {
                                if (moveX != 0) mx = rand.GetRand(moveX);
                                if (rand.GetRand0_1A() < 0.0) mx = -mx;
                                if (moveY != 0) my = rand.GetRand(moveY);
                                if (rand.GetRand0_1A() < 0.0) my = -mx;
                            }
                            else
                            {
                                if (i <= size / 2)
                                {
                                    mx = moveX * ((size / 2) - i) / (size / 2);
                                }
                                else
                                {
                                    mx = moveX * ((size / 2) - i) / (size / 2);
                                }
                                my = moveY;
                            }

                            vMoveX[i].Set(mx, 0, rateStep);
                            vMoveY[i].Set(my, 0, rateStep);
                            // JE^̐ݒ
                            SetBasicCounter(i);
                            ++i;
                        }
                    }
                    break;
                case Style.RIGHT:	// E
                    {
                        int i = 0;
                        offsetX = (screenX - rightMargin) + sumWidth;
                        offsetY = (screenY - maxHeight) / 2;

                        foreach (ITexture t in vt)
                        {
                            tWidth = (int)t.Width;
                            tHeight = (int)t.Height;

                            // ԍŏ͉ZȂĂ`
                            if (i > 0)
                            {
                                offsetX += tWidth;
                            }

                            if (tHeight != maxHeight)
                            {
                                adjustY = (maxHeight - tHeight) / 2;
                            }
                            else
                            {
                                adjustY = 0;
                            }

                            vx[i] = offsetX;
                            vy[i] = offsetY + adjustY;

                            // JE^̐ݒ
                            SetBasicCounter(i);
                            ++i;
                        }
                    }
                    break;
                case Style.TOP_LEFT:	// 
                    {
                        int i;
                        offsetX = (maxWidth / 2) + leftMargin;
                        offsetY = topMargin + (maxHeight / 2);

                        // ܂Ԃʒu
                        int turnPos = vt.Count / 2;

                        // ܂Ԃn_܂ł̍߂
                        for (i = 0; i < turnPos; ++i)
                        {
                            offsetY += (int)vt[i].Height;
                        }

                        // `ʒubottomł͂Ȃ̂ŁA߂Ă
                        offsetY -= (int)vt[0].Height;

                        i = 0;
                        foreach (ITexture t in vt)
                        {
                            if (i == turnPos)
                            {
                                offsetX += tWidth;
                            }

                            tWidth = (int)t.Width;
                            tHeight = (int)t.Height;

                            if (i < turnPos)
                            {
                                if (i > 0)
                                {
                                    offsetY -= tHeight;
                                }

                                if (tWidth != maxWidth)
                                {
                                    adjustX = (maxWidth - tWidth) / 2;
                                }
                                else
                                {
                                    adjustX = 0;
                                }

                                x = vx[i] = offsetX + adjustX;
                                y = vy[i] = offsetY;

                                vMoveX[i].Set(moveX, 0, rateStep);
                                vMoveY[i].Set(moveY, 0, rateStep);
                            }
                            else
                            {
                                // ܂Ԃŏ͉ZȂĂ`
                                if (i != turnPos)
                                {
                                    offsetX += tWidth;
                                }

                                if (tHeight != maxHeight)
                                {
                                    adjustY = (maxHeight - tHeight) / 2;
                                }
                                else
                                {
                                    adjustY = 0;
                                }

                                vx[i] = offsetX;
                                vy[i] = offsetY + adjustY;

                                vMoveX[i].Set(moveX, 0, rateStep);
                                vMoveY[i].Set(moveY, 0, rateStep);
                            }

                            // {JE^̐ݒ
                            SetBasicCounter(i);
                            ++i;
                        }
                    }
                    break;
                case Style.BOTTM_LEFT:	// 
                    {
                        int i;
                        offsetX = (maxWidth / 2) + leftMargin;
                        offsetY = screenY - bottomMargin + (maxHeight / 2);

                        // ܂Ԃʒu
                        int turnPos = vt.Count / 2;

                        // ܂Ԃn_܂ł̍߂
                        for (i = 0; i < turnPos; ++i)
                        {
                            offsetY -= (int)vt[i].Height;
                        }

                        i = 0;
                        foreach (ITexture t in vt)
                        {
                            if (i == turnPos)
                            {
                                offsetX += tWidth;
                            }

                            tWidth = (int)t.Width;
                            tHeight = (int)t.Height;

                            if (i < turnPos)
                            {
                                if (i > 0)
                                {
                                    offsetY += tHeight;
                                }

                                if (tWidth != maxWidth)
                                {
                                    adjustX = (maxWidth - tWidth) / 2;
                                }
                                else
                                {
                                    adjustX = 0;
                                }

                                x = vx[i] = offsetX + adjustX;
                                y = vy[i] = offsetY;

                                vMoveX[i].Set(moveX, 0, rateStep);
                                vMoveY[i].Set(moveY, 0, rateStep);
                            }
                            else
                            {
                                // ܂Ԃŏ͉ZȂĂ`
                                if (i != turnPos)
                                {
                                    offsetX += tWidth;
                                }

                                if (tHeight != maxHeight)
                                {
                                    adjustY = (maxHeight - tHeight) / 2;
                                }
                                else
                                {
                                    adjustY = 0;
                                }

                                vx[i] = offsetX;
                                vy[i] = offsetY + adjustY;

                                vMoveX[i].Set(moveX, 0, rateStep);
                                vMoveY[i].Set(moveY, 0, rateStep);
                            }

                            // {JE^̐ݒ
                            SetBasicCounter(i);
                            ++i;
                        }
                    }
                    break;
                case Style.TOP_RIGHT:	// E
                    {
                        int i;
                        offsetX = (screenX - rightMargin) + (maxWidth / 2);
                        offsetY = topMargin + (maxHeight / 2);

                        // ܂Ԃʒu
                        int turnPos = vt.Count / 2;

                        // ܂Ԃn_܂ł̕߂
                        for (i = 0; i < turnPos; ++i)
                        {
                            offsetX -= (int)vt[i].Width;
                        }

                        i = 0;
                        foreach (ITexture t in vt)
                        {
                            if (i == turnPos)
                            {
                                offsetY += tHeight;
                            }

                            tWidth = (int)t.Width;
                            tHeight = (int)t.Height;

                            if (i < turnPos)
                            {
                                if (i > 0)
                                {
                                    offsetX += tWidth;
                                }

                                if (tHeight != maxHeight)
                                {
                                    adjustY = (maxHeight - tHeight) / 2;
                                }
                                else
                                {
                                    adjustY = 0;
                                }

                                vx[i] = offsetX;
                                vy[i] = offsetY + adjustY;

                                vMoveX[i].Set(moveX, 0, rateStep);
                                vMoveY[i].Set(moveY, 0, rateStep);
                            }
                            else
                            {
                                // ܂Ԃŏ͉ZȂĂ`
                                if (i != turnPos)
                                {
                                    offsetY += tHeight;
                                }

                                if (tWidth != maxWidth)
                                {
                                    adjustX = (maxWidth - tWidth) / 2;
                                }
                                else
                                {
                                    adjustX = 0;
                                }

                                vx[i] = offsetX + adjustX;
                                vy[i] = offsetY;


                                vMoveX[i].Set(moveX, 0, rateStep);
                                vMoveY[i].Set(moveY, 0, rateStep);
                            }

                            // {JE^̐ݒ
                            SetBasicCounter(i);
                            ++i;
                        }
                    }
                    break;
                case Style.BOTTOM_RIGHT:	// E
                    {
                        int i;
                        offsetX = (screenX - rightMargin) + (maxWidth / 2);
                        offsetY = (screenY - bottomMargin) - (maxHeight / 2);

                        // ܂Ԃʒu
                        int turnPos = vt.Count / 2;

                        // ܂Ԃn_܂ł̕߂
                        for (i = 0; i < turnPos; ++i)
                        {
                            offsetX -= (int)vt[i].Width;
                        }

                        i = 0;
                        foreach (ITexture t in vt)
                        {
                            if (i == turnPos)
                            {
                                offsetY -= tHeight;
                            }

                            tWidth = (int)t.Width;
                            tHeight = (int)t.Height;

                            if (i < turnPos)
                            {
                                if (i > 0)
                                {
                                    offsetX += tWidth;
                                }

                                if (tHeight != maxHeight)
                                {
                                    adjustY = (maxHeight - tHeight) / 2;
                                }
                                else
                                {
                                    adjustY = 0;
                                }

                                vx[i] = offsetX;
                                vy[i] = offsetY + adjustY;

                                vMoveX[i].Set(moveX, 0, rateStep);
                                vMoveY[i].Set(moveY, 0, rateStep);
                            }
                            else
                            {
                                // ܂Ԃŏ͉ZȂĂ`
                                if (i != turnPos)
                                {
                                    offsetY -= tHeight;
                                }

                                if (tWidth != maxWidth)
                                {
                                    adjustX = (maxWidth - tWidth) / 2;
                                }
                                else
                                {
                                    adjustX = 0;
                                }

                                vx[i] = offsetX + adjustX;
                                vy[i] = offsetY;

                                vMoveX[i].Set(moveX, 0, rateStep);
                                vMoveY[i].Set(moveY, 0, rateStep);
                            }

                            // {JE^̐ݒ
                            SetBasicCounter(i);
                            ++i;
                        }
                    }
                    break;
                default:
                    //Log.printError("Headlinear.OnDraw:Invalid Style!\n");
                    break;
            }
        }

        /// <summary>
        /// {JE^ݒ肷
        /// </summary>
        /// <param name="index"></param>
        private void SetBasicCounter(int index)
        {
            // Ɛݒ肵Ƃ[
            if (vAlpha.Count <= index) return;

            int step = 255 / rateStep;
            if ((255 % rateStep) != 0)
            {
                step++;
            }

            if (step <= 0)
            {
                step = 1;
            }

            // At@JE^
            vAlpha[index].Set(0, 255, step);

            // g僌[gJE^iXP[O
            int startRate = 0;
            startRate = (int)(startRate * RATE_SCALER);
            int endRate = (int)(1 * RATE_SCALER);
            vRate[index].Set(startRate, endRate, rateStep);
        }


        #endregion


    }
}
