using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Draw;
using Yanesdk.Math;
using Yamalib.Util;
using Yamalib;

namespace Kyojin.Scene.Title
{
    class TitleDial
    {
        /** pxNX */
        private class AngleControl
        {
            /// ]Ԓ`
            public enum ROTATE { STOP, LEFT, RIGHT };
            /// ̂Ƃx͌Œl
            public const float ACCELERATION = 0.025F;
            /// ̂Ƃx͌Œl
            public const float MAX_SPEED = 1.0F;
            /// Jnʒu
            public const int STOPPING_DIST = 15;
            public const float DEACCELERATION = 40.0F;

            /// ̊pxAŎw肳ꂽpxɉ]
            public void TurnTo(int rad)
            {
                if (rad == (int)m_nowAngle)
                {
                    return;
                }
                m_rotate = GetRoteTo(rad);
                m_dstAngle = rad;

                // ]
                if (ROTATE.LEFT == m_rotate)
                {
                    m_sgn = -1;
                }
                else if (ROTATE.RIGHT == m_rotate)
                {
                    m_sgn = 1;
                }

                //Log.print("AngleControl#TurnTo : %s to %s with %s", (int)m_nowAngle, Rad, m_sgn);
            }

            /// 쏈
            public void OnMove()
            {
                // ]ł邱
                if (ROTATE.STOP != m_rotate)
                {

                    m_speed += GetAccel();

                    // ]ɏ]āAx			
                    if (m_sgn < 0)
                    {
                        if (-MAX_SPEED > m_speed)
                        {
                            m_speed = -MAX_SPEED;
                        }
                    }
                    else
                    {
                        if (MAX_SPEED < m_speed)
                        {
                            m_speed = MAX_SPEED;
                        }
                    }

                    // ݂̑xŊpړ
                    m_nowAngle += m_speed;
                    NormalizeAngle(ref m_nowAngle);

                    if (m_targetAngleStopFlg)
                    {
                        // ]~
                        if (m_sgn < 0)
                        {
                            if (m_dstAngle >= m_nowAngle)
                            {
                                //Log.print("AngleControl#OnMove : STOP LEFT %s to %s", m_nowAngle, m_dstAngle);
                                m_rotate = ROTATE.STOP;
                            }
                        }
                        else
                        {
                            if (m_dstAngle <= m_nowAngle)
                            {
                                //Log.print("AngleControl#OnMove : STOP LEFT %s to %s", m_nowAngle, m_dstAngle);
                                m_rotate = ROTATE.STOP;
                            }
                        }
                    }

                }
                else
                {
                    // Xgbv
                    m_speed = 0.0f;
                }
            }

            /// ݂̊px擾
            public float GetNowAngle()
            {
                return m_nowAngle;
            }

            /// RXgN^
            public AngleControl()
            {
                m_sgn = 1;
            }


            private ROTATE GetRoteTo(int rad)
            {
                int now = (int)m_nowAngle;
                rad -= now;
                // 0 - 511 ɕ␳
                if (rad < 0)
                {
                    rad = 512 + now;
                }
                return rad < 256 ? ROTATE.RIGHT : ROTATE.LEFT;
            }

            /// ̊p0 - 511 ɐK
            public static void NormalizeAngle(ref float rad)
            {
                if (rad < 0)
                {
                    rad = 511.0F - rad;
                }
                else if (511.0F < rad)
                {
                    rad -= 511.0f;
                }
            }

            /// x擾
            private float GetAccel()
            {
                if (m_targetAngleStopFlg)
                {	// ~ŝł
                    // ł邩H
                    if (GetDistance() <= STOPPING_DIST)
                    {
                        // ts
                        return m_speed / DEACCELERATION * -m_sgn;
                    }
                }
                return m_accel * m_sgn;
            }

            /// 擾
            private int GetDistance()
            {
                return Math.Abs((int)m_nowAngle - (int)m_dstAngle);
            }

            /// ڕWƂȂpxɒBƂ~
            public void TargetAngleThenStop(bool b)
            {
                m_targetAngleStopFlg = b;
            }

            private float m_accel = ACCELERATION; 	//!< x
            private float m_speed = 0.0f;	//!< x
            private ROTATE m_rotate;	//!< ]̏
            private float m_nowAngle = 0.0f;
            private float m_dstAngle = 0.0f;
            private int m_sgn;	//! TC
            private bool m_targetAngleStopFlg;
        }


        #region otB[h

        /* ڕ`ʒu̒[̃}[W */
        private const int LC_ITEM_L_MARGIN = 20;

        static SinTable sin = SinTable.Instance;

        private int x;	//!< _CA̕\Sʒux
        private int y;	//!< _CA̕\Sʒuy
        private int sx;	//!< _CAeNX`TCYX
        private int sy; //!< _CAeNX`TCYY

        private int selectedPos;	//!< I𒆍ڃCfbNX
        private int rotateSpeed;	//!< ]x
        private bool rotate;			//!< ]ǂ\tO
        private RootCounterS angle;			//!< px

        private ITexture t_dial;		//!< _CÅ{eNX`
        private List<ITexture> vItems = new List<ITexture>(); 	//!< ̓_CAɂ{^Bǉ폜ŝVector
        private List<string> vNames = new List<string>(); 	//!< ڂɑ΂閼OtXg
        private List<Point> itemPoints = new List<Point>();	//!< ACe`{ʒuێ

        private AngleControl m_angleCtl;

        #endregion

        /// \Sʒu̐ݒ
        public void SetXY(int x_, int y_)
        {
            x = x_;
            y = y_;
        }

        /// _CA\Sʒu̎擾
        public void GetXY(out int x_, out int y_)
        {
            x_ = x;
            y_ = y;
        }

        /// {_CAeNX`̐ݒ
        public void SetDialTexture(ITexture tex)
        {

            t_dial = tex;
            sx = (int)t_dial.Width;
            sy = (int)t_dial.Height;

            //Log.print("SetDialTexture sx: %s, sy : %s", sx, sy);
        }

        /// _CAڃeNX`̒ǉ
        public void AddItem(ITexture t_)
        {
            vItems.Add(t_);
        }

        /// ڂ𖼑OtŒǉ
        /// ݉IĂ邩OgetNameŎ擾邱Ƃł
        public void AddItemName(ITexture t_, string name)
        {
            vNames.Add(name);
            AddItem(t_);
        }

        /// IĂ鍀ڂɊ֘AÂꂽOԋp܂
        public string GetSelectedItemName()
        {
            if (selectedPos == 0)
            {
                return vNames[0];
            }

            return vNames[vNames.Count - selectedPos];
        }

        /// Iςݔԍ擾
        public int GetSelectedPos()
        {
            return selectedPos;
        }

        /// ڂɊ֘AĂ閼Ow肵āÃACeI
        /// w肵O݂ȂfalseԂ
        bool SelectByName(string str)
        {
            int selected = -1;	// not found marker
            for (int i = 0; i < vNames.Count; i++)
            {
                if (vNames[i] == str)
                {
                    selected = vItems.Count - i;
                    break;
                }
            }

            if (-1 == selected)
            {
                return false;
            }
            selectedPos = selected;
            int dstAngle = (int)((512.0f / vItems.Count) * (selectedPos));
            angle.Set(dstAngle, dstAngle, rotateSpeed);
            return true;
        }

        /// _CAڂS܂
        public void ClearItems()
        {
            vItems.Clear();
        }

        /// w肵ACeɒs
        public void TurnTo(int itemID)
        {
            if (selectedPos == itemID)
            {
                //Ȃ
                return;
            }
            if (itemID >= vItems.Count)
            {
                //Ȃ
                return;
            }

            // ܂肩AE߂
            int dstAngle = (int)((512.0f / vItems.Count) * itemID);
            m_angleCtl.TurnTo(dstAngle);
            selectedPos = itemID;
        }


        /// Eivj
        public void TurnLeft()
        {

            // ڂȂ̂ɂ邱ƂȂ̂...
            if (0 == vItems.Count) return;

            // ]ł΁AȂɂȂ
            if (rotate) return;

            // Iʒu₷
            ++selectedPos;

            if (selectedPos >= vItems.Count)
            {
                selectedPos = 0;
            }

            // ݂̊px
            int nowAngle = angle.Value();
            int dstAngle = (int)((512.0f / vItems.Count) * selectedPos);

            if (nowAngle == Y4dConst.C_RAD_MAX)
            {
                // ̒lBOɃZbg
                nowAngle = 0;
            }

            if (dstAngle == 0)
            {
                // ͈ƂƁB
                dstAngle = Y4dConst.C_RAD_MAX;
            }

            angle.Set(nowAngle, dstAngle, rotateSpeed);

            //		    Log.print("TurnLeft : src %s, dst : %s, pos : %s", nowAngle, dstAngle, selectedPos );

            rotate = true;

        }

        /// ivj
        public void TurnRight()
        {

            // ڂȂ̂ɂ邱ƂȂ̂...
            if (0 == vItems.Count) return;

            // ]ł΁AȂɂȂ
            if (rotate) return;

            // Iʒu炷
            --selectedPos;

            if (selectedPos < 0)
            {
                selectedPos = vItems.Count - 1;
            }

            // ݂̊px
            int nowAngle = angle.Value();
            int dstAngle = (int)((512.0f / vItems.Count) * selectedPos);

            if (nowAngle == 0)
            {
                // ̒lBOɃZbg
                nowAngle = Y4dConst.C_RAD_MAX;
            }

            if (dstAngle == Y4dConst.C_RAD_MAX)
            {
                // ͈ƂƁB
                dstAngle = 0;
            }

            angle.Set(nowAngle, dstAngle, rotateSpeed);


            //		Log.print("TurnRight : src %s, dst : %s, pos : %s", nowAngle, dstAngle, selectedPos );

            rotate = true;
        }

        /// _CA]ǂ
        public bool IsAround()
        {
            return rotate;
        }

        /// ڕWƂȂpxɒBƂA~
        public void TargetAngleThenStop(bool b)
        {
            m_angleCtl.TargetAngleThenStop(b);
        }

        /// тƂȂ
        public void OnMove(IScreen scree)
        {
            m_angleCtl.OnMove();
        }

        /// ł邾ĂяoȂ
        public void OnDraw(IScreen screen)
        {

            // X, y摜̒S_Ƃĕ`悷 
            screen.BltRotate(t_dial, x, y, (int)m_angleCtl.GetNowAngle(), 1.0f, 4);
        }

        /// RXgN^
        public TitleDial()
        {
            angle = new RootCounterS();
            angle.Set(0, Y4dConst.C_RAD_MAX, 2);
            rotateSpeed = 2;
            m_angleCtl = new AngleControl();
        }


        /// ACe`悷ʒu擾܂
        private void CalcItemPos(out int[] xs, out int[] ys, out int[] angles)
        {
            // ݂̊px
            int agl = angle.Value();
            int itemCnt = vItems.Count;

            xs = new int[itemCnt];
            ys = new int[itemCnt];
            angles = new int[itemCnt];

            // _CAeNX`̔a
            int r = (sy / 2) - LC_ITEM_L_MARGIN;

            for (int i = 0; i < vItems.Count; i++)
            {
                ITexture t = vItems[i];
                int baseAngle = 256 + agl + (Y4dConst.C_RAD_MAX / itemCnt) * i;
                // _
                xs[i] = x + sin.Cos(baseAngle, r);
                ys[i] = y + sin.Sin(baseAngle, r);
                angles[i] = baseAngle - 256;
            }
        }

    }
}
