using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Math;
using Yamalib.Util;
using Yanesdk.Draw;

namespace Yamalib.Draw.Effect
{
    public class ScatteredTexture
    {

        /// <summary>
        /// IuWFNg
        /// PNXłPp[eBN
        /// </summary>
        public class BreakObject
        {
            public ITexture t;
            public readonly Rect rect = new Rect();	//!< `͈
            public int posx;	//!< `ʒu
            public int posy;	//!< `ʒu
            public int maxSize; //!< ̍őTCYi`̎ΕӒj
            public bool death;
            public bool enable;	//!< IuWFNgł邩

            public RootCounter angle;	//!< ]x
            public RootCounterS dx;	//!< ړ
            public RootCounterS dy;	//!< ړ

            /// ̃IuWFNg𖾎IɎE
            public void Kill()
            {
                death = true;
            }

            /// PIuWFNg̓
            public void OnMove()
            {

                if (death) return;

                dx++;
                dy++;
                angle++;
                posx += dx.Value();
                posy += dy.Value();

                if (posx < -maxSize || posx > 640 + maxSize)
                {
                    death = true;
                    return;
                }
                if (posy < -maxSize || posy > 480 + maxSize)
                {
                    death = true;
                    return;
                }
            }

            /// PIuWFNg̕`
            public void OnDraw(IScreen screen)
            {
                if (death) return;

                int height = (int)(rect.Height / 2);
                int width = (int)(rect.Width / 2);
                screen.BltRotate(t, posx, posy, rect, angle.Value(), 1.0f, width, height);
            }

            /// RXgN^
            public BreakObject()
            {
                angle = new RootCounter();
                angle.Set(0, 0, 1);
                dx = new RootCounterS();
                dx.Set(0, 0, 1);
                dy = new RootCounterS();
                dy.Set(0, 0, 1);
                enable = true;
            }

        }

        #region 萔l

        private const int ANGLE_RAND = 5;
        private const int X_RAND = 3;
        private const int Y_RAND = 5;

        #endregion

        #region tB[ho

        private Rand rand;
        private bool finish;
        private ITexture tex;

        private bool fade;
        private int fadeStep;
        private RootCounterS alpha;

        private int waitCount;

        private int posx;
        private int posy;
        private readonly List<BreakObject> objects = new List<BreakObject>();

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public ScatteredTexture()
        {
            rand = new Rand();
            rand.Randomize();
            alpha = new RootCounterS();
            alpha.Set(0, 0, 1);
        }

        /// eNX`
        public void SetTexture(ITexture t_)
        {
            tex = t_;
        }

        /// \ʒu
        public void SetXY(int x, int y)
        {
            posx = x;
            posy = y;
        }

        /// ҋ@Ԃ̐ݒ
        public void SetWaitCount(int u)
        {
            waitCount = u;
        }

        /// tF[h̐ݒ
        public void SetFade(bool fade_, int step/*=4*/)
        {
            fade = fade_;
            fadeStep = step;
            alpha.Set(255, 0, step);
        }

        /// ݂̑ΏۃeNX`̎擾
        public ITexture GetTexture()
        {
            return tex;
        }

        /// ҋ@Ԃ
        public bool IsWait()
        {
            return (bool)(waitCount > 0);
        }

        /// I
        public bool IsFinish()
        {
            return finish;
        }

        /// `撆
        public bool IsBreaking()
        {
            return (bool)(waitCount == 0);
        }

        /// Ԃ̃NA
        public void Clear()
        {
            objects.Clear();
            finish = false;
            alpha.Set(255, 0, fadeStep);
        }

        /// }XNf[^gpAsx, syPʂŕs
        /*
            At@tT[tFCXAAt@QƂAO̍WL
            𔻒肵A
        */
        public void DivisionTextureWithSurface(Surface surface, int divWidth, int divHeight)
        {
            if (surface == null) return;

            RectF[][] rects;
            List<RectF> rect1Dim;
            // `擾
            rects = ApartRegion.ApartFromTexture(surface, divWidth, divHeight);

            //assert( !(rects is null) );

            rect1Dim = ApartRegion.UniteRect(rects, 3, 10);

            //Log.print("divResult : %s \n", rect1Dim.length);

            // `񂵁Ap[eBN𐶐
            foreach (RectF rc in rect1Dim)
            {
                BreakObject bo = new BreakObject();
                SetBreakObjAttribute(bo, rc.Width, rc.Height, rc.left, rc.top);
                bo.enable = rc.enable;
                objects.Add(bo);
            }
        }

        /// column ~ row ɕ
        public void DivisionTexture(int column, int row) {
		if (tex == null) return;
        objects.Clear();

		int width = (int) tex.Width;
		int height = (int) tex.Height;
		float aWidth = width / column;
		float aHeight = height / row;
		
		for(float w=0.0f,h=0.0f; ; ) {
			BreakObject bo = new BreakObject();
			
			// Pʋ`̎w肩ABreakObject̑ݒ肷
			SetBreakObjAttribute(bo, aWidth, aHeight, w, h);

			objects.Add(bo);

			w += aWidth;
			if(!((int)w<width)) {
				w = 0.0f;
				h += aHeight;
				if ((int)h>height) break;
			}
		}
	}

        /// p[eBN̎擾
        public List<BreakObject> GetObjectInfo()
        {
            return objects;
        }

        /// ĂяoȂ
        public void OnMove(IScreen screen)
        {
            if (waitCount > 0)
            {
                waitCount--;
                return;
            }

            if (finish) return;

            if (fade) alpha++;

            bool invoke = false;
            foreach (BreakObject o in objects)
            {
                if (!o.death && o.enable)
                {
                    o.OnMove();
                    invoke = true;
                }
            }

            if (!invoke)
            {
                finish = true;
            }
        }

        /// ĂяoȂ
        public void OnDraw(IScreen screen)
        {
            if (finish) return;
            if (fade)
            {
                screen.SetColor(255, 255, 255, alpha.Value());
            }
            foreach (BreakObject o in objects)
            {
                if (!o.death)
                    o.OnDraw(screen);
            }
            if (fade)
            {
                screen.ResetColor();
            }
        }



        #region Jo

        /// <summary>
        /// BreakObject ̑ݒ肷
        /// </summary>
        /// <param name="bo">ݒ肷BreakObject</param>
        /// <param name="unitWidth">Pʕ</param>
        /// <param name="unitHeight">Pʍ</param>
        /// <param name="w">ʒuA</param>
        /// <param name="h">ʒuAy</param>
        private void SetBreakObjAttribute(BreakObject bo, float unitWidth, float unitHeight, float w, float h)
        {
            // gS̉摜̕
            int width = (int)tex.Width;
            // gS̉摜̍
            int height = (int)tex.Height;
            // ϐ
            int abs = 1;
            // юUW
            float keisu = 1.0f;

            // ӂ߂
            float bottom = h + unitHeight;

            // ӂ摜𒴂Ăꍇ͏C
            if ((int)bottom > height)
            {
                bottom = height;
            }

            // eNX`̃Zbg
            bo.t = tex;

            // `̐ݒ
            bo.rect.Left = w;
            bo.rect.Top = h;
            bo.rect.Right = bo.rect.Left + unitWidth;
            bo.rect.Bottom = bottom;

            // Εӂ̒߂
            float wid = bo.rect.Width;
            float hei = bo.rect.Height;

            bo.maxSize = (int)System.Math.Sqrt(wid * wid + hei * hei);

            // Agr[g̐ݒ
            bo.posx = posx + (int)bo.rect.Left;
            bo.posy = posy + (int)bo.rect.Top;

            // ̈ʒu摜̍ɈʒuȂ
            if ((int)w < (width / 2))
            {
                abs = -1;
                wid = bo.rect.Left - width / 2;
                keisu = wid / (width / 2);
            }
            else
            {
                abs = 1;
                wid = width / 2 - bo.rect.Left;
                keisu = wid / (width / 2);
            }

            //----- U΂鏈Agr[g -----
            // ̈ړ		
            int xStart = (3 + rand.GetRand(3)) * abs;
            int xStep = -(12 + rand.GetRand(5));

            // ̈ړ
            int yEnd = 4 + rand.GetRand(2);
            int yStep = -(5 + rand.GetRand(5));

            // p]x
            int angleStep = 5 + rand.GetRand(15);

            bo.dx.Set(xStart, 0, xStep);
            bo.dy.Set(0, yEnd, yStep);
            bo.angle.Set(0, 511, angleStep);
        }


        #endregion
    }
}
