using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Math;
using Yanesdk.Draw;

namespace Yamalib.Draw.Effect
{
    /// <summary>
    /// eNX`𐅕ŃYYŕ\NX
    /// </summary>
    public class TextureLineNoise
    {
        #region tB[ho

        private readonly Rand rand;
        private ITexture t;
        private readonly List<int> slant = new List<int>();	//!< ꕝ
        private int posx;
        private int posy;
        private int randWidth;
        private int effectingCounter;
        private int effectingTime;
        private int nowEffectingTime;
        private bool bEffectingTimeRand = true;
        private bool bInterval;
        private int intervalCounter;
        private int interval;
        private int nowInterval;
        private bool intervalRand = true;
        private int tWidth = 0;
        private int tHeight = 0;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public TextureLineNoise()
        {
            rand = new Rand();
            rand.Randomize();
            randWidth = 4;
            interval = 100;
            effectingTime = 60;
            nowEffectingTime = rand.GetRand(effectingTime);
        }

        /// <summary>
        /// tFNg`悷eNX`[
        /// </summary>
        public ITexture Texture
        {
            get { return t; }
            set
            {
                t = value;
                tWidth = (int)t.Width;
                tHeight = (int)t.Height;
            }
        }

        /// <summary>
        /// `ʒu̐ݒ
        /// </summary>
        /// <param name="X"></param>
        /// <param name="Y"></param>
        public void SetXY(int x, int y)
        {
            posx = x;
            posy = y;
        }

        /// <summary>
        /// ̊Ԃ̕σt[
        /// </summary>
        public int Interval
        {
            get { return nowInterval; }
            set { nowInterval = value; }
        }

        /// <summary>
        /// Ԃ̐Ԉێt[_ɂ
        /// </summary>
        public bool UseIntervalRand
        {
            get { return intervalRand; }
            set { intervalRand = value; }
        }

        /// <summary>
        /// ꂪ镽σt[
        /// </summary>
        public int EffectingTime
        {
            get { return effectingTime; }
            set { effectingTime = value; }
        }

        /// <summary>
        /// ꂪ鎞Ԃ𗐐ɂ
        /// </summary>
        public bool UseEffectingTimeRand
        {
            get { return bEffectingTimeRand; }
            set { bEffectingTimeRand = value; }
        }

        /// <summary>
        /// Ƃ肤镝
        /// </summary>
        public int RandWidth
        {
            get { return randWidth; }
            set { randWidth = value; }
        }

        /// <summary>
        /// `揈
        /// </summary>
        /// <param name="screen"></param>
        public void OnPaint(IScreen screen)
        {
            if (t == null) return;

            if (bInterval)
            {
                intervalCounter++;
                if (nowInterval <= intervalCounter)
                {
                    intervalCounter = 0;
                    bInterval = false;
                    nowInterval = rand.GetRand(interval);
                }
            }

            if (bInterval)
            {
                screen.Blt(t, posx, posy);
            }
            else
            {
                Rect rc = new Rect();
                for (int i = 0; i < tHeight; ++i)
                {
                    rc.Top = i;
                    rc.Bottom = i + 1;
                    rc.Left = 0;
                    rc.Right = tWidth;

                    int offsetx = rand.GetRand(randWidth) - randWidth / 2;
                    screen.Blt(t, posx + offsetx, posy + i, rc);

                }
            }

            if (!bInterval)
            {
                effectingCounter++;
                if (nowEffectingTime <= effectingCounter)
                {
                    effectingCounter = 0;
                    bInterval = true;
                    nowEffectingTime = rand.GetRand(effectingTime);
                }
            }
        }
    }
}
