module kyojintati4d.kyeconfig;

private import yamalib.serialize;

private import yamalib.log.log;

/** KyeConfigのデータクラス */
class KeyConfigData : Archive {
	static final const uint KEY_CONFIG_MAX = 64;	//!< これ以上のキー割り当てしようなんて...
	static final const int SEVE_DATA_VERSION_LATEST = 100;
	static final const int SEVE_DATA_VERSION_100 = 100;
	
	/// シリアライズ
	override void serialize(inout Serialize s) {
		// 何にせよ、ここで最新バージョンにしておく
		dataVersion = SEVE_DATA_VERSION_LATEST;
		s << dataVersion;
		if (SEVE_DATA_VERSION_LATEST == dataVersion ) {
			s << m_deviceName;
			foreach(inout int[] keyData; m_keyData) {
				s << keyData;
			}
		} else if (SEVE_DATA_VERSION_LATEST > dataVersion ) {
			// 下位互換
			// ここで、それぞれの下位バージョンを判定し、追加されたデータにデフォルト値を設定
			Log.printError("Can't load this save data version : %s", dataVersion);
		} else if (SEVE_DATA_VERSION_LATEST < dataVersion ) {
			// 上位互換
			// たぶん、これは、おもわぬ動作を引き起こすので、バージョンアップを促す
			Log.printError("Can't load this save data version : %s", dataVersion);
		}
/*		
		foreach(int i,int[] keyData; m_keyData) {
			printf("%d : ", i);
			foreach(int keyNo; keyData) {
				printf("%d  ", keyNo);
			}
			printf("\n");
		}
*/
	}
	
	/// id に keynoを登録する
	void setKeyData(int id, int[] keyNo) {
		if (id >= KEY_CONFIG_MAX) {
			throw new Exception("KEY RESIST OVER");
		}
		this.m_keyData[id] = keyNo;
	}
	
	/// 登録されているKeyDataを取得する
	int[] getKeyData(int id) {
		return this.m_keyData[id];
	}
	
	/// デバイス名をセットする
	void setDeviceName(char[] name_) {
		this.m_deviceName = name_;
	}
	
	/// デバイス名を取得する
	char[] getDeviceName() {
		return this.m_deviceName;
	}
	
	/// コンストラクタ
	this() {
		this.m_keyData = new int[][KEY_CONFIG_MAX]; 
	}

private:
	int[][] m_keyData;
	int dataVersion;
	char[] m_deviceName;	//!< このKEYの対象となった入力装置の名前
	
	unittest {
		KeyConfigData obj = new KeyConfigData();
		int[3] data;
		data[0] = 1;
		data[1] = 2;
		data[2] = 3;
		obj.setKeyData(4, data);
		assert( obj.m_keyData[4].length == 3);
		bool error = false;
		try {
			obj.setKeyData(64,data);
		} catch (Object e) {
			error = true;
		}
		assert( error == true );
	}
}