﻿module kyojintati4d.taskpinup;

private import y4d;
private import kyojintati4d.myapp;
private import kyojintati4d.gameinfo;

private import yamalib.draw.camerawork;
private import yamalib.log.log;


/**
	シナリオ終了後のピンナップタスク
*/
class TaskPinup : GameTaskBase {

	/// タスク名を返却する
	/**
		このタスク名称を使って、コントローラ部でタスク判別を行う可能性があるので
		ユニークな名前で、実装しておくべきである
	*/	
	override char[] getTaskName() {
		with (kyojintati4d.val.kyojinconst) {
			return KyojinConst.TASK_NAME[KyojinConst.Task.Task_Pinup];
		}
	}

	/// 毎回呼び出すなり
	override int onMove(Object o) {
		try {
			info = cast(GameInfo) o;
			
			// 初期処理
			if(!m_init) {
				onInit();
				m_init = true;
			}
	
			cw.onMove(info.screen);	
			
			// 終了判定
			if ( cw.isEnd() ) {
				Log.printLook("NEXT SCENARIO!!");
				info.gameSceneTransiter.setTransitType(19, 1);
				info.gameSceneTransiter.returnScene();
				return 1;
			}
			
			return 0;
		} catch (Exception e) {
			Log.printFatal("RuntimeException %s#onMove : [%s] [%s]", 
				super.toString(), e.toString(), e.msg);
			throw e;
		}
	}
	
	/// 出来るだけ毎回呼び出すなり
	override int onDraw(Object o) {
		try {
			info = cast(GameInfo) o;
	//		info.screen.blendSrcAlpha ();
		
			cw.onDraw(info.screen);	
		
			return 0;
		} catch (Exception e) {
			Log.printFatal("RuntimeException %s#onDraw : [%s] [%s]", super.toString(), e.toString(), e.msg);
			throw e;
		}
	}
	
	/// レガシーなやつ
	override int task(Object o) {
		return 0;
	}

	/// 占有しているメモリを解放する
	override void destroy() {
		this.cw = null;
		this.nowTex = null;

		Log.print("%s#destroy : destroyed.", super.toString());
	}
	
private:

	/// 初期化処理
	void onInit() {
		// メモリー状況をプリント
		GameInfo.printMemoryState();

		nowTex = new Texture();
		nowTex.load("img/pin/pin01.png");
		
		// カメラワーククラス生成
		cw = new CameraWork("img/mian_ending/s11/cw/list.lst", 2, 2);
		cw.setBaseTexture(nowTex);
		cw.loadFlow("mouse.txt");
		cw.addSubjectSimple( nowTex, 1400, 1257);
		
		nowTex = new Texture();
		nowTex.load("img/pin/pin01.png");
		cw.addSubjectSimple( nowTex, 1200, 1457);
		
		/// ＦＳＰによってシーン速度を切り替える 
		cw.setSpeed(KyojinConst.C_FSP_DEFAULT / KyojinConst.C_FSP_NOW);
	}

	GameInfo info;
	bool m_init;
	CameraWork cw;
	
	Texture nowTex;

}