﻿module kyojintati4d.component.ending.scene05;

private import std.string;
private import std.utf;

private import y4d;
private import y4d_draw.transbltter;
private import y4d_aux.filesys;

private import kyojintati4d.gameinfo;
private import kyojintati4d.component.ending.movieproxy;
private import kyojintati4d.component.rhythm.keyconfigdialon;
private import kyojintati4d.component.ending.scenebase;
private import kyojintati4d.component.ending.scene02;

private import kyojintati4d.component.ending.floatagetexture;
private import kyojintati4d.component.ending.endingmoment;

private import yamalib.draw.spreadstring;
private import yamalib.draw.noisebltter;
private import yamalib.counterfsp;
private import yamalib.log.log;

/**
 * シーン１の効果を取り扱うクラス
 * ・予告編テキストのSpreadString表示
 * ・ヒット成果によって動画再生
 * ・スコア表示
 * ・製作クレジット
 */
public class Scene05 : Scene02 {
	// 念のため時間でも終了時間もチェック
	private static const uint END_TIME = 245_200 + MUSIC_OFFSET_TIME; 

	/// コンストラクタ
	this(FixTimer timer) {
		super(timer);

		rand = new Rand();
		rand.randomize();
		
		// シーン１用
		gamePointCal = new GamePointCal();
		transCounter = new RootCounterS(0, 255, 4);
		rankAlpha = new RootCounterS(255, 0, 10);
		
		// 使用する画像をロード
		textureLoader.loadDefFile(cast(char[]) "img2/ending/s05/bglist.txt");
		floatageTexturePool = new FloatageTexturePool;
		floatageTexturePool.setMax(2048);
		foreach (inout floatageTexture; floatageTexturePool) {
			floatageTexture = new FloatageTexture();
		}
		
		// シーン５
		m_scene5Alpha = new RootCounterS();
		m_scene5Alpha.set(0, 255 , 5);
	}

	/// すべての画像をキャッシュする	
	override void cacheTexture() {
		cacheTextureAll(textureLoader);
	}

	private static const uint START_TIME = 195_500 + MUSIC_OFFSET_TIME;
	
	/** シーンは開始しているか */
	override bool isStart() {
		return START_TIME <= timer.get();
	}

	/** シーンが終了したか */
	override bool isEnd() {
		return sceneEndFlg || END_TIME <= timer.get();
	}

	/// タイミングデータ作成
	protected override void setupTimingData() {
		// なにもしない
	}
	
	/// 移動処理
	void onMove(Screen screen) {
		checkScene(screen);
		
		if (startScene1) {
			onMoveScene1(screen);
		}
		
		if (startScene2_1) {
			if (scene2_1 !is null) {
				scene2_1.onMove(screen);
			}
		}
		if (startScene2_2) {
			if (scene2_2 !is null) {
				scene2_2.onMove(screen);
			}
		}
		if(startScene3_1) {
			if (scene3_1 !is null) {
				scene3_1.onMove(screen);
			}
		}
		if(startScene3_2) {
			if (scene3_2 !is null) {
				scene3_2.onMove(screen);
			}
		}
		if(startScene3_3) {
			if (scene3_3 !is null) {
				scene3_3.onMove(screen);
			}
		}
		if(startScene3_4) {
			if (scene3_4 !is null) {
				scene3_4.onMove(screen);
			}
		}
		if(startScene4_1) {
			if (scene4_1 !is null) {
				scene4_1.onMove(screen);
			}
		}
		if(startScene4_2) {
			if (scene4_2 !is null) {
				scene4_2.onMove(screen);
			}
		}
		if (startScene5) {
			onMoveScene5(screen);
		}
	}
	
	/** 描画処理 */
	void onDraw(Screen screen) {
		screen.setColor(255,255,255,255);
		if (startScene1) {
			onDrawScene1(screen);
		}
		if (startScene2_1) {
			if (scene2_1 !is null) {
				scene2_1.onDraw(screen);
			}
		}
		if (startScene2_2) {
			if (scene2_2 !is null) {
				scene2_2.onDraw(screen);
			}
		}
		if(startScene3_1) {
			if (scene3_1 !is null) {
				scene3_1.onDraw(screen);
			}
		}
		if(startScene3_2) {
			if (scene3_2 !is null) {
				scene3_2.onDraw(screen);
			}
		}
		if(startScene3_3) {
			if (scene3_3 !is null) {
				scene3_3.onDraw(screen);
			}
		}
		if(startScene3_4) {
			if (scene3_4 !is null) {
				scene3_4.onDraw(screen);
			}
		}
		if(startScene4_1) {
			if (scene4_1 !is null) {
				scene4_1.onDraw(screen);
			}
		}
		if(startScene4_2) {
			if (scene4_2 !is null) {
				scene4_2.onDraw(screen);
			}
		}
		if (startScene5) {
			onDrawScene5(screen);
		}
	}

	/** フォントリポジトリを準備 */
	void setFontRepository(FontRepository fontRep) {
		fontRepositry = fontRep;
	}
	
private:
	/** 共通シーンクラス */
	static class CutDraw {
	public:
		/** コンストラクタ */
		this(final Texture bgImg, final Texture nextBgImg, final FloatageTexture[] texts, final MovieProxy movie) {
			// ムービーをロード
			this.movie = movie;
		
			// テキスト描画体を構築
			flotageTex = texts;
		
			// bg画像を設定
			this.bgImg = bgImg;
			this.nextBgImg  = nextBgImg;
			
			rand = new Rand();
			rand.randomize();
			
			m_alphaCounter = new InteriorCounter();
			m_alphaCounter.set(192, -192, 128);
		}
	
		void onMove(Screen screen) {
			// 文字テクスチャ
			foreach (ft; flotageTex) {
				ft.onMove(screen);
			}
		}
			
		void onDraw(Screen screen) {
			
			// ムービー描画
			onDrawMovie(screen);

			// 文字描画
			onDrawText(screen);

			// 背景描画 こいつインスタンスもつくれんのかいな
			onDrawBg(screen);
		}
		
		void release() {
			// 文字
			
			// ムービー
			if  (movie !is null) {
				movie.release();
			}
		}
		
		FloatageTexture[] floatageTexture() {
			return flotageTex;
		}
		
		/** ムービーフラグ */
		bool useMovie() {
			return useMovieFlg;
		}
		bool userMovie(bool value) {
			return useMovieFlg = value;
		}
		
		InteriorCounter alphaCounter() {
			return m_alphaCounter;
		}
		
	private:
		Texture bgImg;
		Texture nextBgImg;
		FloatageTexture[] flotageTex;
		MovieProxy movie;
		bool useMovieFlg;
		InteriorCounter m_alphaCounter;
		Rand rand;
		                
		void onDrawMovie(Screen screen) {
			m_alphaCounter.inc();
		}
		
		void onDrawText(Screen screen) {
			// 文字の表示
			foreach (ft; flotageTex) {
				switch(rand.get(3)) {
				case 0:
					screen.blendAddColorAlpha();
					break;
				case 1:
//					screen.blendSubColorAlpha();
					screen.blendAddColorAlpha();
					break;
				case 2:
//					screen.blendSrcAlpha();
					screen.blendAddColorAlpha();
					break;
				}
				if (ft.drawInfo.color() is null) {
					ft.drawInfo.color = new Color4ub();
				}
				int baseEle = rand.get(255);
				ft.drawInfo.color.setColor(baseEle,baseEle,baseEle,96);
				ft.onDraw(screen);
			}
		}
		  
		/** 背景の描画 */
		void onDrawBg(Screen screen) {
//			NoiseBltter.bltUnVerticalSync(screen, bgImg, 0, 0);
			screen.blendSubColorAlpha();
			if (m_alphaCounter.get() > 0) {
				screen.setColor(255, 255, 255, m_alphaCounter.get());
				screen.blt(bgImg, 0, 0);
			} else {
				screen.setColor(255, 255, 255, -m_alphaCounter.get());
				screen.blt(nextBgImg, 0, 0);
			}
		}
		
	}
	
	alias objectPool!(FloatageTexture) FloatageTexturePool;

	// 文字テクスチャのランダム
	Rand rand;
	// 文字テクスチャ生成のためのリポジトリ
	FontRepository fontRepositry;
	// 文字テクスチャオブジェクトのプール
	FloatageTexturePool floatageTexturePool;
	
	private static final uint PHASE_1_START_TIME = 130_000 + MUSIC_OFFSET_TIME;

/*	
	private static final uint PHASE_2_1START_TIME = 206_200 + MUSIC_OFFSET_TIME;
	private static final uint PHASE_2_2START_TIME = 211_300 + MUSIC_OFFSET_TIME;
	
	private static final uint PHASE_3_1START_TIME = 216_800 + MUSIC_OFFSET_TIME;
	private static final uint PHASE_3_2START_TIME = 219_450 + MUSIC_OFFSET_TIME;
	private static final uint PHASE_3_3START_TIME = 222_100 + MUSIC_OFFSET_TIME;
	private static final uint PHASE_3_4START_TIME = 224_750 + MUSIC_OFFSET_TIME;
	
	private static final uint PHASE_4_1START_TIME = 227_400 + MUSIC_OFFSET_TIME;
	private static final uint PHASE_4_2START_TIME = 231_100 + MUSIC_OFFSET_TIME;
	private static final uint PHASE_5START_TIME	  = 237_000 + MUSIC_OFFSET_TIME;
*/

	private static final uint PHASE_2_1START_TIME = 206_200 + MUSIC_OFFSET_TIME;
	private static final uint PHASE_2_2START_TIME = 209_950 + MUSIC_OFFSET_TIME;
	
	private static final uint PHASE_3_1START_TIME = 214_700 + MUSIC_OFFSET_TIME;
	private static final uint PHASE_3_2START_TIME = 218_450 + MUSIC_OFFSET_TIME;
	private static final uint PHASE_3_3START_TIME = 222_200 + MUSIC_OFFSET_TIME;
	private static final uint PHASE_3_4START_TIME = 225_950 + MUSIC_OFFSET_TIME;
	
	private static final uint PHASE_4_1START_TIME = 229_700 + MUSIC_OFFSET_TIME;
	private static final uint PHASE_4_2START_TIME = 233_450 + MUSIC_OFFSET_TIME;
	private static final uint PHASE_5START_TIME	  = 238_000 + MUSIC_OFFSET_TIME;
	
	
	/** シーンの開始終了チェック */
	void checkScene(Screen screen) {
		const int scene3Step = 100;
		if (!startScene2_1 && timer.get() > PHASE_2_1START_TIME) {
			startScene1 = false;
			startScene2_1 = true;
			currentCutDraw = scene2_1 = initScene(0, 1, cast(char[]) "img2/ending/s05/special1.txt", null);
			scene2_1.alphaCounter.set(m_screenAlpha, -m_screenAlpha, 128);
		}
		if (!startScene2_2 && timer.get() > PHASE_2_2START_TIME) {
			Log.print("START RELEASE SCENE2.1");
			releaseCutDraw(scene2_1);
			Log.print("END RELEASE SCENE2.1");
			scene2_1 = null;
			startScene2_2 = true;
			Log.print("START initScene for 2.2");
			
			currentCutDraw = scene2_2 = initScene(1, 2, cast(char[]) "img2/ending/s05/special2.txt", null);
			scene2_2.alphaCounter.set(m_screenAlpha, -m_screenAlpha, 128);
			Log.print("END initScene for 2.2");
		}
		if (!startScene3_1 && timer.get() > PHASE_3_1START_TIME) {
			Log.print("START RELEASE SCENE2.2");
			releaseCutDraw(scene2_2);
			Log.print("END RELEASE SCENE2.2");
			scene2_2 = null;
			startScene3_1 = true;
			Log.print("START initScene for 3.1");
			currentCutDraw = scene3_1 = initScene(2, 3, cast(char[]) "img2/ending/s05/zero1.txt", null);
			scene3_1.alphaCounter.set(m_screenAlpha, -m_screenAlpha, scene3Step);
			Log.print("END initScene for 3.1");
		}
		if (!startScene3_2 && timer.get() > PHASE_3_2START_TIME) {
			Log.print("START RELEASE SCENE3.1");
			releaseCutDraw(scene3_1);
			Log.print("END RELEASE SCENE3.1");
			scene3_1 = null;
			startScene3_2 = true;
			Log.print("START initScene for 3.2");
			currentCutDraw = scene3_2 = initScene(3, 4, cast(char[]) "img2/ending/s05/zero2.txt", null);
			scene3_2.alphaCounter.set(m_screenAlpha, -m_screenAlpha, scene3Step);
			Log.print("END initScene for 3.2");
		}
		if (!startScene3_3 && timer.get() > PHASE_3_3START_TIME) {
			Log.print("START RELEASE SCENE3.2");
			releaseCutDraw(scene3_2);
			Log.print("END RELEASE SCENE3.2");
			scene3_2 = null;
			startScene3_3 = true;
			Log.print("START initScene for 3.3");
			currentCutDraw = scene3_3 = initScene(4, 5, cast(char[]) "img2/ending/s05/zero3.txt", null);
			scene3_3.alphaCounter.set(m_screenAlpha, -m_screenAlpha, scene3Step);
			Log.print("END initScene for 3.3");
		}
		if (!startScene3_4 && timer.get() > PHASE_3_4START_TIME) {
			Log.print("START RELEASE SCENE3.3");
			releaseCutDraw(scene3_3);
			Log.print("END RELEASE SCENE3.3");
			scene3_3 = null;
			startScene3_4 = true;
			Log.print("START initScene for 3.4");
			currentCutDraw = scene3_4 = initScene(5, 6, cast(char[]) "img2/ending/s05/zero4.txt", null);
			scene3_4.alphaCounter.set(m_screenAlpha, -m_screenAlpha, scene3Step);
			Log.print("END initScene for 3.4");
		}
		if (!startScene4_1 && timer.get() > PHASE_4_1START_TIME) {
			Log.print("START RELEASE SCENE3.4");
			releaseCutDraw(scene3_4);
			Log.print("END RELEASE SCENE3.4");
			scene3_4 = null;
			startScene4_1 = true;
			Log.print("START initScene for 4.1");
			currentCutDraw = scene4_1 = initScene(6, 7, cast(char[]) "img2/ending/s05/last1.txt", null);
			scene4_1.alphaCounter.set(m_screenAlpha, -m_screenAlpha, 128);
			Log.print("END initScene for 4.1");
		}
		if (!startScene4_2 && timer.get() > PHASE_4_2START_TIME) {
			Log.print("START RELEASE SCENE4.1");
			releaseCutDraw(scene4_1);
			Log.print("END RELEASE SCENE4.1");
			scene4_1 = null;
			startScene4_2 = true;
			Log.print("START initScene for 4.2");
			currentCutDraw = scene4_2 = initScene(7, -1, cast(char[]) "img2/ending/s05/last2.txt", null);
			scene4_2.alphaCounter.set(m_screenAlpha, -m_screenAlpha, 128);
			Log.print("END initScene for 4.2");
		}
		if (!startScene5 && timer.get() > PHASE_5START_TIME) { 
			Log.print("START RELEASE SCENE4.2");
			startScene5 = true;
			scene4_2 = null;
			screen.setClearColor(255,255,255);
			Log.print("END initScene for 5");
		}
	}
	
	void releaseCutDraw(CutDraw cutDraw) {
		foreach (ft; cutDraw.floatageTexture) {
			ft.reset();
			floatageTexturePool.push(ft);
		}
	}
	
	/** シーンを初期化して、インスタンスを返却する */
	CutDraw initScene(int textureNo, int nextTextureNo, char[] messageFile, MovieProxy movieFile) {
		auto messages = loadMessage(messageFile, 512);
		FloatageTexture[] result;
		int basey = 80;
		for (int i = 0; i < 30; ++i) {
			if (messages.length <= i) {
				break;
			}
			auto fts = createFloatageTextureFromString(messages[rand.get(messages.length)], 50, 
					basey, 630, 430);
			if (fts !is null) {
				basey += cast(int) fts[length - 1].texture.getHeight() + 10;
				if (fts[length - 1].drawInfo.y > 430) {
					break;
				}
			} else {
				// 全部読み込んだ
				break;
			}
			result ~= fts;
		}
		
		return  new CutDraw(textureLoader.get(textureNo), 
				nextTextureNo >= 0 ? textureLoader.get(nextTextureNo) : null, result, movieFile);
	}

	/** サンプルメッセージを読み込む */
	wchar[][] loadMessage(char[] filename, int maxLength = 50) {
		char[] strText = cast(char[]) FileSys.read(filename);
		wchar[][] result;
		std.stream.MemoryStream m = new std.stream.MemoryStream(cast(ubyte[]) strText);
		while (!m.eof) {
			wchar[] wc = .toWCS(cast(char[]) m.readLine());
			if (wc is null) {
				continue;
			}
			if (wc.length > maxLength) {
				result ~= wc[0..maxLength];
			} else {
				result ~= wc;
			}
		}
		return result;
	}
	
	static float RAND_SCALE = 100000.0f;
	float getRand(float min, float max) {
		return min + ((max - min) * (rand.get(cast(int) RAND_SCALE) / RAND_SCALE));
	}
	
	
	FloatageTexture[] createFloatageTextureFromString(wchar[] text, int offsetx, int offsety, int maxWidth, int maxHeight) {
		return createFloatageTextureFromStringRate(text, offsetx, offsety, maxWidth, maxHeight, 0.0f, 0.75f);
	}
	
	
	/// 文字テクスチャを生成(拡大縮小)
	FloatageTexture[] createFloatageTextureFromStringRate(wchar[] text, int offsetx, int offsety, 
			int maxWidth, int maxHeight, float minRate, float maxRate) {

		FloatageTexture[] result;
		float ox = 0.0f;
		foreach (ch; text) {
			auto ft = floatageTexturePool.pop();
			if (ft is null) {
				break;
			}
			
			ft.texture = fontRepositry.getTexture(ch);
			assert(ft.texture !is null);
			if (maxWidth > ox + offsetx) {
				ft.drawInfo.x = cast(int) ox + offsetx;
			} else {
				// 改行
				ox = 0;
				offsety += cast(int) ft.texture.getHeight();
			}
			ft.drawInfo.y = offsety;
			ft.drawInfo.drawOffset = 4;
			// 拡大率
			// 回転角
			// カラー
			
			// オフセット調整
			ox += ft.texture.getWidth();
			
			// モーメント作成
			auto moment = new RateRadMoment();
			moment.addRad = getRand(-1.0f, 4.0f);
			moment.addRate = getRand(minRate, maxRate);
//			moment.addRad = getRand(-0.5f, 0.5f);
//			moment.addRate = getRand(0.0f, 0.01f);

			// モーメント追加
			Moment[] moments;
			moments ~= moment;
			ft.moments = moments;
			
			result ~= ft;
		}
		
		invariant MOVE_COUNT = 60;
		foreach(ft;result) {
			for (int i = 0; i < MOVE_COUNT; ++i) {
				ft.onMove(null);
			}
			ft.moments()[0].reverse(true);
		}
		
		return result;
	}
	
	// シーン１　スコア表示用変数
	GamePointCal gamePointCal;
	int historyPos;
	InteriorCounter stepCounter;
	RootCounterS rankAlpha;
	RootCounterS transCounter;
	float rankRate = 1.0f;
	float statusRate = 1.0f;
	bool rankHistroyEnd = false;
	bool rankFadeOut = false;
	
	/** シーン１ スコア表示 */
	void onMoveScene1(Screen screen) {
		
		if (!rankHistroyEnd) {
			auto statusHistory = gamePointcalculator().statusHistory;
			transCounter.inc();
			
			if (stepCounter is null) {
				stepCounter = new InteriorCounter();
				stepCounter.set(0, statusHistory.length, 150);
			}
			
			stepCounter.inc();
			auto nextPos = stepCounter.get();
			if (statusHistory.length <= historyPos) {
				return;
			}
			
			for (int i = historyPos; i < nextPos; ++i) {
				// 計算させる
				gamePointCal.calcHitPoint(statusHistory[i]);
			}
			historyPos = nextPos;
			
			if (stepCounter.isEnd) {
				rankHistroyEnd = true;
			}
		} else {
			rankAlpha.inc();
			rankRate += 0.08f;
			if (rankAlpha.isEnd) {
				rankFadeOut = true;
			}
		}
		
	}
	void onDrawScene1(Screen screen) {
		
		if (rankFadeOut) {
			screen.blendAddColorAlpha();
			statusRate += 0.1f;
		}
		
		// ステータス履歴
		auto statusHistory = gamePointcalculator().statusHistory;
		auto offsetx = 80;
		auto offsety = 22;
		auto baseAlpha = 64;
		auto randAlpha = 16;
		for (int i = 0; i < historyPos; ++i) {
			Texture targetTexture;
			switch(statusHistory[i]) {
			case HitStatus.GREAT:
				screen.setColor(GREAT_COLOR.r, GREAT_COLOR.g, GREAT_COLOR.b, baseAlpha + rand.get(randAlpha));
				targetTexture = textureLoader.get(19);
				break;
			case HitStatus.GOOD:
				screen.setColor(GOOD_COLOR.r, GOOD_COLOR.g, GOOD_COLOR.b, baseAlpha + rand.get(randAlpha));
				targetTexture = textureLoader.get(20);
				break;
			case HitStatus.BAD:
				screen.setColor(BAD_COLOR.r, BAD_COLOR.g, BAD_COLOR.b, baseAlpha + rand.get(randAlpha));
				targetTexture = textureLoader.get(21);
				break;
			case HitStatus.POOR:
				screen.setColor(BAD_COLOR.r, BAD_COLOR.g, BAD_COLOR.b, baseAlpha + rand.get(randAlpha));
				targetTexture = textureLoader.get(22);
				break;
			case HitStatus.ERROR:
				screen.setColor(255, 0, 0, 128 + rand.get(randAlpha));
				targetTexture = textureLoader.get(23);
				break;
			default:
				break;
			}
			screen.bltRotate(targetTexture, 40 + offsetx * (i % 8), 11 + offsety * (i /8), 0, 
					statusRate, 4);
		}
		
		// 色を白にしておく
		screen.setColor(255,255,255,255);
		
		// トータル
		TransBltter.blt(22, screen, textureLoader.get(9), 120, 325, transCounter.get());

		// 小数点切り捨て
		int scorePoint = cast(int) gamePointCal.totalPoint;
		auto scorePointStr = std.utf.toUTF16( std.string.toString(scorePoint) );
		Texture[] pointTexture;
		foreach(w;scorePointStr) {
			pointTexture ~= fontRepositry.getTexture(w);
		}
		
		// スコアの表示
		float ox = 0.0f;
		float sizeRate = 1.5f;
		foreach(texture;pointTexture) {
			screen.bltRotate(texture, 320 + cast(int) ox, 325, 0, sizeRate, 0);
			ox += texture.getWidth() * sizeRate + 3.0f;
		}
		
		// ランク
		TransBltter.blt(22, screen, textureLoader.get(10), 180, 382, transCounter.get());
		Texture rankTexture;
		if (scorePoint > 350_000) {
			rankTexture = textureLoader.get(17);
			m_screenAlpha = 192;
			m_rankId = 6;
		} 
		else if (scorePoint > 250_000)
		{
			rankTexture = textureLoader.get(16);
			m_screenAlpha = 128;
			m_rankId = 5;
		}
		else if (scorePoint > 150_000)
		{
			rankTexture = textureLoader.get(15);
			m_screenAlpha = 64;
			m_rankId = 4;
		}
		else if (scorePoint > 75_000)
		{
			rankTexture = textureLoader.get(14);
			m_screenAlpha = 32;
			m_rankId = 3;
		}
		else if (scorePoint > 50_000)
		{
			rankTexture = textureLoader.get(13);
			m_screenAlpha = 8;
			m_rankId = 2;
		}
		else if (scorePoint > 20_000)
		{
			rankTexture = textureLoader.get(12);
			m_screenAlpha = 4;
			m_rankId = 1;
		}
		else
		{
			rankTexture = textureLoader.get(11);
			m_screenAlpha = 0;
			m_rankId = 0;
		}
		screen.bltRotate(rankTexture, 327, 397, 0, 1.0f, 4);
		
		
		if (stepCounter.isEnd) {
			screen.setColor(255,255,255, rankAlpha.get());
			// ランクエフェクト
			screen.bltRotate(rankTexture, 327, 397, 0, rankRate, 4);
		}
		
		// 次のシーンへの橋渡し
		if (rankFadeOut) {
			screen.setColor(255,255,255, m_screenAlpha);
			screen.blendSubColorAlpha();
			screen.blt(textureLoader.get(0), 0, 0);
		}
	} 

	/** シーン５ 製作著作 */
	void onMoveScene5(Screen screen) {
		m_scene5Alpha.inc();
	}
	void onDrawScene5(Screen screen) {
		screen.setColor(255,255,255,m_scene5Alpha.get());
		screen.bltRotate(textureLoader.get(8), 320, 240, 0, 1.0, 4);
	}
	
	CutDraw currentCutDraw;
	
	
	// タイム表示を行う
	bool m_showTime = true;
	// ムービー表示を行う
	bool m_showMovie = true;
	// 標的位置の表示
	bool m_showAimingMark = false;
	// 自動プレイ
	bool m_autoPlay = false;
	
	CutDraw scene2_1;
	CutDraw scene2_2;
	CutDraw scene3_1;
	CutDraw scene3_2;
	CutDraw scene3_3;
	CutDraw scene3_4;
	CutDraw scene4_1;
	CutDraw scene4_2;
	
	RootCounterS m_scene5Alpha;
	
	int m_rankId = 0;
	int m_screenAlpha = 192;
	
	bool startScene1 = true;	// 去人たち１
	bool startScene2_1;	// 去人たち特別篇
	bool startScene2_2;	// 去人たち特別篇
	bool startScene3_1;	// 去人たちZERO
	bool startScene3_2;	// 去人たちZERO
	bool startScene3_3;	// 去人たちZERO
	bool startScene3_4;	// 去人たちZERO
	bool startScene4_1;	// 去人たち last world
	bool startScene4_2;	// 去人たち last world
	bool startScene5;	// 著作・製作
}
