﻿module ytl.exception;
private import ytl.y4d_result;

///	例外発生時に使用するクラス。
/**
<PRE>
	エラーの時に投げる例外
	例)
		throw new y4d_error(this,"エラーだぴょん");

	エラーメッセージは、char[](UTF-8)で書かれているので
	それを表示するなら、toMBSzを通す必要がある。

	例)
	try {
		spchara.load("data/ars.txt");	//	スプライト定義ファイルの読み込み
	} catch (Error e) {
		printf(toMBSz((wchar[])"例外が発生 : %.*s"),toMBS(e.msg));
	//	printf(toMBSz(e.msg));
	}

</PRE>
*/
class y4d_error : Error
{
	///	メッセージを設定する例外タイプ
	this(char[] msg) {
		super(msg);
	}

	///	例外の発生したオブジェクトとメッセージを添えるタイプ
	this(Object o, char[] msg) {
		super(o.classinfo.name ~ ": " ~ msg);
	}

	///	y4d_resultをそのままエラーメッセージとするタイプ
	this(y4d_result msg){
		super(ytl.y4d_result.getErrorName(msg));
	}

	///	例外の発生したオブジェクトとy4d_resultをそのままエラーメッセージとするタイプ
	this(Object o,y4d_result msg){
		super(o.classinfo.name ~ ": " ~ ytl.y4d_result.getErrorName(msg));
	}
}

