﻿module ytl.y4d_result;

///	ライブラリ全体で用いる、エラーを表す列挙体
enum y4d_result {
	no_error=0,			//	エラーなし
	not_implemented,	//	未実装
	should_be_quit, 	//	quitすべき
	precondition_error,	//	完了できない(前提条件が守られていないため)
	already_done,		//	すでに完了している
	happen_some_error,	//	何らかのエラーが発生した
	file_not_found,		//	ファイルが見つからない
	file_read_error,	//	ファイルの読み込み、解読上のエラー
	file_write_error,	//	ファイルが書き込めない
	invalid_parameter,	//	パラメータが不正
	win32api_error,		//	Win32のAPI関連のエラー
	SDL_error,			//	SDL関連のエラー
	//例)return SDLsomefunc() ? y4d_result.SDL_error:y4d_result.no_error;
	zlib_error,			//	zlib上のエラー
}

///	エラーメッセージを文字列で取得します。
char[] getErrorName(y4d_result e) {
	switch (e){
	case y4d_result.no_error : return cast(char[]) "no_error";
	case y4d_result.not_implemented : return cast(char[]) "not_implemented";
	case y4d_result.should_be_quit : return cast(char[]) "should_be_quit";
	case y4d_result.precondition_error : return cast(char[]) "precondition_error";
	case y4d_result.already_done : return cast(char[]) "already_done";
	case y4d_result.happen_some_error : return cast(char[]) "happen_some_error";
	case y4d_result.file_not_found :return cast(char[]) "file_not_found";
	case y4d_result.file_read_error : return cast(char[]) "file_read_error";
	case y4d_result.file_write_error : return cast(char[]) "file_write_error";
	case y4d_result.invalid_parameter :return cast(char[]) "invalid_parameter";
	case y4d_result.win32api_error : return cast(char[]) "win32api_error";
	case y4d_result.SDL_error : return cast(char[]) "SDL_error";
	case y4d_result.zlib_error : return cast(char[]) "zlib_error";
	default : return cast(char[]) "undefined error";
	}
	assert(0);
}

