//
//  LFApp.m
//  LetterFix2
//
//  Created by kuri on 10/02/26.
//  Copyright 2010-2011 kuri. All rights reserved.
//

#import "LFApp.h"

@implementation LFApp

- (id) init
{
    self = [super init];
    
    if (self != nil) {
	userDefaults = [NSUserDefaults standardUserDefaults];
	
	infodict     = [[NSBundle mainBundle] infoDictionary];
	mailversion  = [infodict objectForKey:@"CFBundleVersion"];
	lastknow     = [userDefaults stringForKey:@"LetterFixLastKnownBundleVersion"];
	
	if (lastknow && [mailversion compare:lastknow] != NSOrderedSame) {
	    NSAlert *alert = [[NSAlert alloc] init];
	    [alert setMessageText:@"LetterFix plug-in"];
	    [alert setInformativeText:@"Mail.app が変更されました。\n"
	     @"Mail.app のアップデート等により，プラグインの動作に問題が発生する場合は，アンインストールしてください。\n"
	     @"このプラグインは通常 ~/Library/Mail/Bundles/ にインストールされています。"];
	    [alert setAlertStyle:NSInformationalAlertStyle];
	    [alert runModal];
	    [alert release];
	}
	
        SInt32 systemVersion;
        if (Gestalt(gestaltSystemVersion, &systemVersion) == noErr) {
            if ((systemVersion & 0xfff0) == 0x1050) {
                ver = LF_Leopard;
            } else if ((systemVersion & 0xfff0) == 0x1060) {
                ver = LF_SnowLeopard;
            } else if ((systemVersion & 0xfff0) == 0x1070) {
                ver = LF_Lion;
            } else if ((systemVersion & 0xfff0) == 0x1080) {
                ver = LF_MountainLion;
            } else {
                ver = LF_Unknown;
            }
        } else {
            ver = LF_Unknown;
        }

	[userDefaults setObject:mailversion forKey:@"LetterFixLastKnownBundleVersion"];
	
	[self setIsActive:![userDefaults boolForKey:@"LetterFixDisabled"]];
	[self setIsOsDependentFix:![userDefaults boolForKey:@"LetterFixOsDependentFixDisabled"]];
        [self setParenSymbolFix:![userDefaults boolForKey:@"LetterFixParenSymbolFixDisabled"]];
        [self setSomeParenSymbolNotFix:[userDefaults boolForKey:@"LetterFixSomeParenSymbolFixEnabled"]];
	[self setIsAllLetterFix:![userDefaults boolForKey:@"LetterFixAllLetterFixDisabled"]];
	[self setChangeEncode:![userDefaults boolForKey:@"LetterFixChangeEncodeDisabled"]];
	[self setOperationAtOpen:[userDefaults integerForKey:@"LetterFixOperationAtOpen"]];
	[self setIsCheckSubject:![userDefaults integerForKey:@"LetterFixCheckSubjectDisabled"]];
	menu = [[LFMenu alloc] initWithApp:self];
	[menu inject];
	
	if (![[NSLocale preferredLanguages] containsObject:@"ja"]) {
	    NSAlert *alert = [[NSAlert alloc] init];
	    [alert setMessageText:@"LetterFix plug-in"];
	    [alert setInformativeText:@"システム環境設定＞言語とテキスト(Language & Text)内の言語リストに"
	     @"「日本語」が存在しません。そのため Letter-fix は動作せず、すべての日本語メールはUTF-8で送信されます。"
	     @"言語リストに日本語を加えてください。なお順序は問いません。"];
	    [alert setAlertStyle:NSInformationalAlertStyle];
	    [alert runModal];
	    [alert release];
	    isActive = FALSE;
	    [[menu onoffMenuItem] setState:FALSE];
	}
    }
    return self;
}

- (BOOL) isActive
{
    return isActive;
}

- (void) setIsActive:(BOOL)active
{
    [userDefaults setBool:!active forKey:@"LetterFixDisabled"];
    isActive = active;
}

- (BOOL) isOsDependentFix
{
    return isOsDependentFix;
}

- (void) setIsOsDependentFix:(BOOL)active
{
    [userDefaults setBool:!active forKey:@"LetterFixOsDependentFixDisabled"];
    isOsDependentFix = active;
}

- (BOOL) parenSymbolFix
{
    return parenSymbolFix;
}

- (void) setParenSymbolFix:(BOOL)active
{
    [userDefaults setBool:!active forKey:@"LetterFixParenSymbolFixDisabled"];
    parenSymbolFix = active;
}

- (BOOL) someParenSymbolNotFix
{
    return someParenSymbolNotFix;
}

- (void) setSomeParenSymbolNotFix:(BOOL)active
{
    [userDefaults setBool:active forKey:@"LetterFixSomeParenSymbolFixEnabled"];
    someParenSymbolNotFix = active;
}

- (BOOL) isAllLetterFix
{
    return isAllLetterFix;
}

- (void) setIsAllLetterFix:(BOOL)active
{
    [userDefaults setBool:!active forKey:@"LetterFixAllLetterFixDisabled"];
    isAllLetterFix = active;
}

- (BOOL) changeEncode
{
    return changeEncode;
}

- (void) setChangeEncode:(BOOL)active
{
    [userDefaults setBool:!active forKey:@"LetterFixChangeEncodeDisabled"];
    changeEncode = active;
}

- (int) operationAtOpen
{
    return operationAtOpen;
}

- (void) setOperationAtOpen:(int)value
{
    [userDefaults setInteger:value forKey:@"LetterFixOperationAtOpen"];
    operationAtOpen = value;
}

- (BOOL) isCheckSubject
{
    return isCheckSubject;
}

- (void) setIsCheckSubject:(BOOL)active
{
    [userDefaults setBool:!active forKey:@"LetterFixCheckSubjectDisabled"];
    isCheckSubject = active;
}

@synthesize ver;

@end
