#include "GtkThumbView.h"

using namespace std;

static gboolean gtv_on_expose_event(GtkWidget      *widget,
				    GdkEventExpose *event,
				    gpointer        data){
  GtkThumbView *gtv=((GtkThumbView *)data);
  gdk_draw_pixmap (widget->window,
		   widget->style->black_gc,
		   gtv->getPixmap(),
		   0,0,0,0,gtv->getPixWidth(),gtv->getPixHeight());

  // draw cursor
  int selected=gtv->getSelected();
  if(selected>=0){
    int dwidth=gtv->getPixWidth();
    int thumbwidth=gtv->getThumbWidth();
    int thumbheight=gtv->getThumbHeight();
    
    int xw=selected*thumbwidth;
    int x0=xw%dwidth;
    int y0=(xw/dwidth)*thumbheight;

    gdk_draw_rectangle(widget->window,gtv->getGC(),FALSE,x0,y0,thumbwidth,thumbheight);
  }

  return TRUE;
}

GtkThumbView::GtkThumbView(){
  window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window),"Markers");

  drawingarea = gtk_drawing_area_new ();
  gtk_container_add (GTK_CONTAINER (window), drawingarea);

  g_signal_connect (G_OBJECT (drawingarea), "expose_event",
		    G_CALLBACK (gtv_on_expose_event), this);

  g_signal_connect ((gpointer) window, "delete_event",
                    G_CALLBACK (do_not_destroy_window),
                    NULL);

  setThumbSize(80,80,6,6);
  selected=-1;
  gc=NULL;
}

GtkThumbView::~GtkThumbView(){
  clearImageList();
}

void GtkThumbView::show(){
  gtk_widget_show_all (window);
}

void GtkThumbView::setThumbSize(int thumbw,int thumbh,int tablew,int tableh){
  thumbwidth=thumbw;
  thumbheight=thumbh;
  tablewidth=tablew;
  tableheight=tableh;
  gtk_widget_set_size_request (drawingarea,thumbwidth*tablewidth,thumbheight*tableheight);
  pixmap=gdk_pixmap_new(NULL,thumbwidth*tablewidth,thumbheight*tableheight,24);
}



void GtkThumbView::copyImageList(SURFConverter *surf){
  vector <IplImage *> &ilist=surf->getRefImageList();
  imagelist.assign(ilist.begin(),ilist.end());
}

void GtkThumbView::clearImageList(){
  // don't clear when copied!
  for(int i=0;i<imagelist.size();i++)
    cvReleaseImage(&imagelist[i]);
  imagelist.clear();
}
void GtkThumbView::pushImageList(IplImage *img){
  IplImage *nimg;
  int width=img->width,height=img->height;
  nimg=cvCreateImage(cvSize(width,height),IPL_DEPTH_8U,3);
  
  switch(img->nChannels){
  case 1:
    cvCvtColor(img,nimg,CV_GRAY2BGR);
    break;
  case 3:
    cvCopy(img,nimg);
    break;
  default:
    cout << "image channel missmatch." << endl;
  }

  imagelist.push_back(nimg);
}

void GtkThumbView::createThumb(){
  int nimage=imagelist.size();
  int ntable=tablewidth*tableheight;
  int dwidth=thumbwidth*tablewidth;

  int xw,x0,y0,x1,y1;

  float iwidth,iheight,iiwidth,iiheight;
  int nwidth,nheight;

  vector <unsigned char> buf;
  unsigned char *ibuf;
  int idx,xidx0,xidx1,tidx;
  int ws;

  for(int i=0;i<((nimage>=ntable)?ntable:nimage);i++){
    xw=i*thumbwidth;
    x0=xw%dwidth;
    y0=(xw/dwidth)*thumbheight;

    iwidth=imagelist[i]->width;
    iheight=imagelist[i]->height;

    iiheight=iheight*((float)thumbwidth)/iwidth;
    iiwidth=iwidth*((float)thumbheight)/iheight;

    if(thumbwidth>=iiwidth){
      nwidth=(int)iiwidth;
      nheight=thumbheight;
      x1=(thumbwidth-nwidth)/2;
      y1=0;
    }else{
      nwidth=thumbwidth;
      nheight=(int)iiheight;
      x1=0;
      y1=(thumbheight-nheight)/2;
    }

    IplImage *nimg;
    nimg=cvCreateImage(cvSize(nwidth,nheight),IPL_DEPTH_8U,3);
    cvResize(imagelist[i],nimg);

    // convert BGR to RGB
    buf.resize(nwidth*nheight*3);
    ibuf=(unsigned char *)nimg->imageData;
    ws=nimg->widthStep;
    for(int j=0;j<nheight;j++){
      xidx0=j*ws;
      xidx1=j*nwidth;
      for(int k=0;k<nwidth;k++){
	idx=xidx0+k*3;
	tidx=(xidx1+k)*3;
	buf[tidx]=ibuf[idx+2];
	buf[tidx+1]=ibuf[idx+1];
	buf[tidx+2]=ibuf[idx];
      }
    }
    gdk_draw_rgb_image(pixmap,
		       drawingarea->style->black_gc,
		       x0+x1,y0+y1,
		       nwidth,nheight,
		       GDK_RGB_DITHER_NONE,
		       &buf[0],
		       nwidth*3);

    cvReleaseImage(&nimg);
  }

}

GdkGC *GtkThumbView::getGC(){
  if(gc==NULL){
    GdkColor gcolor;
    gc=gdk_gc_new(drawingarea->window);
    gdk_gc_set_line_attributes(gc,3,GDK_LINE_SOLID,GDK_CAP_NOT_LAST,GDK_JOIN_MITER);
    gdk_colormap_alloc_color (gdk_colormap_get_system () , &gcolor, TRUE, TRUE);
    gcolor.red=0x0000;
    gcolor.green=0xffff;
    gcolor.blue=0x0000;
    gdk_color_alloc (gdk_colormap_get_system () , &gcolor);
    gdk_gc_set_foreground (gc , &gcolor);
  }
  return gc;
}
