#ifndef __GTKTHUMBVIEW_H__
#define __GTKTHUMBVIEW_H__

#include "GtkCtrl.h"
#include "SURFConverter.h"

#include <cv.h>
#include <cvaux.h>
#include <cxcore.h>
#include <highgui.h>

using namespace std;

static gboolean gtv_on_expose_event(GtkWidget      *widget,
				    GdkEventExpose *event,
				    gpointer        data);

class GtkThumbView{
 private:
  GtkWidget *window;
  GtkWidget *drawingarea;
  GdkPixmap *pixmap;
  GdkGC *gc;

  vector <IplImage *> imagelist;
  
  int thumbwidth,thumbheight;
  int tablewidth,tableheight;
  int selected;

 public:
  GtkThumbView();
  ~GtkThumbView();
  void show();
  void setThumbSize(int thumbw,int thumbh,int tablew,int tableh);
  int getThumbWidth(){return thumbwidth;}
  int getThumbHeight(){return thumbheight;}
  int getTableWidth(){return tablewidth;}
  int getTableHeight(){return tableheight;}
  
  void copyImageList(SURFConverter *surf);
  void clearImageList();
  void pushImageList(IplImage *img);
  void createThumb();

  GdkPixmap *getPixmap(){return pixmap;}
  int getPixWidth(){return thumbwidth*tablewidth;}
  int getPixHeight(){return thumbheight*tableheight;}

  void selectImage(int idx){selected=idx;}
  int getSelected(){return selected;}

  GdkGC *getGC();

  void redraw(){
    //gtk_widget_queue_draw(drawingarea);
    gdk_window_invalidate_rect (drawingarea->window, &drawingarea->allocation, FALSE);
    gdk_window_process_updates (drawingarea->window, FALSE);
  }
};



#endif
