
#include "HYPsf.h"

HYPsf::HYPsf(int np,float rr,
	     float zc,float zr,
	     float rxc,float rxr,
	     float ryc,float ryr,
	     float mn)
  : HYParticleFilter(3,np,rr){
  zcenter=zc;
  zrange=zr;
  rxcenter=rxc;
  rxrange=rxr;
  rycenter=ryc;
  ryrange=ryr;
  mnoise=mn;

  npoints_max=1000;
  points=new float[npoints_max*3];

  plane_normal=new float[3];
}

HYPsf::~HYPsf(){
  delete[] points;
  delete[] plane_normal;
}

void HYPsf::predict(){
  int i;
  float s;
  for(i=0;i<dstate*nparticles;i++){
    s=stateTable[i];
    if(s>0.5){
      stateTable[i]=0.5;
    }else if(s<-0.5){
      stateTable[i]=-0.5;
    }
  }
}

float HYPsf::likelihood(float *state){
  float val=0.0;
  float dist;
  int i,pidx;

  stateToPlane(state);

  for(i=0;i<npoints;i++){
    pidx=i*dstate;
    dist=((points[pidx]*plane_normal[0]
	   +points[pidx+1]*plane_normal[1]
	   +points[pidx+2]*plane_normal[2])
	  +plane_d)/plane_normal_norm;
    val+=exp((dist*dist)*mnoise);
  }

  return val;
}

void HYPsf::stateToPlane(float *state){
  float zz,rx,ry;
  float crx,cry;

  zz=state[0]*zrange+zcenter;
  rx=state[1]*rxrange+rxcenter;
  ry=state[2]*ryrange+rycenter;

  //cry=cos(ry);
  crx=cos(rx);

  //plane_normal[0]=sin(ry);
  //plane_normal[1]=-cry*sin(rx);
  //plane_normal[2]=cos(rx)*cry;
  plane_normal[0]=crx*sin(ry);
  plane_normal[1]=-sin(rx);
  plane_normal[2]=crx*cos(ry);

  plane_d=-zz*plane_normal[2];

  plane_normal_norm=sqrt(plane_normal[0]*plane_normal[0]
			 +plane_normal[1]*plane_normal[1]
			 +plane_normal[2]*plane_normal[2]);

}

void HYPsf::setPoints(float *pts,int num){
  npoints=num;
  if(npoints_max<npoints){
    delete[] points;
    npoints_max=npoints;
    points=new float[npoints_max*3];
  }
  memcpy(points,pts,sizeof(float)*npoints*3);
}

void HYPsf::stateToParam(float *state,float *param){
  param[0]=state[0]*zrange+zcenter;
  param[1]=state[1]*rxrange+rxcenter;
  param[2]=state[2]*ryrange+rycenter;
}
