#ifndef __HYPSF_H__
#define __HYPSF_H__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <math.h>

#include "HYParticleFilter.h"

class HYPsf : public HYParticleFilter{
 private:
  float zcenter,zrange,rxcenter,rxrange,rycenter,ryrange;
  float *points;
  float mnoise;
  int npoints,npoints_max;

  float *plane_normal;
  float plane_d,plane_normal_norm;

 public:
  HYPsf(int np,float rr,float zc,float zr,float rxc,float rxr,float ryc,float ryr,float mn);
  ~HYPsf();

  void predict();
  float likelihood(float *state);
  void stateToPlane(float *state);
  void setPoints(float *pts,int num);
  void setMeasurementNoise(float mn){mnoise=mn;}

  void stateToParam(float *state,float *param);

  void setZCenter(float zc){zcenter=zc;}
  void setZRange(float zr){zrange=zr;}
  void setRXCenter(float rxc){rxcenter=rxc;}
  void setRXRange(float rxr){rxrange=rxr;}
  void setRYCenter(float ryc){rycenter=ryc;}
  void setRYRange(float ryr){ryrange=ryr;}

};


#endif
