#ifndef __IKFILTER_H__
#define __IKFILTER_H__

#include <stdio.h>
#include <stdlib.h>

#include <iostream>
#include <vector>
#include <string>

#include <cv.h>
#include <cvaux.h>
#include <cxcore.h>

#include "GLObject.h"
#include "HYParticleFilter.h"

using namespace std;

class IKFilter : public HYParticleFilter{
 private:
  GLPMDObject *glpmd;
  int ik_bone,ik_target_bone;
  float ik_weight;
  int nc;
  vector<int> ik_children;
  vector<float> ref_quats;
  vector<float> cur_quats;

  // for iterative algorythm
  float *cur_angles;
  float *jacobian;
  float *inverse_jacobian;
  float *diff_vector;
  float *step_vector;
  float *dangles;

  CvMat *cv_jacobian,*cv_inverse_jacobian,*cv_dangles,*cv_step_vector;

  float mnoise;

  float stepr,stept;

 public:
  IKFilter(GLPMDObject *pmd,int nchildren,int np,int rr,
	   int bone,int target,float weight,vector<int> &children,
	   ostream &os=cout);
  ~IKFilter();

  void initQuaternion();
  void initStep();

  void predict(){}
  float likelihood(float *state);
  void stateToPose(float *state);

  void calcWorldTransformation(float *angles,float *result);
  void calcJacobian();
  void stepIter();
  void iterativeIK();
};



class IKManager{
 private:
  int nik;
  IKFilter **ikfilters;
  GLPMDObject *glpmd;
  //vector<char> ikvalid;
  vector<int> ikbones;
  //vector<string> ikbonename;
  int np,iter;

 public:
  IKManager(GLPMDObject *pmd,ostream &os=cout);
  IKManager(GLPMDObject *pmd,int ik_np,int ik_iter,ostream &os=cout);
  ~IKManager();

  void init(GLPMDObject *pmd,int ik_np,int ik_iter,ostream &os=cout);
  void reset();

  void calcIK(GLPMDObject *pmd);
  void calcIterativeIK(GLPMDObject *pmd);
};



#endif
