#include "ImageManager.h"

HYImage::HYImage(){
  createBuffer(640,480,3);
}

HYImage::HYImage(int ww,int hh){
  createBuffer(ww,hh,3);
}

HYImage::HYImage(int ww,int hh,unsigned char dd){
  createBuffer(ww,hh,dd);
}

void HYImage::createBuffer(int ww,int hh,unsigned char dd){
  width=ww;
  height=hh;
  depth=dd;
  buf=new unsigned char[width*height*depth];
}

void HYImage::setBufferBGR(unsigned char *src){
  if(depth==3){
    for(int i=0;i<width*height;i++){
      buf[i*3]=src[i*3+2];
      buf[i*3+1]=src[i*3+1];
      buf[i*3+2]=src[i*3];
    }
  }
}
void HYImage::copyBufferBGR(unsigned char *dst){
  if(depth==3){
    for(int i=0;i<width*height;i++){
      dst[i*3]=buf[i*3+2];
      dst[i*3+1]=buf[i*3+1];
      dst[i*3+2]=buf[i*3];
    }
  }
}

HYImage::~HYImage(){
  delete buf;
}


HYImage *createImageFromFile(string fname){
  IplImage *iplimg;
  HYImage *hyimg;

  iplimg=cvLoadImage(fname.c_str(),CV_LOAD_IMAGE_COLOR);
  if(iplimg==NULL){
    fprintf(stderr,"image file not found.\n");
    return NULL;
  }
  hyimg=createImageFromIplImage(iplimg);
  cvReleaseImage(&iplimg);

  return hyimg;
}
HYImage *createImageFromIplImage(IplImage *iplimg){
  HYImage *hyimg;
  hyimg=new HYImage(iplimg->width,iplimg->height);
  //hyimg->setBuffer((unsigned char *)(iplimg->imageData));
  hyimg->setBufferBGR((unsigned char *)(iplimg->imageData));
  return hyimg;
}
IplImage *createIplImageFromImage(HYImage *hyimg){
  IplImage *iplimg;
  iplimg=cvCreateImage(cvSize(hyimg->getWidth(),hyimg->getHeight()),IPL_DEPTH_8U,3);
  //hyimg->copyBuffer((unsigned char *)(iplimg->imageData));
  hyimg->copyBufferBGR((unsigned char *)(iplimg->imageData));
  return iplimg;
}

HYImage *createImageFromFileWithAlpha(string fname){
  IplImage *iplimg;
  HYImage *hyimg;

  iplimg=cvLoadImage(fname.c_str(),CV_LOAD_IMAGE_ANYDEPTH | CV_LOAD_IMAGE_ANYCOLOR);
  if(iplimg==NULL){
    fprintf(stderr,"image file not found.\n");
    return NULL;
  }
  hyimg=new HYImage(iplimg->width,iplimg->height,4);
  hyimg->setBuffer((unsigned char *)(iplimg->imageData));
  cvReleaseImage(&iplimg);

  return hyimg;
}

HYImage *convertImageAlphaByColor(HYImage *src,float rr,float gg,float bb){
  if(src->getDepth()!=3) return NULL;

  int ww=src->getWidth();
  int hh=src->getHeight();
  int idx;

  unsigned char r,g,b;
  int a;

  HYImage *hyimg;
  hyimg=new HYImage(ww,hh,4);

  unsigned char *srcbuf=src->getBuffer();
  unsigned char *dstbuf=hyimg->getBuffer();

  for(int i=0;i<ww*hh;i++){
    r=srcbuf[i*3];
    g=srcbuf[i*3+1];
    b=srcbuf[i*3+2];

    a=(int)((r*rr+g*gg+b*bb)/3.0);
    a=a>255?255:a;
    a=a<0?0:a;

    dstbuf[i*4]=r;
    dstbuf[i*4+1]=g;
    dstbuf[i*4+2]=b;
    dstbuf[i*4+3]=(unsigned char)a;
  }

  return hyimg;
}
