#include "LSHTable.h"

using namespace std;

LSHTable::LSHTable(unsigned int vdim,unsigned int udim){
  vectordim=vdim;
  usedim=udim;
  pointtable.resize(1<<usedim);
  indextable.resize(1<<usedim);
  vmean.resize(vectordim);
}
LSHTable::~LSHTable(){

}

void LSHTable::setMean(CvMat *vector_list){
  int vnum=vector_list->rows;
  float ratio=1.0/(float)vnum;
  float *vcol;

  for(int i=0;i<vectordim;i++) vmean[i]=0.0;


  // calc mean
  for(int i=0;i<vnum;i++){
    vcol=(float *)(vector_list->data.ptr+vector_list->step*i);
    for(int j=0;j<vectordim;j++){
      vmean[j]+=vcol[j]*ratio;
    }
  }

  // debug: print distribution
  float rmax=0.0,rmin=100.0,rmean=0.0,rr;
  float dmax=0.0,dmin=100.0,dmean=0.0,dratio=1.0/(float)(vnum*vectordim);
  float dd;

  for(int i=0;i<vnum;i++){
    vcol=(float *)(vector_list->data.ptr+vector_list->step*i);
    rr=0;
    for(int j=0;j<vectordim;j++){
      dd=vcol[j]-vmean[j];
      rr+=(dd*dd);
      dmean+=fabs(dd)*dratio;
      if(dmax<fabs(dd)) dmax=fabs(dd);
      if(dmin>fabs(dd)) dmin=fabs(dd);
    }
    rr=sqrt(rr);
    rmean+=rr*ratio;
    if(rmax<rr) rmax=rr;
    if(rmin>rr) rmin=rr;
  }
  cout << "distribution:" << endl;
  cout << "  rmax : " << rmax << endl;
  cout << "  rmin : " << rmin << endl;
  cout << "  rmean: " << rmean << endl;
  cout << "  dmax : " << dmax << endl;
  cout << "  dmin : " << dmin << endl;
  cout << "  dmean: " << dmean << endl;

  thresh=(rmax-rmin)*1.2;
  thresh*=thresh;
}

unsigned int LSHTable::hash(const float *vec){
  unsigned int ret=0;
  for(int i=0;i<usedim;i++){
    if(vec[i]>vmean[i]) ret+=(1<<i);
  }
  return ret;
}

void LSHTable::hash2(const float *vec,vector<unsigned int> &hlist){
  int i,j;
  float dd;

  hlist.clear();
  hlist.push_back(0);
  
  for(i=0;i<usedim;i++){
    dd=vec[i]-vmean[i];
    if(dd>0){
      for(j=0;j<hlist.size();j++){
	hlist[j]+=(1<<i);
      }
      if(hlist.size()<16 && dd<0.01){
	hlist.push_back(hlist[0]-(1<<i));
      }
    }else /*if(dd<=0))*/{
      //nop
      if(hlist.size()<16 && dd>-(0.01)){
	hlist.push_back(hlist[0]+(1<<i));
      }
    }
  }
}

void LSHTable::createHashTable(CvMat *vector_list,vector<int> &index_list){
  int vnum=vector_list->rows;
  unsigned int hidx;
  int j;
  float *vcol;

  cout << "num of vectors: " << vnum << endl;

  for(int i=0;i<pointtable.size();i++){
    pointtable[i].clear();
    indextable[i].clear();
  }

  setMean(vector_list);

  for(int i=0;i<vnum;i++){
    vcol=(float *)(vector_list->data.ptr+vector_list->step*i);
    hidx=hash(vcol);
    for(j=0;j<vectordim;j++)
      pointtable[hidx].push_back(vcol[j]);
    indextable[hidx].push_back(index_list[i]);
  }

  // debug
  unsigned int vvnum=0;
  cout << "table distribution: " << endl;
  for(int i=0;i<pointtable.size();i++){
    if(pointtable[i].size()/vectordim!=0){
      vvnum+=(pointtable[i].size()/vectordim);
      //cout << pointtable[i].size()/vectordim << "/" << i << endl;
    }
  }
  cout << " total: " << vvnum << endl;
  cout << endl;
}

int LSHTable::searchFromHashTable(float *vec,float *result){
  unsigned int hidx;
  //hidx=hash(vec);

  vector<unsigned int> hidxlist;
  hash2(vec,hidxlist);

  int midx=-1;
  float mindist=1000.0,mindist2=1000.0;
  float dist;
  float dd;

  int i,j,k;

  int s0,s1;

  //cout << "pointtable.size():" << pointtable.size() << endl;

  s0=hidxlist.size();
  //s0=pointtable.size();
  for(k=0;k<s0;k++){
    hidx=hidxlist[k];
    //hidx=(unsigned int)k;
    //cout << "hidx:" << hidx << endl;
    s1=(pointtable[hidx]).size();
    for(i=0;i<s1;i+=vectordim){
      dist=0;
      for(j=0;j<vectordim;j++){
	dd=pointtable[hidx][i+j]-vec[j];
	dist+=(dd*dd);
      }
      if(mindist>dist){
	mindist2=mindist;
	mindist=dist;
	midx=indextable[hidx][i/vectordim];
	//memcpy(result,&pointtable[hidx][i],sizeof(float)*vectordim);
      }else if(mindist2>dist) mindist2=dist;
    }
  }

  //if(mindist < (mindist2*0.6)) return midx;
  if(mindist < thresh) return midx;
  else return -1;
}
