#ifndef __LSHTABLE_H__
#define __LSHTABLE_H__

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <vector>

#include <math.h>

#include "cv.h"
#include "cvaux.h"
#include "cxcore.h"
#include "highgui.h"

using namespace std;


class LSHTable{
 private:
  vector < vector < float > > pointtable;
  vector < vector < int > > indextable;
  vector<float> vmean;

  unsigned int vectordim,usedim;
  float thresh;

 public:
  LSHTable(unsigned int vdim,unsigned int udim);
  ~LSHTable();
  void setMean(CvMat *vector_list);
  unsigned int hash(const float *vec);
  void hash2(const float *vec,vector<unsigned int> &hlist);

  void createHashTable(CvMat *vector_list,vector<int> &index_list);
  int searchFromHashTable(float *vec,float *result);
  

};



#endif
