#include "MarkerGeneration.h"


void generateRandomIndexList(int num,int range,int *ilist){
  int i=0,j;
  int idx;
  bool match;

  if(num>range) return;

  while(i<num){
    match=false;
    idx = (int)((rand() / ((double)RAND_MAX+1.0f)) * range);
    for(j=0;j<i;j++)
      if(ilist[j]==idx)
	match=true;
    if(!match){
      ilist[i]=idx;
      i++;
    }
  }
}

float distanceLineVertices(float *verts){
  float p0x,p0y,p1x,p1y,v0x,v0y,v1x,v1y;
  float p10x,p10y;
  float norm2v0,norm2v1,ipv0v1,ippv0,ippv1;
  float denomi,ss,tt,ppx,ppy,qqx,qqy;
  float pqx,pqy,dist=-1.0;

  p0x=verts[0];
  p0y=verts[1];
  v0x=verts[2]-verts[0];
  v0y=verts[3]-verts[1];
  p1x=verts[4];
  p1y=verts[5];
  v1x=verts[6]-verts[4];
  v1y=verts[7]-verts[5];

  p10x=p1x-p0x;
  p10y=p1y-p0y;

  norm2v0=v0x*v0x+v0y*v0y;
  norm2v1=v1x*v1x+v1y*v1y;

  ipv0v1=v0x*v1x+v0y*v1y;
  ippv0=v0x*p10x+v0y*p10y;
  ippv1=v1x*p10x+v1y*p10y;

  /*
  denomi=norm2v0*norm2v1-ipv0v1*ipv0v1;

  if(fabs(denomi)<1e-5){
    ss=(p10x*v0x+p10y*v0y)/norm2v0;
    ppx=p1x;
    ppy=p1y;
    qqx=p0x+ss*v0x;
    qqy=p0y+ss*v0y;
  }else{
    ss=(norm2v1*ippv0-ipv0v1*ippv1)/denomi;
    tt=(ipv0v1*ippv0-norm2v0*ippv1)/denomi;
    ppx=p1x+tt*v1x;
    ppy=p1y+tt*v1y;
    qqx=p0x+ss*v0x;
    qqy=p0y+ss*v0y;
  }
  */

  ss=(p10x*v0x+p10y*v0y)/norm2v0;
  ppx=p1x;
  ppy=p1y;
  qqx=p0x+ss*v0x;
  qqy=p0y+ss*v0y;


  pqx=ppx-qqx;
  pqy=ppy-qqy;
  dist=sqrt(pqx*pqx+pqy*pqy);
  return dist;
}


bool crossPointLineVertices(float *verts,float *crossp){
  float p0x,p0y,p1x,p1y,v0x,v0y,v1x,v1y;
  float p10x,p10y;
  float norm2v0,norm2v1,ipv0v1,ippv0,ippv1;
  float denomi,ss,tt,ppx,ppy,qqx,qqy;

  p0x=verts[0];
  p0y=verts[1];
  v0x=verts[2]-verts[0];
  v0y=verts[3]-verts[1];
  p1x=verts[4];
  p1y=verts[5];
  v1x=verts[6]-verts[4];
  v1y=verts[7]-verts[5];

  p10x=p1x-p0x;
  p10y=p1y-p0y;

  norm2v0=v0x*v0x+v0y*v0y;
  norm2v1=v1x*v1x+v1y*v1y;

  ipv0v1=v0x*v1x+v0y*v1y;
  ippv0=v0x*p10x+v0y*p10y;
  ippv1=v1x*p10x+v1y*p10y;

  denomi=norm2v0*norm2v1-ipv0v1*ipv0v1;

  if(denomi<1e-5) return false;

  //ss=(norm2v1*ippv0-ipv0v1*ippv1)/denomi;
  tt=(ipv0v1*ippv0-norm2v0*ippv1)/denomi;
  ppx=p1x+tt*v1x;
  ppy=p1y+tt*v1y;
  //qqx=p0x+ss*v0x;
  //qqy=p0y+ss*v0y;

  crossp[0]=ppx;
  crossp[1]=ppy;

  return true;
}

////////////////////////////////////////////

RectangleFilter::RectangleFilter(int np,float rr,float mn,float *cxy,float rx,float ry)
  : HYParticleFilter(8,np,rr){
  cxylist=new float[8];
  rangex=rx;
  rangey=ry;
  mnoise=mn;
  vertices=new float[8];

  memcpy(cxylist,cxy,8*sizeof(float));
}

RectangleFilter::~RectangleFilter(){
  delete[] cxylist;
  delete[] vertices;
}

float RectangleFilter::likelihood(float *state){
  float val=0.0;
  stateToVertices(state,vertices);
  float v_x0,v_y0,v_x1,v_y1,v_x10,v_y10,v_normxy10,v_nx10,v_ny10;
  float l_x0,l_y0,l_x1,l_y1,l_x10,l_y10,l_normxy10,l_nx10,l_ny10;
  int idx0,idx1;

  float dx0,dx1,dy0,dy1;
  float dist0,dist1,mindist0,mindist1;

  // edge matching
  for(int i=0;i<4;i++){
    idx0=i*2;
    idx1=((i+1)%4)*2;
    v_x0=vertices[idx0];
    v_y0=vertices[idx0+1];
    v_x1=vertices[idx1];
    v_y1=vertices[idx1+1];

    v_x10=v_x1-v_x0;
    v_y10=v_y1-v_y0;

    v_normxy10=sqrt(v_x10*v_x10+v_y10*v_y10);
    v_nx10=v_x10/v_normxy10;
    v_ny10=v_y10/v_normxy10;

    mindist0=mindist1=1000.0;

    for(int j=0;j<lines.size();j+=4){
      l_x0=lines[j];
      l_y0=lines[j+1];
      l_x1=lines[j+2];
      l_y1=lines[j+3];

      l_x10=l_x1-l_x0;
      l_y10=l_y1-l_y0;

      l_normxy10=sqrt(l_x10*l_x10+l_y10*l_y10);
      l_nx10=l_x10/l_normxy10;
      l_ny10=l_y10/l_normxy10;

      if(fabs(v_nx10*l_nx10+v_ny10*l_ny10)>0.9){
	dx0=v_x0-l_x0;
	dx1=v_x0-l_x1;
	dy0=v_y0-l_y0;
	dy1=v_y0-l_y1;
	dist0=min(sqrt(dx0*dx0+dy0*dy0),sqrt(dx1*dx1+dy1*dy1));

	dx0=v_x1-l_x0;
	dx1=v_x1-l_x1;
	dy0=v_y1-l_y0;
	dy1=v_y1-l_y1;
	dist1=min(sqrt(dx0*dx0+dy0*dy0),sqrt(dx1*dx1+dy1*dy1));

	if((mindist0+mindist1)>(dist0+dist1)){
	  mindist0=dist0;
	  mindist1=dist1;
	}
      }
    }
    val+=exp(mnoise*(mindist0+mindist1));
  }
  return val;
}

void RectangleFilter::setCenters(float *cxy){
  memcpy(cxylist,cxy,8*sizeof(float));
}

void RectangleFilter::stateToVertices(float *state,float *verts){
  int i,idx;
  for(i=0;i<4;i++){
    idx=i*2;
    verts[idx]=rangex*state[idx]+cxylist[idx];
    idx++;
    verts[idx]=rangey*state[idx]+cxylist[idx];
  }

}

void RectangleFilter::getVertices(float *verts){
  memcpy(verts,vertices,8*sizeof(float));
}

void RectangleFilter::setLines(vector<float> lvs){
  lines.assign(lvs.begin(),lvs.end());
}

///////////////////////////////

MarkerGenerationHough::MarkerGenerationHough(){
  width=640;
  height=480;
  cvinimage=cvCreateImage(cvSize(width,height),IPL_DEPTH_8U,1);
  cvcannyimage=cvCreateImage(cvSize(width,height),IPL_DEPTH_8U,1);
  cvoutimage=cvCreateImage(cvSize(width,height),IPL_DEPTH_8U,3);
  inbuf=(unsigned char *)cvinimage->imageData;
  outbuf=(unsigned char *)cvoutimage->imageData;
  cvcannylow=30.0;
  cvcannyhigh=90.0;
  cvhoughthresh=50;
  cvhoughlength=200.0;
  cvhoughcat=10.0;
  storage=cvCreateMemStorage(0);
  symhough=new SymmetricHough(cvcannyimage);
}
MarkerGenerationHough::~MarkerGenerationHough(){
  cvReleaseImage(&cvinimage);
  cvReleaseImage(&cvcannyimage);
  cvReleaseImage(&cvoutimage);
  cvReleaseMemStorage (&storage);
  delete symhough;
}

void MarkerGenerationHough::setInImage(unsigned char *buf){
  // buf = unisngend char [640*480*3]
  int i,idx;

  for(i=0;i<640*480;i++){
    idx=i*3;
    inbuf[i]=(unsigned char)(((3*buf[idx]+6*buf[idx+1]+buf[idx+2])/10));
    outbuf[idx]=buf[idx+2];
    outbuf[idx+1]=buf[idx+1];
    outbuf[idx+2]=buf[idx];
  }

}

void MarkerGenerationHough::getOutImage(unsigned char *buf){
  // buf = unisngend char [640*480*3]
  int i,idx;

  for(i=0;i<640*480;i++){
    idx=i*3;
    buf[idx]=outbuf[idx+2];
    buf[idx+1]=outbuf[idx+1];
    buf[idx+2]=outbuf[idx];
  }
}

void MarkerGenerationHough::getCannyImage(unsigned char *buf){
  // buf = unisngend char [640*480*3]
  int i,idx;
  unsigned char *cannybuf=(unsigned char *)cvcannyimage->imageData;

  for(i=0;i<640*480;i++){
    idx=i*3;
    buf[idx]=cannybuf[i];
    buf[idx+1]=cannybuf[i];
    buf[idx+2]=cannybuf[i];
  }
}

void MarkerGenerationHough::procSymmetry(){  
  cvCanny(cvinimage,cvcannyimage,cvcannylow,cvcannyhigh);
  cvDilate(cvcannyimage,cvcannyimage);
  symhough->setInImage(cvcannyimage);
  symhough->convert();

  vector<int> best10(symhough->getBest10());

  symhough->convertOnce(best10[1],best10[2]);
  cvCopy(symhough->getSymmetricalEdgeImage(),cvoutimage);
}

void MarkerGenerationHough::proc(){
  CvPoint *point;
  int idx;

  cvCanny(cvinimage,cvcannyimage,cvcannylow,cvcannyhigh);
  //cvErode(cvcannyimage,cvcannyimage);
  //cvDilate(cvcannyimage,cvcannyimage);
  cvDilate(cvcannyimage,cvcannyimage);
  lines=cvHoughLines2(cvcannyimage,storage,CV_HOUGH_PROBABILISTIC,1,CV_PI/180,cvhoughthresh,cvhoughlength,cvhoughcat);
  nlines=lines->total;

  cout << nlines << " line(s) found." << endl;

  linevector.resize(nlines*4);
  for (int i = 0; i < nlines; i++) {
    point = (CvPoint *) cvGetSeqElem (lines, i);
    cvLine (cvoutimage, point[0], point[1], CV_RGB (0, 255, 0), 3, CV_AA, 0);
    idx=i*4;
    linevector[idx]=point[0].x;
    linevector[idx+1]=point[0].y;
    linevector[idx+2]=point[1].x;
    linevector[idx+3]=point[1].y;
  }

}

bool MarkerGenerationHough::fitToRect(){
  int i,j,k;
  int lidx;
  int idxlist[4];

  float line_verts[16];
  float line_nv[8];
  float line_norm[4];
  float innerp[3];
  float vx0,vx1,vy0,vy1;
  float vx01,vy01,vnorm;

  if(linevector.size()<16) return false;

  for(i=0;i<100;i++){
    generateRandomIndexList(4,nlines,idxlist);
    for(j=0;j<4;j++){
      lidx=idxlist[j];
      for(k=0;k<4;k++){
	line_verts[j*4+k]=linevector[lidx*4+k];
      }
      vx0=line_verts[j*4];
      vy0=line_verts[j*4+1];
      vx1=line_verts[j*4+2];
      vy1=line_verts[j*4+3];
      vx01=vx1-vx0;
      vy01=vy1-vy0;
      vnorm=sqrt(vx01*vx01+vy01*vy01);
      line_nv[j*2]=vx01/vnorm;
      line_nv[j*2+1]=vy01/vnorm;
      line_norm[j]=vnorm;
    }

    // inner-production check
    int ip_cnt_zero=0,ip_cnt_one=0;
    char ip_cases[3];
    float ip_verts[8];
    float ip_dist;
    int ip_cnt=0;
    ip_cases[0]=ip_cases[1]=ip_cases[2]=-1;
    for(j=0;j<3;j++){
      innerp[j]=
	line_nv[0]*line_nv[(j+1)*2]+
	line_nv[1]*line_nv[(j+1)*2+1];
      if(fabs(innerp[j])<0.1){
	ip_cnt_zero++;
	ip_cases[j]=0;
      }else if(fabs(innerp[j])>0.9){
	for(k=0;k<4;k++){
	  ip_verts[k]=line_verts[k];
	  ip_verts[k+4]=line_verts[(j+1)*4+k];
	}
	ip_dist=distanceLineVertices(ip_verts);
	/*
	cerr << "  (" << ip_verts[0] << ", " << ip_verts[1] << ") - ("
	     << ip_verts[2] << ", " << ip_verts[3] << ")," << endl;
	cerr << "  (" << ip_verts[4] << ", " << ip_verts[5] << ") - ("
	     << ip_verts[6] << ", " << ip_verts[7] << ")" << endl;
	cerr << "   dist = " << ip_dist << endl;
	*/
	if(ip_dist>100.0){
	  ip_cnt_one++;
	  ip_cases[j]=1;
	}
      }
    }

    if(ip_cnt_zero==2 && ip_cnt_one==1){
      for(j=0;j<3;j++){
	if(ip_cases[j]==0){
	  for(k=0;k<4;k++){
	    ip_verts[ip_cnt*4+k]=line_verts[(j+1)*4+k];
	  }
	  ip_cnt++;
	}
      }
      ip_dist=distanceLineVertices(ip_verts);
      if(ip_dist>100.0){
	for(j=0;j<4;j++){
	  cvLine (cvoutimage,
		  cvPoint((int)line_verts[j*4],(int)line_verts[j*4+1]),
		  cvPoint((int)line_verts[j*4+2],(int)line_verts[j*4+3]),
		  CV_RGB (255, 0, 0), 3, CV_AA, 0);
	}
	return true;
      }
    }
  }
  return false;
}

///////////////////////////////////////

void mgComCircle(markergen_draw_command *com,int cx,int cy,int rr){
  com->type=MG_CIRCLE;
  com->points[0]=cx;
  com->points[1]=cy;
  com->points[2]=rr;
  com->points[3]=0;
}
void mgComLine(markergen_draw_command *com,int x0,int y0,int x1,int y1){
  com->type=MG_LINE;
  com->points[0]=x0;
  com->points[1]=y0;
  com->points[2]=x1;
  com->points[3]=y1;
}
void mgDraw(IplImage *img,markergen_draw_command *com,CvScalar color,int thickness){
  if(com->type==MG_CIRCLE){
    cvCircle(img,cvPoint(com->points[0],com->points[1]),com->points[2],color,thickness,8,0);
  }else if(com->type==MG_LINE){
    cvLine(img,cvPoint(com->points[0],com->points[1]),cvPoint(com->points[2],com->points[3]),color,thickness,8,0);
  }
}

///////////////////////////////////////


MarkerGenerationGraphCut::MarkerGenerationGraphCut(){
  width=640;
  height=480;
  cvinimage=cvCreateImage(cvSize(width,height),IPL_DEPTH_8U,3);
  cvoutimage=cvCreateImage(cvSize(width,height),IPL_DEPTH_8U,3);
  inbuf=(unsigned char *)cvinimage->imageData;
  outbuf=(unsigned char *)cvoutimage->imageData;

  cvlabelimage=cvCreateImage(cvSize(width,height),IPL_DEPTH_32S,1);
  cvZero(cvlabelimage);

  cvedgeimage=cvCreateImage(cvSize(width,height),IPL_DEPTH_8U,1);
  cvZero(cvedgeimage);

  storage=cvCreateMemStorage(0);

  persemat=cvCreateMat(3,3,CV_32F);
  setDefaultCommands();
}
MarkerGenerationGraphCut::~MarkerGenerationGraphCut(){
  cvReleaseImage(&cvinimage);
  cvReleaseImage(&cvoutimage);
  cvReleaseImage(&cvlabelimage);
  cvReleaseImage(&cvedgeimage);

  cvReleaseMemStorage (&storage);

  cvReleaseMat(&persemat);
}

void MarkerGenerationGraphCut::setInImage(unsigned char *buf){
  // buf = unisngend char [640*480*3]
  int i,idx;

  for(i=0;i<640*480;i++){
    idx=i*3;
    outbuf[idx]=buf[idx+2];
    outbuf[idx+1]=buf[idx+1];
    outbuf[idx+2]=buf[idx];
  }
  memcpy(inbuf,outbuf,640*480*3);
}
void MarkerGenerationGraphCut::getInImage(unsigned char *buf){
  // buf = unisngend char [640*480*3]
  int i,idx;

  for(i=0;i<640*480;i++){
    idx=i*3;
    buf[idx]=inbuf[idx+2];
    buf[idx+1]=inbuf[idx+1];
    buf[idx+2]=inbuf[idx];
  }
}
void MarkerGenerationGraphCut::getOutImage(unsigned char *buf){
  // buf = unisngend char [640*480*3]
  int i,idx;

  for(i=0;i<640*480;i++){
    idx=i*3;
    buf[idx]=outbuf[idx+2];
    buf[idx+1]=outbuf[idx+1];
    buf[idx+2]=outbuf[idx];
  }
}

void MarkerGenerationGraphCut::setDefaultCommands(){
  fore_commands.resize(5);
  back_commands.resize(8);

  mgComCircle(&fore_commands[0],width/2,height/2,100);
  mgComCircle(&fore_commands[1],width/2+150,height/2-35,30);
  mgComCircle(&fore_commands[2],width/2-150,height/2-35,30);
  mgComCircle(&fore_commands[3],width/2+150,height/2+35,30);
  mgComCircle(&fore_commands[4],width/2-150,height/2+35,30);

  mgComCircle(&back_commands[0],40,40,20);
  mgComCircle(&back_commands[1],width/2,30,15);
  mgComCircle(&back_commands[2],width-40,40,20);
  mgComCircle(&back_commands[3],30,height/2,15);
  mgComCircle(&back_commands[4],width-30,height/2,15);
  mgComCircle(&back_commands[5],40,height-40,20);
  mgComCircle(&back_commands[6],width/2,height-30,15);
  mgComCircle(&back_commands[7],width-40,height-40,20);
}

void MarkerGenerationGraphCut::setMinimumCommands(){
  fore_commands.resize(1);
  back_commands.resize(4);

  mgComCircle(&fore_commands[0],width/2,height/2,8);

  mgComCircle(&back_commands[0],16,16,8);
  mgComCircle(&back_commands[1],width-16,16,8);
  mgComCircle(&back_commands[2],16,height-16,8);
  mgComCircle(&back_commands[3],width-16,height-16,8);
}

void MarkerGenerationGraphCut::addCommand(unsigned char ctype,markergen_draw_type type,int *pts){
  markergen_draw_command tmp;
  tmp.type=type;
  memcpy(tmp.points,pts,sizeof(int)*4);
  if(ctype==0) fore_commands.push_back(tmp);
  else back_commands.push_back(tmp);
}


void MarkerGenerationGraphCut::drawLabel(IplImage *img,CvScalar color0,CvScalar color1,int thickness){
  /*
  cvCircle(img,cvPoint(width/2,height/2),100,color0,thickness,8,0);
  cvCircle(img,cvPoint(width/2+150,height/2-35),30,color0,thickness,8,0);
  cvCircle(img,cvPoint(width/2-150,height/2-35),30,color0,thickness,8,0);
  cvCircle(img,cvPoint(width/2+150,height/2+35),30,color0,thickness,8,0);
  cvCircle(img,cvPoint(width/  for(int i=0;i<fore_commands.size();i++)
    mgDraw(img,&fore_commands[i],color0,thickness);2-150,height/2+35),30,color0,thickness,8,0);

  cvCircle(img,cvPoint(40,40),20,color1,thickness,8,0);
  cvCircle(img,cvPoint(width/2,30),15,color1,thickness,8,0);
  cvCircle(img,cvPoint(width-40,40),20,color1,thickness,8,0);
  cvCircle(img,cvPoint(30,height/2),15,color1,thickness,8,0);
  cvCircle(img,cvPoint(width-30,height/2),15,color1,thickness,8,0);
  cvCircle(img,cvPoint(40,height-40),20,color1,thickness,8,0);
  cvCircle(img,cvPoint(width/2,height-30),15,color1,thickness,8,0);
  cvCircle(img,cvPoint(width-40,height-40),20,color1,thickness,8,0);
  */

  for(int i=0;i<fore_commands.size();i++)
    mgDraw(img,&fore_commands[i],color0,thickness);
  for(int i=0;i<back_commands.size();i++)
    mgDraw(img,&back_commands[i],color1,thickness);

}

void MarkerGenerationGraphCut::clearLabel(){
  cvZero(cvlabelimage);
}

void MarkerGenerationGraphCut::initLabel(){
  cvZero(cvlabelimage);
  drawLabel(cvlabelimage,cvScalarAll(1),cvScalarAll(2),CV_FILLED);
}

void MarkerGenerationGraphCut::proc(){
  // nop in real-time proc
  drawLabel(cvoutimage,CV_RGB(255,0,0),CV_RGB(0,0,255),3);
}

void MarkerGenerationGraphCut::graphCut(){
  //memcpy(outbuf,inbuf,640*480*3);
  cvWatershed (cvinimage, cvlabelimage);
  cvZero(cvedgeimage);
  
  // from opencv sample
  for (int i = 20; i < height-20; i++) {
    for (int j = 20; j < width-20; j++) {
      int *idx = (int *) cvPtr2D (cvlabelimage, i, j, NULL);
      if (*idx == -1){
        //cvSet2D (cvoutimage, i, j, cvScalarAll (255));
	cvCircle(cvoutimage,cvPoint(j,i),2,CV_RGB(0,255,0),CV_FILLED,1,0);
      	//cvCircle(cvedgeimage,cvPoint(j,i),1,cvScalarAll(255),CV_FILLED,1,0);
        cvSet2D (cvedgeimage, i, j, cvScalarAll (255));
      }
    }
  }

  // hough transform
  lines=cvHoughLines2(cvedgeimage,storage,CV_HOUGH_STANDARD,1,CV_PI/180,50,0,0);
  //lines=cvHoughLines2(cvedgeimage,storage,CV_HOUGH_PROBABILISTIC,1,CV_PI/180,50,100,10);
  nlines=lines->total;

  cout << nlines << " line(s) found." << endl;

  float *line, rho, theta;
  double a, b, x0, y0;
  CvPoint *point, pt1, pt2;
  int ii;

  // standard
  linevector.resize(nlines*4);
  for (int i = 0; i < MIN (lines->total, 10); i++) {
    line = (float *) cvGetSeqElem (lines, i);
    rho = line[0];
    theta = line[1];
    a = cos (theta);
    b = sin (theta);
    x0 = a * rho;
    y0 = b * rho;
    pt1.x = cvRound (x0 + 1000 * (-b));
    pt1.y = cvRound (y0 + 1000 * (a));
    pt2.x = cvRound (x0 - 1000 * (-b));
    pt2.y = cvRound (y0 - 1000 * (a));
    cvLine (cvoutimage, pt1, pt2, CV_RGB (255, 255, 0), 3, 8, 0);
    ii=i*4;
    linevector[ii]=pt1.x;
    linevector[ii+1]=pt1.y;
    linevector[ii+2]=pt2.x;
    linevector[ii+3]=pt2.y;
  }


  // probablistic
  /*
  linevector.resize(nlines*4);
  for (int i = 0; i < nlines; i++) {
    point = (CvPoint *) cvGetSeqElem (lines, i);
    cvLine (cvoutimage, point[0], point[1], CV_RGB (255, 255, 0), 3, CV_AA, 0);
    ii=i*4;
    linevector[ii]=point[0].x;
    linevector[ii+1]=point[0].y;
    linevector[ii+2]=point[1].x;
    linevector[ii+3]=point[1].y;
  }
  */


}

bool MarkerGenerationGraphCut::fitToRect(){
  int i,j,k;
  int lidx;
  int idxlist[4];

  float line_verts[16];
  float line_nv[8];
  float line_norm[4];
  float innerp[3];
  float vx0,vx1,vy0,vy1;
  float vx01,vy01,vnorm;

  if(linevector.size()<16) return false;

  for(i=0;i<120;i++){
    generateRandomIndexList(4,nlines,idxlist);
    for(j=0;j<4;j++){
      lidx=idxlist[j];
      for(k=0;k<4;k++){
	line_verts[j*4+k]=linevector[lidx*4+k];
      }
      vx0=line_verts[j*4];
      vy0=line_verts[j*4+1];
      vx1=line_verts[j*4+2];
      vy1=line_verts[j*4+3];
      vx01=vx1-vx0;
      vy01=vy1-vy0;
      vnorm=sqrt(vx01*vx01+vy01*vy01);
      line_nv[j*2]=vx01/vnorm;
      line_nv[j*2+1]=vy01/vnorm;
      line_norm[j]=vnorm;
    }

    // inner-production check
    int ip_cnt_zero=0,ip_cnt_one=0;
    char ip_cases[3];
    float ip_verts[8];
    float ip_dist;
    int ip_cnt=0;
    vector<float> parallel_line;
    vector<float> vertical_line;

    ip_cases[0]=ip_cases[1]=ip_cases[2]=-1;
    for(j=0;j<3;j++){
      innerp[j]=
	line_nv[0]*line_nv[(j+1)*2]+
	line_nv[1]*line_nv[(j+1)*2+1];
      if(fabs(innerp[j])<0.1){
	ip_cnt_zero++;
	ip_cases[j]=0;
	for(k=0;k<4;k++){
	  vertical_line.push_back(line_verts[(j+1)*4+k]);
	}
      }else if(fabs(innerp[j])>0.9){
	for(k=0;k<4;k++){
	  ip_verts[k]=line_verts[k];
	  ip_verts[k+4]=line_verts[(j+1)*4+k];
	  parallel_line.push_back(line_verts[(j+1)*4+k]);
	}
	ip_dist=distanceLineVertices(ip_verts);
	/*
	cerr << "  (" << ip_verts[0] << ", " << ip_verts[1] << ") - ("
	     << ip_verts[2] << ", " << ip_verts[3] << ")," << endl;
	cerr << "  (" << ip_verts[4] << ", " << ip_verts[5] << ") - ("
	     << ip_verts[6] << ", " << ip_verts[7] << ")" << endl;
	cerr << "   dist = " << ip_dist << endl;
	*/
	if(ip_dist>100.0){
	  ip_cnt_one++;
	  ip_cases[j]=1;
	}
      }
    }

    if(ip_cnt_zero==2 && ip_cnt_one==1){
      for(j=0;j<3;j++){
	if(ip_cases[j]==0){
	  for(k=0;k<4;k++){
	    ip_verts[ip_cnt*4+k]=line_verts[(j+1)*4+k];
	  }
	  ip_cnt++;
	}
      }
      ip_dist=distanceLineVertices(ip_verts);
      if(ip_dist>100.0){
	// calc cross points
	for(k=0;k<4;k++)
	  ip_verts[k]=line_verts[k];
	for(j=0;j<2;j++){
	  for(k=0;k<4;k++)
	    ip_verts[4+k]=vertical_line[j*4+k];

	  crossPointLineVertices(ip_verts,rect_verts+j*2);
	}

	for(k=0;k<4;k++)
	  ip_verts[k]=parallel_line[k];
	for(j=0;j<2;j++){
	  for(k=0;k<4;k++)
	    ip_verts[4+k]=vertical_line[(1-j)*4+k];

	  crossPointLineVertices(ip_verts,rect_verts+(j+2)*2);
	}

	/*
	for(j=0;j<4;j++){
	  cvLine (cvoutimage,
		  cvPoint((int)line_verts[j*4],(int)line_verts[j*4+1]),
		  cvPoint((int)line_verts[j*4+2],(int)line_verts[j*4+3]),
		  CV_RGB (255, 0, 0), 3, CV_AA, 0);
	}
	*/


	for(j=0;j<4;j++){
	  cvLine (cvoutimage,
		  cvPoint((int)rect_verts[j*2],(int)rect_verts[j*2+1]),
		  cvPoint((int)rect_verts[((j+1)*2)%8],(int)rect_verts[((j+1)*2+1)%8]),
		  CV_RGB (255, 0, 0), 3, CV_AA, 0);
	}

	return true;
      }
    }
  }
  return false;
}


IplImage *MarkerGenerationGraphCut::generateMarkerImage(){
  IplImage *markimage=NULL;
  float nwidth,nheight;
  float vx0,vy0,vx1,vy1,length0,length1;
  vector<CvPoint2D32f> inscp,outscp;

  inscp.resize(4);
  outscp.resize(4);

  // modify index of rect_verts
  vx0=rect_verts[2]-rect_verts[0];
  vy0=rect_verts[3]-rect_verts[1];
  vx1=rect_verts[6]-rect_verts[0];
  vy1=rect_verts[7]-rect_verts[1];
  if((vx0*vy1-vx1*vy0)<0.0){
    vx0=rect_verts[2];
    vy0=rect_verts[3];
    vx1=rect_verts[6];
    vy1=rect_verts[7];
    rect_verts[2]=vx1;
    rect_verts[3]=vy1;
    rect_verts[6]=vx0;
    rect_verts[7]=vy0;
  }

  // calc marker size
  vx0=rect_verts[2]-rect_verts[0];
  vy0=rect_verts[3]-rect_verts[1];
  vx1=rect_verts[6]-rect_verts[4];
  vy1=rect_verts[7]-rect_verts[5];
  length0=sqrt(vx0*vx0+vy0*vy0);
  length1=sqrt(vx1*vx1+vy1*vy1);
  nwidth=(length0+length1)*0.5;

  vx0=rect_verts[6]-rect_verts[0];
  vy0=rect_verts[7]-rect_verts[1];
  vx1=rect_verts[2]-rect_verts[4];
  vy1=rect_verts[3]-rect_verts[5];
  length0=sqrt(vx0*vx0+vy0*vy0);
  length1=sqrt(vx1*vx1+vy1*vy1);
  nheight=(length0+length1)*0.5;

  markimage=cvCreateImage(cvSize((int)nwidth,(int)nheight),IPL_DEPTH_8U,3);

  // calc perspective transform
  for(int i=0;i<4;i++){
    inscp[i].x=rect_verts[i*2];
    inscp[i].y=rect_verts[i*2+1];
  }
  outscp[0].x=0.0;
  outscp[0].y=0.0;

  outscp[1].x=nwidth;
  outscp[1].y=0.0;

  outscp[2].x=nwidth;
  outscp[2].y=nheight;

  outscp[3].x=0.0;
  outscp[3].y=nheight;

  cvGetPerspectiveTransform(&inscp[0],&outscp[0],persemat);
  cvWarpPerspective(cvinimage,markimage,persemat);

  cout << "width: " << nwidth << "(" << markimage->widthStep << ")" << ", height: " << nheight << endl;


  return markimage;
}
